/*
 * Decompiled with CFR 0.152.
 */
package de.eddyson.tapestry.webjars;

import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.AbstractResource;
import org.slf4j.Logger;
import org.webjars.MultipleMatchesException;
import org.webjars.WebJarAssetLocator;

public class WebjarsResource
extends AbstractResource {
    public static final String VERSION_VARIABLE = "$version";
    private URL url;
    private boolean urlResolved;
    private final WebJarAssetLocator webJarAssetLocator;
    private final ClassLoader classLoader;
    private final Logger logger;

    public WebjarsResource(String path, WebJarAssetLocator webJarAssetLocator, LoggerSource loggerSource, ClassLoader classLoader) {
        this(path, webJarAssetLocator, loggerSource.getLogger(WebjarsResource.class), classLoader);
    }

    public WebjarsResource(String path, WebJarAssetLocator webJarAssetLocator, Logger logger, ClassLoader classLoader) {
        super(path);
        this.logger = logger;
        this.webJarAssetLocator = webJarAssetLocator;
        this.classLoader = classLoader;
    }

    public URL toURL() {
        try {
            this.acquireReadLock();
            if (!this.urlResolved) {
                this.resolveURL();
            }
            URL uRL = this.url;
            return uRL;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void resolveURL() {
        try {
            this.upgradeReadLockToWriteLock();
            if (!this.urlResolved) {
                String path = this.getPath();
                if (path.startsWith("META-INF/resources/webjars")) {
                    this.url = this.classLoader.getResource(path);
                    this.validateURL(this.url);
                }
                this.urlResolved = true;
            }
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    private String resolveVersionInPath(String path) {
        int indexOfVersionVariable = path.indexOf(VERSION_VARIABLE);
        if (indexOfVersionVariable >= 0) {
            LinkedList<String> candidates = new LinkedList<String>();
            for (Map.Entry e : this.webJarAssetLocator.getWebJars().entrySet()) {
                String webjar = (String)e.getKey();
                String version = (String)e.getValue();
                StringBuilder sb = new StringBuilder(path);
                sb.replace(indexOfVersionVariable, indexOfVersionVariable + VERSION_VARIABLE.length(), version);
                this.logger.debug("Trying {} in {}", (Object)sb, (Object)webjar);
                try {
                    String match = this.webJarAssetLocator.getFullPath(webjar, sb.toString());
                    if (match == null) continue;
                    this.logger.debug("Found candidate {} for {}", (Object)match, (Object)path);
                    candidates.add(match);
                }
                catch (MultipleMatchesException ex) {
                    candidates.addAll(ex.getMatches());
                }
                catch (IllegalArgumentException ex) {}
            }
            if (candidates.size() == 1) {
                return (String)candidates.get(0);
            }
            throw new MultipleMatchesException("Found multiple candidates for " + path + ", please specify a more specific path. e.g. by including the webjar in the asset path", candidates);
        }
        return path;
    }

    private String resolveVersionInPath(String webjar, String path) {
        int indexOfVersionVariable = path.indexOf(VERSION_VARIABLE);
        if (indexOfVersionVariable >= 0) {
            String maybeVersion = (String)this.webJarAssetLocator.getWebJars().get(webjar);
            this.logger.debug("Resolved {} for {} to {}", new Object[]{VERSION_VARIABLE, webjar, maybeVersion});
            if (maybeVersion != null) {
                StringBuilder sb = new StringBuilder(path);
                sb.replace(indexOfVersionVariable, indexOfVersionVariable + VERSION_VARIABLE.length(), maybeVersion);
                return sb.toString();
            }
        }
        return path;
    }

    protected Resource newResource(String path) {
        String p = path;
        if (!p.isEmpty() && p.charAt(0) == '/') {
            p = p.substring(1);
            int indexOfColon = p.indexOf(58);
            try {
                if (indexOfColon < 0) {
                    p = this.resolveVersionInPath(p);
                    this.logger.debug("Trying to resolve {}", (Object)p);
                    p = this.webJarAssetLocator.getFullPath(p);
                } else {
                    String webjar = p.substring(0, indexOfColon);
                    p = p.substring(indexOfColon + 1);
                    p = this.resolveVersionInPath(webjar, p);
                    this.logger.debug("Trying to resolve {} inside {} webjar", (Object)p, (Object)webjar);
                    p = this.webJarAssetLocator.getFullPath(webjar, this.resolveVersionInPath(webjar, p));
                }
            }
            catch (MultipleMatchesException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                return new WebjarsResource(path, this.webJarAssetLocator, this.logger, this.classLoader);
            }
        }
        return new WebjarsResource(p, this.webJarAssetLocator, this.logger, this.classLoader);
    }

    public String toString() {
        return "webjars:" + this.getPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.webJarAssetLocator == null ? 0 : this.webJarAssetLocator.hashCode());
        result = 31 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WebjarsResource other = (WebjarsResource)((Object)obj);
        if (this.webJarAssetLocator == null ? other.webJarAssetLocator != null : !this.webJarAssetLocator.equals(other.webJarAssetLocator)) {
            return false;
        }
        return !(this.getPath() == null ? other.getPath() != null : !this.getPath().equals(other.getPath()));
    }
}

