/*
 * Decompiled with CFR 0.152.
 */
package de.eddyson.tapestry.webjars;

import de.eddyson.tapestry.webjars.WebjarsAssetFactory;
import de.eddyson.tapestry.webjars.WebjarsAssetRequestHandler;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.AssetRequestDispatcher;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.assets.AssetRequestHandler;
import org.webjars.WebJarAssetLocator;

public final class WebjarsModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(AssetFactory.class, WebjarsAssetFactory.class).withSimpleId().eagerLoad();
        binder.bind(AssetRequestHandler.class, WebjarsAssetRequestHandler.class).withSimpleId().eagerLoad();
    }

    @Contribute(value=AssetSource.class)
    public static void addWebJarsAssetFactory(MappedConfiguration<String, AssetFactory> configuration, @Local AssetFactory webJarsAssetFactory) {
        configuration.add((Object)"webjars", (Object)webJarsAssetFactory);
    }

    @Contribute(value=Dispatcher.class)
    @AssetRequestDispatcher
    public static void addWebJarsAssetRequestHandler(MappedConfiguration<String, AssetRequestHandler> configuration, @Local AssetRequestHandler webJarsAssetRequestHandler) {
        configuration.add((Object)"webjars", (Object)webJarsAssetRequestHandler);
    }

    @EagerLoad
    public static WebJarAssetLocator buildWebJarAssetLocator() {
        SortedMap pathIndex = WebJarAssetLocator.getFullPathIndex((Pattern)Pattern.compile(".*"), (ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()});
        return new WebJarAssetLocator(pathIndex);
    }

    private WebjarsModule() {
    }
}

