/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.analysis;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import marytts.modules.acoustic.ProsodyElementHandler;
import marytts.unitselection.analysis.Phone;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.SelectedUnit;
import marytts.util.MaryUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProsodyAnalyzer {
    private List<SelectedUnit> units;
    private int sampleRate;
    private Logger logger;
    private List<Phone> phones;

    public ProsodyAnalyzer(List<SelectedUnit> units, int sampleRate) throws Exception {
        this.units = units;
        this.sampleRate = sampleRate;
        this.logger = MaryUtils.getLogger(this.getClass());
        this.phones = this.parseIntoPhones();
    }

    private List<Phone> parseIntoPhones() throws Exception {
        this.phones = new ArrayList<Phone>(this.units.size() / 2);
        int u = 0;
        while (u < this.units.size()) {
            SelectedUnit unit = this.units.get(u);
            HalfPhoneTarget target = (HalfPhoneTarget)unit.getTarget();
            if (target.isLeftHalf()) {
                if (u < this.units.size() - 1) {
                    SelectedUnit nextUnit = this.units.get(u + 1);
                    HalfPhoneTarget nextTarget = (HalfPhoneTarget)nextUnit.getTarget();
                    if (nextTarget.isRightHalf()) {
                        this.phones.add(new Phone(unit, nextUnit, this.sampleRate));
                        ++u;
                    } else {
                        this.phones.add(new Phone(unit, null, this.sampleRate));
                    }
                } else {
                    this.phones.add(new Phone(unit, null, this.sampleRate));
                }
            } else {
                this.phones.add(new Phone(null, unit, this.sampleRate));
            }
            ++u;
        }
        assert (u == this.units.size());
        this.insertTargetF0Values();
        return this.phones;
    }

    private void insertTargetF0Values() throws Exception {
        NodeList phoneNodes;
        try {
            phoneNodes = this.getPhoneNodes();
        }
        catch (Exception e) {
            throw new Exception("Could not get the phone Nodes from the Document", e);
        }
        int totalNumberOfFrames = this.getNumberOfFrames();
        ProsodyElementHandler elementHandler = new ProsodyElementHandler();
        double[] f0Targets = elementHandler.getF0Contour(phoneNodes, totalNumberOfFrames);
        int f0TargetStartIndex = 0;
        for (Phone phone : this.phones) {
            int numberOfLeftUnitFrames = phone.getNumberOfLeftUnitFrames();
            int f0TargetMidIndex = f0TargetStartIndex + numberOfLeftUnitFrames;
            double[] leftF0Targets = ArrayUtils.subarray((double[])f0Targets, (int)f0TargetStartIndex, (int)f0TargetMidIndex);
            phone.setLeftTargetF0Values(leftF0Targets);
            int numberOfRightUnitFrames = phone.getNumberOfRightUnitFrames();
            int f0TargetEndIndex = f0TargetMidIndex + numberOfRightUnitFrames;
            double[] rightF0Targets = ArrayUtils.subarray((double[])f0Targets, (int)f0TargetMidIndex, (int)f0TargetEndIndex);
            phone.setRightTargetF0Values(rightF0Targets);
            f0TargetStartIndex = f0TargetEndIndex;
        }
    }

    public List<Phone> getPhones() {
        return this.phones;
    }

    public List<Phone> getRealizedPhones() {
        ArrayList<Phone> realizedPhones = new ArrayList<Phone>(this.phones.size());
        for (Phone phone : this.phones) {
            if (!(phone.getPredictedDuration() > 0.0)) continue;
            realizedPhones.add(phone);
        }
        return realizedPhones;
    }

    private NodeList getPhoneNodes() throws Exception {
        NodeList phoneNodes;
        Document document = this.getDocument();
        try {
            phoneNodes = document.getElementsByTagName("ph");
        }
        catch (NullPointerException e) {
            throw new Exception("Could not access the Document!", e);
        }
        return phoneNodes;
    }

    private Document getDocument() {
        for (Phone phone : this.phones) {
            Element phoneElement = phone.getMaryXMLElement();
            if (phoneElement == null) continue;
            return phoneElement.getOwnerDocument();
        }
        return null;
    }

    private int getNumberOfFrames() {
        int totalNumberOfFrames = 0;
        for (Phone phone : this.phones) {
            totalNumberOfFrames += phone.getNumberOfFrames();
        }
        return totalNumberOfFrames;
    }

    public List<Double> getDurationFactors() {
        ArrayList<Double> durationFactors = new ArrayList<Double>(this.units.size());
        for (Phone phone : this.phones) {
            double rightDurationFactor;
            double leftDurationFactor = phone.getLeftDurationFactor();
            if (leftDurationFactor > 0.0) {
                durationFactors.add(leftDurationFactor);
                this.logger.debug((Object)("duration factor for unit " + phone.getLeftUnit().getTarget().getName() + " -> " + leftDurationFactor));
            }
            if (!((rightDurationFactor = phone.getRightDurationFactor()) > 0.0)) continue;
            durationFactors.add(rightDurationFactor);
            this.logger.debug((Object)("duration factor for unit " + phone.getRightUnit().getTarget().getName() + " -> " + rightDurationFactor));
        }
        return durationFactors;
    }

    public double[] getDurationFactorsFramewise() {
        double[] f0Factors = null;
        for (Phone phone : this.phones) {
            double[] phoneF0Factors = phone.getFramewiseDurationFactors();
            f0Factors = ArrayUtils.addAll(f0Factors, (double[])phoneF0Factors);
        }
        return f0Factors;
    }

    public double[] getFrameMidTimes() {
        double[] frameDurations = null;
        for (Phone phone : this.phones) {
            double[] phoneFrameDurations = phone.getFrameDurations();
            frameDurations = ArrayUtils.addAll(frameDurations, (double[])phoneFrameDurations);
        }
        assert (frameDurations != null);
        double[] frameMidTimes = new double[frameDurations.length];
        double frameStartTime = 0.0;
        int f = 0;
        while (f < frameDurations.length) {
            frameMidTimes[f] = frameStartTime + frameDurations[f] / 2.0;
            frameStartTime += frameDurations[f];
            ++f;
        }
        return frameMidTimes;
    }

    public double[] getF0Factors() {
        double[] f0Factors = null;
        for (Phone phone : this.phones) {
            double[] phoneF0Factors = phone.getF0Factors();
            f0Factors = ArrayUtils.addAll(f0Factors, (double[])phoneF0Factors);
        }
        return f0Factors;
    }

    public void writePraatDurationTier(String fileName) throws IOException {
        ArrayList<Double> times = new ArrayList<Double>(this.units.size() * 2);
        ArrayList<Double> values = new ArrayList<Double>(this.units.size() * 2);
        double time = 0.0;
        ListIterator<Phone> phoneIterator = this.phones.listIterator(1);
        while (phoneIterator.hasNext()) {
            Phone phone = phoneIterator.next();
            if (phone.getLeftUnitDuration() > 0.0) {
                times.add(time);
                values.add(phone.getLeftDurationFactor());
                times.add((time += phone.getLeftUnitDuration()) - 1.0E-15);
                values.add(phone.getLeftDurationFactor());
            }
            if (!(phone.getRightUnitDuration() > 0.0)) continue;
            times.add(time);
            values.add(phone.getRightDurationFactor());
            times.add((time += phone.getRightUnitDuration()) - 1.0E-15);
            values.add(phone.getRightDurationFactor());
        }
        File durationTierFile = new File(fileName);
        PrintWriter out = new PrintWriter(durationTierFile);
        out.println("\"ooTextFile\"");
        out.println("\"DurationTier\"");
        out.println(String.format("0 %f %d", time, times.size()));
        int i = 0;
        while (i < times.size()) {
            out.println(String.format("%.16f %f", times.get(i), values.get(i)));
            ++i;
        }
        out.close();
    }

    public void writePraatPitchTier(String fileName) throws IOException {
        ArrayList<Double> times = new ArrayList<Double>();
        ArrayList<Double> values = new ArrayList<Double>();
        double time = 0.0;
        ListIterator<Phone> phoneIterator = this.phones.listIterator(1);
        while (phoneIterator.hasNext()) {
            Phone phone = phoneIterator.next();
            double[] frameTimes = phone.getRealizedFrameDurations();
            double[] frameF0s = phone.getUnitFrameF0s();
            int f = 0;
            while (f < frameF0s.length) {
                times.add(time += frameTimes[f]);
                values.add(frameF0s[f]);
                ++f;
            }
        }
        File durationTierFile = new File(fileName);
        PrintWriter out = new PrintWriter(durationTierFile);
        out.println("\"ooTextFile\"");
        out.println("\"PitchTier\"");
        out.println(String.format("0 %f %d", time, times.size()));
        int i = 0;
        while (i < times.size()) {
            out.println(String.format("%.16f %f", times.get(i), values.get(i)));
            ++i;
        }
        out.close();
    }
}

