/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import marytts.tools.install.LanguageComponentDescription;
import marytts.tools.install.VoiceComponentDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstallFileParser {
    private static DocumentBuilder builder;
    private List<LanguageComponentDescription> languages = new ArrayList<LanguageComponentDescription>();
    private List<VoiceComponentDescription> voices = new ArrayList<VoiceComponentDescription>();

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            builder = null;
        }
    }

    public InstallFileParser(URL installFile) throws IOException, SAXException {
        Document doc;
        try {
            InputStream in = installFile.openStream();
            doc = builder.parse(in);
            in.close();
        }
        catch (Exception e) {
            throw new IOException("Problem parsing install file " + installFile, e);
        }
        Element docElt = doc.getDocumentElement();
        if (!docElt.getTagName().equals("marytts-install")) {
            throw new IllegalArgumentException("Expected <marytts-install> document, but found root node <" + docElt.getTagName() + ">!");
        }
        NodeList languageElements = docElt.getElementsByTagName("language");
        int i = 0;
        int max = languageElements.getLength();
        while (i < max) {
            Element languageElement = (Element)languageElements.item(i);
            this.languages.add(new LanguageComponentDescription(languageElement));
            ++i;
        }
        NodeList voiceElements = docElt.getElementsByTagName("voice");
        int i2 = 0;
        int max2 = voiceElements.getLength();
        while (i2 < max2) {
            Element voiceElement = (Element)voiceElements.item(i2);
            this.voices.add(new VoiceComponentDescription(voiceElement));
            ++i2;
        }
    }

    public List<LanguageComponentDescription> getLanguageDescriptions() {
        return this.languages;
    }

    public List<VoiceComponentDescription> getVoiceDescriptions() {
        return this.voices;
    }
}

