/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.acoustic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.features.FeatureVector;
import marytts.features.TargetFeatureComputer;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.UnitSelector;
import org.w3c.dom.Element;

public abstract class Model {
    protected InputStream dataStream;
    protected String voiceName;
    protected String targetAttributeName;
    protected String targetAttributeFormat;
    protected String featureName;
    protected FeatureProcessorManager featureManager;
    protected String predictionFeatureNames;
    protected TargetFeatureComputer featureComputer;
    protected String predictFrom;
    protected String applyTo;

    protected Model(FeatureProcessorManager featureManager, String voiceName, InputStream dataStream, String targetAttributeName, String targetAttributeFormat, String featureName, String predictFrom, String applyTo) {
        this.featureManager = featureManager;
        this.voiceName = voiceName;
        this.dataStream = dataStream;
        this.targetAttributeName = targetAttributeName;
        if (targetAttributeFormat == null) {
            targetAttributeFormat = "%s";
        }
        this.targetAttributeFormat = targetAttributeFormat;
        this.featureName = featureName;
        if (predictFrom == null) {
            predictFrom = "segments";
        }
        this.predictFrom = predictFrom;
        if (applyTo == null) {
            applyTo = "segments";
        }
        this.applyTo = applyTo;
    }

    protected final void load() throws MaryConfigurationException {
        try {
            this.loadData();
        }
        catch (IOException ioe) {
            throw new MaryConfigurationException("Cannot load model data from stream", (Throwable)ioe);
        }
        this.setupFeatureComputer();
    }

    protected abstract void loadData() throws IOException, MaryConfigurationException;

    protected final void setupFeatureComputer() throws MaryConfigurationException {
        try {
            this.featureComputer = FeatureRegistry.getTargetFeatureComputer(this.featureManager, this.predictionFeatureNames);
        }
        catch (IllegalArgumentException iae) {
            throw new MaryConfigurationException("Incompatible features between model and feature processor manager.\nThe model needs the following features:\n" + this.predictionFeatureNames + "\n" + "The FeatureProcessorManager for locale " + this.featureManager.getLocale() + " (" + this.featureManager.getClass().toString() + ") can produce the following features:\n" + this.featureManager.listFeatureProcessorNames(), (Throwable)iae);
        }
    }

    public void applyTo(List<Element> elements) throws MaryConfigurationException {
        this.applyFromTo(elements, elements);
    }

    public void applyFromTo(List<Element> predictFromElements, List<Element> applyToElements) throws MaryConfigurationException {
        assert (predictFromElements != null);
        assert (applyToElements != null);
        assert (predictFromElements.size() == applyToElements.size());
        List<Target> predictFromTargets = this.getTargets(predictFromElements);
        int i = 0;
        while (i < applyToElements.size()) {
            float targetValue;
            Target target = predictFromTargets.get(i);
            try {
                targetValue = this.evaluate(target);
            }
            catch (Exception e) {
                throw new MaryConfigurationException("Could not predict value for target: '" + target + "'", (Throwable)e);
            }
            Element element = applyToElements.get(i);
            if (this.targetAttributeName.startsWith("@")) {
                this.targetAttributeName = this.targetAttributeName.replaceFirst("@", "");
            }
            String formattedTargetValue = null;
            try {
                formattedTargetValue = String.format(this.targetAttributeFormat, Float.valueOf(targetValue));
            }
            catch (Exception e) {
                throw new MaryConfigurationException("Could not format target value '" + targetValue + "' using format '" + this.targetAttributeFormat + "'", (Throwable)e);
            }
            if (element.hasAttribute(this.targetAttributeName)) {
                formattedTargetValue = String.valueOf(element.getAttribute(this.targetAttributeName)) + " " + formattedTargetValue;
            }
            element.setAttribute(this.targetAttributeName, formattedTargetValue);
            ++i;
        }
    }

    protected List<Target> getTargets(List<Element> elements) {
        ArrayList<Target> targets = new ArrayList<Target>(elements.size());
        for (Element element : elements) {
            assert (element.getTagName() == "ph");
            String phone = UnitSelector.getPhoneSymbol(element);
            Target target = new Target(phone, element);
            targets.add(target);
            FeatureVector targetFeatureVector = this.featureComputer.computeFeatureVector(target);
            target.setFeatureVector(targetFeatureVector);
            element.setUserData("target", target, Target.targetFeatureCloner);
        }
        return targets;
    }

    protected abstract float evaluate(Target var1) throws Exception;

    public String getVoiceName() {
        return this.voiceName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getTargetAttributeName() {
        return this.targetAttributeName;
    }

    public String getPredictFrom() {
        return this.predictFrom;
    }

    public String getApplyTo() {
        return this.applyTo;
    }
}

