/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.io.DataOutput;
import java.io.IOException;
import marytts.features.FeatureDefinition;

public class FeatureVector {
    public final int unitIndex;
    public final byte[] byteValuedDiscreteFeatures;
    public final short[] shortValuedDiscreteFeatures;
    public final float[] continuousFeatures;

    public FeatureVector(byte[] byteValuedDiscreteFeatures, short[] shortValuedDiscreteFeatures, float[] continuousFeatures, int setUnitIndex) {
        this.byteValuedDiscreteFeatures = byteValuedDiscreteFeatures;
        this.shortValuedDiscreteFeatures = shortValuedDiscreteFeatures;
        this.continuousFeatures = continuousFeatures;
        if (setUnitIndex < 0) {
            throw new RuntimeException("The unit index can't be negative or null when instanciating a new feature vector.");
        }
        this.unitIndex = setUnitIndex;
    }

    public boolean isEdgeVector(int edgeIndex) {
        String edgeValue = this.getFeature(edgeIndex).toString();
        return !edgeValue.equals("0");
    }

    public FeatureType getFeatureType(int featureIndex) {
        FeatureType t = null;
        if (featureIndex < 0 || featureIndex >= this.byteValuedDiscreteFeatures.length + this.shortValuedDiscreteFeatures.length + this.continuousFeatures.length) {
            throw new IllegalArgumentException("Index " + featureIndex + " is out of range [0, " + this.getLength() + "[");
        }
        if (featureIndex < this.byteValuedDiscreteFeatures.length) {
            t = FeatureType.byteValued;
        } else if (featureIndex < this.byteValuedDiscreteFeatures.length + this.shortValuedDiscreteFeatures.length) {
            t = FeatureType.shortValued;
        } else if (featureIndex < this.byteValuedDiscreteFeatures.length + this.shortValuedDiscreteFeatures.length + this.continuousFeatures.length) {
            t = FeatureType.floatValued;
        }
        return t;
    }

    public int getLength() {
        return this.byteValuedDiscreteFeatures.length + this.shortValuedDiscreteFeatures.length + this.continuousFeatures.length;
    }

    public int getUnitIndex() {
        return this.unitIndex;
    }

    public int getNumberOfByteFeatures() {
        return this.byteValuedDiscreteFeatures.length;
    }

    public int getNumberOfShortFeatures() {
        return this.shortValuedDiscreteFeatures.length;
    }

    public int getNumberOfContinuousFeatures() {
        return this.continuousFeatures.length;
    }

    public Number getFeature(int index) {
        if (index < this.byteValuedDiscreteFeatures.length) {
            return new Byte(this.byteValuedDiscreteFeatures[index]);
        }
        if ((index -= this.byteValuedDiscreteFeatures.length) < this.shortValuedDiscreteFeatures.length) {
            return new Short(this.shortValuedDiscreteFeatures[index]);
        }
        if ((index -= this.shortValuedDiscreteFeatures.length) < this.continuousFeatures.length) {
            return new Float(this.continuousFeatures[index]);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getFeatureAsInt(int index) {
        return this.getFeature(index).intValue();
    }

    public String getFeatureAsString(int index, FeatureDefinition feaDef) {
        if (index < this.byteValuedDiscreteFeatures.length) {
            return feaDef.getFeatureValueAsString(index, this.byteValuedDiscreteFeatures[index]);
        }
        throw new IndexOutOfBoundsException();
    }

    public final byte getByteFeature(int index) {
        if (index < 0 || index >= this.byteValuedDiscreteFeatures.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " is not between 0 and " + this.byteValuedDiscreteFeatures.length);
        }
        return this.byteValuedDiscreteFeatures[index];
    }

    public final short getShortFeature(int index) {
        return this.shortValuedDiscreteFeatures[index - this.byteValuedDiscreteFeatures.length];
    }

    public final float getContinuousFeature(int index) {
        return this.continuousFeatures[index - this.byteValuedDiscreteFeatures.length - this.shortValuedDiscreteFeatures.length];
    }

    public boolean isByteFeature(int index) {
        return index >= 0 && index < this.byteValuedDiscreteFeatures.length;
    }

    public boolean isShortFeature(int index) {
        return this.byteValuedDiscreteFeatures.length <= index && index < this.byteValuedDiscreteFeatures.length + this.shortValuedDiscreteFeatures.length;
    }

    public boolean isContinuousFeature(int index) {
        return this.byteValuedDiscreteFeatures.length + this.shortValuedDiscreteFeatures.length <= index && index < this.byteValuedDiscreteFeatures.length + this.shortValuedDiscreteFeatures.length + this.continuousFeatures.length;
    }

    public byte[] getByteValuedDiscreteFeatures() {
        return this.byteValuedDiscreteFeatures;
    }

    public short[] getShortValuedDiscreteFeatures() {
        return this.shortValuedDiscreteFeatures;
    }

    public float[] getContinuousFeatures() {
        return this.continuousFeatures;
    }

    public void writeTo(DataOutput out) throws IOException {
        int i;
        if (this.byteValuedDiscreteFeatures != null) {
            out.write(this.byteValuedDiscreteFeatures);
        }
        if (this.shortValuedDiscreteFeatures != null) {
            i = 0;
            while (i < this.shortValuedDiscreteFeatures.length) {
                out.writeShort(this.shortValuedDiscreteFeatures[i]);
                ++i;
            }
        }
        if (this.continuousFeatures != null) {
            i = 0;
            while (i < this.continuousFeatures.length) {
                out.writeFloat(this.continuousFeatures[i]);
                ++i;
            }
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < this.byteValuedDiscreteFeatures.length) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(this.byteValuedDiscreteFeatures[i]);
            ++i;
        }
        i = 0;
        while (i < this.shortValuedDiscreteFeatures.length) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(this.shortValuedDiscreteFeatures[i]);
            ++i;
        }
        i = 0;
        while (i < this.continuousFeatures.length) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append(this.continuousFeatures[i]);
            ++i;
        }
        return out.toString();
    }

    public static enum FeatureType {
        byteValued,
        shortValued,
        floatValued;

    }
}

