/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.impose;

import java.util.Comparator;
import marytts.features.FeatureVector;

public class FeatureComparator
implements Comparator<FeatureVector> {
    private int I = -1;
    private FeatureVector.FeatureType type = null;

    public FeatureComparator(int setI, FeatureVector.FeatureType featureType) {
        this.setFeatureIdx(setI, featureType);
    }

    public void setFeatureIdx(int setI, FeatureVector.FeatureType featureType) {
        this.I = setI;
        this.type = featureType;
    }

    public int getFeatureIdx() {
        return this.I;
    }

    @Override
    public int compare(FeatureVector a, FeatureVector b) {
        switch (this.type) {
            case byteValued: {
                return a.byteValuedDiscreteFeatures[this.I] - b.byteValuedDiscreteFeatures[this.I];
            }
            case shortValued: {
                int offset = a.byteValuedDiscreteFeatures.length;
                return a.shortValuedDiscreteFeatures[this.I - offset] - b.shortValuedDiscreteFeatures[this.I - offset];
            }
            case floatValued: {
                int offset2 = a.byteValuedDiscreteFeatures.length + a.shortValuedDiscreteFeatures.length;
                float delta = a.continuousFeatures[this.I - offset2] - b.continuousFeatures[this.I - offset2];
                if (delta > 0.0f) {
                    return 1;
                }
                if (delta < 0.0f) {
                    return -1;
                }
                return 0;
            }
        }
        throw new IllegalStateException("compare called with feature index " + this.I + " and feature type " + (Object)((Object)this.type));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureComparator)) {
            return false;
        }
        return ((FeatureComparator)obj).getFeatureIdx() == this.I;
    }
}

