/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.Voice;
import marytts.util.data.audio.AppendableSequenceAudioInputStream;
import org.xml.sax.SAXException;

public abstract class SynthesisCallerBase
extends InternalModule {
    protected SynthesisCallerBase(String name, MaryDataType inputType, MaryDataType outputType) {
        super(name, inputType, outputType, null);
    }

    @Override
    public synchronized void startup() throws Exception {
        super.startup();
    }

    @Override
    public synchronized void powerOnSelfTest() {
    }

    @Override
    public MaryData process(MaryData d) throws TransformerConfigurationException, TransformerException, FileNotFoundException, IOException, ParserConfigurationException, SAXException, Exception {
        assert (d.getAudioFileFormat() != null);
        assert (this.getState() == 1);
        String cfr_ignored_0 = (String)d.getData();
        Voice defaultVoice = d.getDefaultVoice();
        if (defaultVoice == null) {
            defaultVoice = Voice.getDefaultVoice(Locale.GERMAN);
            assert (defaultVoice != null);
            this.logger.info((Object)("No default voice associated with data. Assuming global default " + defaultVoice.getName()));
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setAudioFileFormat(d.getAudioFileFormat());
        d.getAudioFileFormat().getFormat();
        if (d.getAudio() != null) {
            assert (d.getAudio() instanceof AppendableSequenceAudioInputStream);
            result.setAudio(d.getAudio());
        }
        return result;
    }

    protected AudioInputStream convertIfNeededAndPossible(AudioInputStream input, AudioFormat format, String voiceName) {
        if (input.getFormat().equals(format)) {
            return input;
        }
        this.logger.info((Object)("Conversion required for voice " + voiceName));
        if (AudioSystem.isConversionSupported(format, input.getFormat())) {
            return AudioSystem.getAudioInputStream(format, input);
        }
        this.logger.warn((Object)("Conversion to audio format " + format + " not supported. Providing voice default instead: " + input.getFormat()));
        return input;
    }

    public abstract AudioInputStream synthesiseOneSection(String var1, Voice var2) throws IOException;
}

