/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.MaryModule;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.log4j.Logger;

public class ModuleRegistry {
    private static MultiKeyMap mkm = new MultiKeyMap();
    private static List<MaryModule> allModules = new ArrayList<MaryModule>();
    private static boolean registrationComplete = false;
    private static Logger logger = MaryUtils.getLogger((String)"ModuleRegistry");

    private ModuleRegistry() {
    }

    public static MaryModule instantiateModule(String moduleInitInfo) throws MaryConfigurationException {
        logger.info((Object)("Now initiating mary module '" + moduleInitInfo + "'"));
        MaryModule m = (MaryModule)MaryRuntimeUtils.instantiateObject(moduleInitInfo);
        return m;
    }

    public static void registerModule(MaryModule module, Locale locale, Voice voice) throws IllegalStateException {
        ArrayList<MaryModule> l;
        if (registrationComplete) {
            throw new IllegalStateException("cannot register modules after registration is complete");
        }
        MaryDataType type = module.inputType();
        Object o = mkm.get((Object)type, (Object)locale, (Object)voice);
        if (o != null) {
            assert (o instanceof List) : "Expected List of MaryModules, got " + o.getClass();
            l = (ArrayList<MaryModule>)o;
        } else {
            l = new ArrayList<MaryModule>(1);
            mkm.put((Object)type, (Object)locale, (Object)voice, l);
        }
        assert (l != null);
        l.add(module);
        allModules.add(module);
        MaryDataType.registerDataType(type);
        MaryDataType.registerDataType(module.outputType());
    }

    public static boolean getRegistrationComplete() {
        return registrationComplete;
    }

    public static void setRegistrationComplete() throws IllegalStateException {
        if (registrationComplete) {
            throw new IllegalStateException("Registration has already completed, cannot do that a second time");
        }
        registrationComplete = true;
        MaryDataType.setRegistrationComplete();
    }

    public static List<MaryModule> getAllModules() {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about modules while registration is ongoing");
        }
        return Collections.unmodifiableList(allModules);
    }

    public static MaryModule getModule(Class<?> moduleClass) {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about modules while registration is ongoing");
        }
        for (MaryModule m : allModules) {
            if (!moduleClass.isInstance(m)) continue;
            return m;
        }
        return null;
    }

    public static LinkedList<MaryModule> modulesRequiredForProcessing(MaryDataType sourceType, MaryDataType targetType, Locale locale) {
        return ModuleRegistry.modulesRequiredForProcessing(sourceType, targetType, locale, null);
    }

    public static LinkedList<MaryModule> modulesRequiredForProcessing(MaryDataType sourceType, MaryDataType targetType, Locale locale, Voice voice) {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about modules while registration is ongoing");
        }
        if (sourceType == null) {
            throw new NullPointerException("Received null source type");
        }
        if (targetType == null) {
            throw new NullPointerException("Received null target type");
        }
        LinkedList<MaryDataType> seenTypes = new LinkedList<MaryDataType>();
        seenTypes.add(sourceType);
        return ModuleRegistry.modulesRequiredForProcessing(sourceType, targetType, locale, voice, seenTypes);
    }

    private static LinkedList<MaryModule> modulesRequiredForProcessing(MaryDataType sourceType, MaryDataType targetType, Locale locale, Voice voice, LinkedList<MaryDataType> seenTypes) {
        if (sourceType.equals(targetType)) {
            logger.debug((Object)"found path through modules");
            return new LinkedList<MaryModule>();
        }
        List<MaryModule> candidates = null;
        if (voice != null) {
            candidates = voice.getPreferredModulesAcceptingType(sourceType);
        }
        if (candidates == null || candidates.isEmpty()) {
            candidates = ModuleRegistry.get(sourceType, locale, voice);
        }
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (MaryModule candidate : candidates) {
            MaryDataType outputType = candidate.outputType();
            if (seenTypes.contains(outputType)) continue;
            seenTypes.add(outputType);
            logger.debug((Object)("Module " + candidate.name() + " converts " + sourceType.name() + " into " + outputType + " (locale " + locale + ", voice " + voice + ")"));
            LinkedList<MaryModule> path = ModuleRegistry.modulesRequiredForProcessing(outputType, targetType, locale, voice, seenTypes);
            if (path != null) {
                path.addFirst(candidate);
                return path;
            }
            seenTypes.removeLast();
        }
        return null;
    }

    private static List<MaryModule> get(MaryDataType type, Locale locale, Voice voice) throws IllegalStateException {
        boolean haveCountry;
        Locale langOnly;
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about modules while registration is ongoing");
        }
        LinkedHashMap<MaryDataType, MaryModule> results = new LinkedHashMap<MaryDataType, MaryModule>();
        ArrayList<List> listOfLists = new ArrayList<List>();
        listOfLists.add((List)mkm.get((Object)type, (Object)locale, (Object)voice));
        Locale locale2 = langOnly = locale != null ? new Locale(locale.getLanguage()) : null;
        boolean bl = langOnly == null ? false : (haveCountry = !langOnly.equals(locale));
        if (haveCountry) {
            listOfLists.add((List)mkm.get((Object)type, (Object)langOnly, (Object)voice));
        }
        listOfLists.add((List)mkm.get((Object)type, (Object)locale, null));
        if (haveCountry) {
            listOfLists.add((List)mkm.get((Object)type, (Object)langOnly, null));
        }
        listOfLists.add((List)mkm.get((Object)type, null, null));
        for (List list : listOfLists) {
            if (list == null) continue;
            for (MaryModule m : list) {
                if (results.containsKey(m.outputType())) continue;
                results.put(m.outputType(), m);
            }
        }
        ArrayList<MaryModule> returnList = new ArrayList<MaryModule>();
        for (MaryDataType t : results.keySet()) {
            returnList.add((MaryModule)results.get(t));
        }
        return returnList;
    }
}

