/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Properties;
import marytts.cart.CART;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.util.data.MaryHeader;

public class MaryCARTReader {
    public CART load(String fileName) throws IOException, MaryConfigurationException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            CART cART = this.loadFromStream(fis);
            return cART;
        }
    }

    public CART loadFromStream(InputStream inStream) throws IOException, MaryConfigurationException {
        Node rootNode;
        Properties props;
        DataInputStream raf = new DataInputStream(new BufferedInputStream(inStream));
        MaryHeader maryHeader = new MaryHeader((DataInput)raf);
        if (!maryHeader.hasCurrentVersion()) {
            throw new IOException("Wrong version of database file");
        }
        if (maryHeader.getType() != 100) {
            throw new IOException("No CARTs file");
        }
        short propDataLength = raf.readShort();
        if (propDataLength == 0) {
            props = null;
        } else {
            byte[] propsData = new byte[propDataLength];
            raf.readFully(propsData);
            ByteArrayInputStream bais = new ByteArrayInputStream(propsData);
            props = new Properties();
            props.load(bais);
            bais.close();
        }
        FeatureDefinition featureDefinition = new FeatureDefinition(raf);
        int numDecNodes = raf.readInt();
        DecisionNode[] dns = new DecisionNode[numDecNodes];
        int[][] childIndexes = new int[numDecNodes][];
        int i = 0;
        while (i < numDecNodes) {
            int featureNameIndex = raf.readInt();
            int nodeTypeNr = raf.readInt();
            DecisionNode.Type nodeType = DecisionNode.Type.values()[nodeTypeNr];
            int numChildren = 2;
            switch (nodeType) {
                case BinaryByteDecisionNode: {
                    int criterion = raf.readInt();
                    dns[i] = new DecisionNode.BinaryByteDecisionNode(featureNameIndex, (byte)criterion, featureDefinition);
                    break;
                }
                case BinaryShortDecisionNode: {
                    int criterion = raf.readInt();
                    dns[i] = new DecisionNode.BinaryShortDecisionNode(featureNameIndex, (short)criterion, featureDefinition);
                    break;
                }
                case BinaryFloatDecisionNode: {
                    float floatCriterion = raf.readFloat();
                    dns[i] = new DecisionNode.BinaryFloatDecisionNode(featureNameIndex, floatCriterion, featureDefinition);
                    break;
                }
                case ByteDecisionNode: {
                    numChildren = raf.readInt();
                    if (featureDefinition.getNumberOfValues(featureNameIndex) != numChildren) {
                        throw new IOException("Inconsistent cart file: feature " + featureDefinition.getFeatureName(featureNameIndex) + " should have " + featureDefinition.getNumberOfValues(featureNameIndex) + " values, but decision node " + i + " has only " + numChildren + " child nodes");
                    }
                    dns[i] = new DecisionNode.ByteDecisionNode(featureNameIndex, numChildren, featureDefinition);
                    break;
                }
                case ShortDecisionNode: {
                    numChildren = raf.readInt();
                    if (featureDefinition.getNumberOfValues(featureNameIndex) != numChildren) {
                        throw new IOException("Inconsistent cart file: feature " + featureDefinition.getFeatureName(featureNameIndex) + " should have " + featureDefinition.getNumberOfValues(featureNameIndex) + " values, but decision node " + i + " has only " + numChildren + " child nodes");
                    }
                    dns[i] = new DecisionNode.ShortDecisionNode(featureNameIndex, numChildren, featureDefinition);
                }
            }
            childIndexes[i] = new int[numChildren];
            int k = 0;
            while (k < numChildren) {
                childIndexes[i][k] = raf.readInt();
                ++k;
            }
            ++i;
        }
        int numLeafNodes = raf.readInt();
        LeafNode[] lns = new LeafNode[numLeafNodes];
        int j = 0;
        while (j < numLeafNodes) {
            int leafTypeNr = raf.readInt();
            LeafNode.LeafType leafNodeType = LeafNode.LeafType.values()[leafTypeNr];
            switch (leafNodeType) {
                case IntArrayLeafNode: {
                    int numData = raf.readInt();
                    int[] data = new int[numData];
                    int d = 0;
                    while (d < numData) {
                        data[d] = raf.readInt();
                        ++d;
                    }
                    lns[j] = new LeafNode.IntArrayLeafNode(data);
                    break;
                }
                case FloatLeafNode: {
                    float stddev = raf.readFloat();
                    float mean = raf.readFloat();
                    lns[j] = new LeafNode.FloatLeafNode(new float[]{stddev, mean});
                    break;
                }
                case IntAndFloatArrayLeafNode: 
                case StringAndFloatLeafNode: {
                    int numPairs = raf.readInt();
                    int[] ints = new int[numPairs];
                    float[] floats = new float[numPairs];
                    int d = 0;
                    while (d < numPairs) {
                        ints[d] = raf.readInt();
                        floats[d] = raf.readFloat();
                        ++d;
                    }
                    if (leafNodeType == LeafNode.LeafType.IntAndFloatArrayLeafNode) {
                        lns[j] = new LeafNode.IntAndFloatArrayLeafNode(ints, floats);
                        break;
                    }
                    lns[j] = new LeafNode.StringAndFloatLeafNode(ints, floats);
                    break;
                }
                case FeatureVectorLeafNode: {
                    throw new IllegalArgumentException("Reading feature vector leaf nodes is not yet implemented");
                }
                case PdfLeafNode: {
                    throw new IllegalArgumentException("Reading pdf leaf nodes is not yet implemented");
                }
            }
            ++j;
        }
        int i2 = 0;
        while (i2 < numDecNodes) {
            int k = 0;
            while (k < childIndexes[i2].length) {
                int childIndex = childIndexes[i2][k];
                if (childIndex < 0) {
                    assert (-childIndex - 1 < numDecNodes);
                    dns[i2].addDaughter(dns[-childIndex - 1]);
                } else if (childIndex > 0) {
                    dns[i2].addDaughter(lns[childIndex - 1]);
                } else {
                    dns[i2].addDaughter(null);
                }
                ++k;
            }
            ++i2;
        }
        if (dns.length > 0) {
            rootNode = dns[0];
            rootNode.countData();
        } else {
            rootNode = lns.length > 0 ? lns[0] : null;
        }
        return new CART(rootNode, featureDefinition, props);
    }

    private CART loadFromByteBuffer(String fileName) throws IOException, MaryConfigurationException {
        Node rootNode;
        Properties props;
        FileInputStream fis = new FileInputStream(fileName);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        fis.close();
        MaryHeader maryHeader = new MaryHeader((ByteBuffer)bb);
        if (!maryHeader.hasCurrentVersion()) {
            throw new IOException("Wrong version of database file");
        }
        if (maryHeader.getType() != 100) {
            throw new IOException("No CARTs file");
        }
        short propDataLength = bb.getShort();
        if (propDataLength == 0) {
            props = null;
        } else {
            byte[] propsData = new byte[propDataLength];
            bb.get(propsData);
            ByteArrayInputStream bais = new ByteArrayInputStream(propsData);
            props = new Properties();
            props.load(bais);
            bais.close();
        }
        FeatureDefinition featureDefinition = new FeatureDefinition(bb);
        int numDecNodes = bb.getInt();
        DecisionNode[] dns = new DecisionNode[numDecNodes];
        int[][] childIndexes = new int[numDecNodes][];
        int i = 0;
        while (i < numDecNodes) {
            int featureNameIndex = bb.getInt();
            int nodeTypeNr = bb.getInt();
            DecisionNode.Type nodeType = DecisionNode.Type.values()[nodeTypeNr];
            int numChildren = 2;
            switch (nodeType) {
                case BinaryByteDecisionNode: {
                    int criterion = bb.getInt();
                    dns[i] = new DecisionNode.BinaryByteDecisionNode(featureNameIndex, (byte)criterion, featureDefinition);
                    break;
                }
                case BinaryShortDecisionNode: {
                    int criterion = bb.getInt();
                    dns[i] = new DecisionNode.BinaryShortDecisionNode(featureNameIndex, (short)criterion, featureDefinition);
                    break;
                }
                case BinaryFloatDecisionNode: {
                    float floatCriterion = bb.getFloat();
                    dns[i] = new DecisionNode.BinaryFloatDecisionNode(featureNameIndex, floatCriterion, featureDefinition);
                    break;
                }
                case ByteDecisionNode: {
                    numChildren = bb.getInt();
                    if (featureDefinition.getNumberOfValues(featureNameIndex) != numChildren) {
                        throw new IOException("Inconsistent cart file: feature " + featureDefinition.getFeatureName(featureNameIndex) + " should have " + featureDefinition.getNumberOfValues(featureNameIndex) + " values, but decision node " + i + " has only " + numChildren + " child nodes");
                    }
                    dns[i] = new DecisionNode.ByteDecisionNode(featureNameIndex, numChildren, featureDefinition);
                    break;
                }
                case ShortDecisionNode: {
                    numChildren = bb.getInt();
                    if (featureDefinition.getNumberOfValues(featureNameIndex) != numChildren) {
                        throw new IOException("Inconsistent cart file: feature " + featureDefinition.getFeatureName(featureNameIndex) + " should have " + featureDefinition.getNumberOfValues(featureNameIndex) + " values, but decision node " + i + " has only " + numChildren + " child nodes");
                    }
                    dns[i] = new DecisionNode.ShortDecisionNode(featureNameIndex, numChildren, featureDefinition);
                }
            }
            childIndexes[i] = new int[numChildren];
            int k = 0;
            while (k < numChildren) {
                childIndexes[i][k] = bb.getInt();
                ++k;
            }
            ++i;
        }
        int numLeafNodes = bb.getInt();
        LeafNode[] lns = new LeafNode[numLeafNodes];
        int j = 0;
        while (j < numLeafNodes) {
            int leafTypeNr = bb.getInt();
            LeafNode.LeafType leafNodeType = LeafNode.LeafType.values()[leafTypeNr];
            switch (leafNodeType) {
                case IntArrayLeafNode: {
                    int numData = bb.getInt();
                    int[] data = new int[numData];
                    int d = 0;
                    while (d < numData) {
                        data[d] = bb.getInt();
                        ++d;
                    }
                    lns[j] = new LeafNode.IntArrayLeafNode(data);
                    break;
                }
                case FloatLeafNode: {
                    float stddev = bb.getFloat();
                    float mean = bb.getFloat();
                    lns[j] = new LeafNode.FloatLeafNode(new float[]{stddev, mean});
                    break;
                }
                case IntAndFloatArrayLeafNode: 
                case StringAndFloatLeafNode: {
                    int numPairs = bb.getInt();
                    int[] ints = new int[numPairs];
                    float[] floats = new float[numPairs];
                    int d = 0;
                    while (d < numPairs) {
                        ints[d] = bb.getInt();
                        floats[d] = bb.getFloat();
                        ++d;
                    }
                    if (leafNodeType == LeafNode.LeafType.IntAndFloatArrayLeafNode) {
                        lns[j] = new LeafNode.IntAndFloatArrayLeafNode(ints, floats);
                        break;
                    }
                    lns[j] = new LeafNode.StringAndFloatLeafNode(ints, floats);
                    break;
                }
                case FeatureVectorLeafNode: {
                    throw new IllegalArgumentException("Reading feature vector leaf nodes is not yet implemented");
                }
                case PdfLeafNode: {
                    throw new IllegalArgumentException("Reading pdf leaf nodes is not yet implemented");
                }
            }
            ++j;
        }
        int i2 = 0;
        while (i2 < numDecNodes) {
            int k = 0;
            while (k < childIndexes[i2].length) {
                int childIndex = childIndexes[i2][k];
                if (childIndex < 0) {
                    assert (-childIndex - 1 < numDecNodes);
                    dns[i2].addDaughter(dns[-childIndex - 1]);
                } else if (childIndex > 0) {
                    dns[i2].addDaughter(lns[childIndex - 1]);
                } else {
                    dns[i2].addDaughter(null);
                }
                ++k;
            }
            ++i2;
        }
        if (dns.length > 0) {
            rootNode = dns[0];
            rootNode.countData();
        } else {
            rootNode = lns.length > 0 ? lns[0] : null;
        }
        return new CART(rootNode, featureDefinition, props);
    }
}

