/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.maven.jacoco;

import de.dentrassi.maven.jacoco.ReportSupport;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;

@Mojo(defaultPhase=LifecyclePhase.VERIFY, name="xml", requiresProject=true, inheritByDefault=true)
public class XmlMojo
extends AbstractMojo {
    @Parameter(property="jacoco.extras.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="jacoco.extras.execFile", defaultValue="${project.build.directory}/jacoco.exec", required=true)
    private File execFile;
    @Parameter(property="jacoco.extras.xmlFile", defaultValue="${project.build.directory}/jacoco.xml", required=true)
    private File xmlFile;
    @Parameter(property="project.build.sourceEncoding", defaultValue="UTF-8")
    private String sourceEncoding;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (!this.execFile.isFile()) {
            this.getLog().debug((CharSequence)"Not running. No execution data found.");
            return;
        }
        try {
            this.xmlFile.getParentFile().mkdirs();
            ReportSupport report = new ReportSupport(this.getLog());
            report.loadExecutionData(this.execFile);
            report.addXmlFormatter(this.xmlFile, "UTF-8");
            IReportVisitor visitor = report.initRootVisitor();
            IReportGroupVisitor group = visitor.visitGroup("XML");
            for (MavenProject dependency : this.findDependencies("compile", "runtime")) {
                report.processProject(group, dependency.getArtifactId(), dependency, this.includes, this.excludes, this.sourceEncoding);
            }
            visitor.visitEnd();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to convert to XML", (Exception)e);
        }
    }

    private List<MavenProject> findDependencies(String ... scopes) {
        LinkedList<MavenProject> result = new LinkedList<MavenProject>();
        HashSet<String> scopeList = new HashSet<String>(Arrays.asList(scopes));
        for (Dependency dependency : this.project.getDependencies()) {
            MavenProject project;
            if (!scopeList.contains(dependency.getScope()) || (project = this.findProjectFromReactor(dependency)) == null) continue;
            result.add(project);
        }
        return result;
    }

    private MavenProject findProjectFromReactor(Dependency d) {
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(d.getGroupId()) || !p.getArtifactId().equals(d.getArtifactId()) || !p.getVersion().equals(d.getVersion())) continue;
            return p;
        }
        return null;
    }
}

