/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.scada.ui.databinding.ViewerLabelProvider;

public class ListeningLabelProvider
extends ViewerLabelProvider {
    private final ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            Iterator it = event.diff.getAdditions().iterator();
            while (it.hasNext()) {
                ListeningLabelProvider.this.addListenerTo(it.next());
            }
            it = event.diff.getRemovals().iterator();
            while (it.hasNext()) {
                ListeningLabelProvider.this.removeListenerFrom(it.next());
            }
        }
    };
    private final Set<IObservableSet> sources = new HashSet<IObservableSet>();
    private boolean disposed;

    public ListeningLabelProvider(IObservableSet itemsThatNeedLabels) {
        this.addSource(itemsThatNeedLabels);
    }

    public ListeningLabelProvider() {
    }

    protected void addSource(IObservableSet observableSet) {
        if (observableSet == null) {
            return;
        }
        this.sources.add(observableSet);
        observableSet.addSetChangeListener(this.listener);
        Iterator it = observableSet.iterator();
        while (it.hasNext()) {
            this.addListenerTo(it.next());
        }
    }

    protected void removeSource(IObservableSet observableSet) {
        if (observableSet == null) {
            return;
        }
        Iterator it = observableSet.iterator();
        while (it.hasNext()) {
            this.removeListenerFrom(it.next());
        }
        observableSet.removeSetChangeListener(this.listener);
        if (!this.disposed) {
            this.sources.remove(observableSet);
        }
    }

    protected void addListenerTo(Object next) {
    }

    protected void removeListenerFrom(Object next) {
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        for (IObservableSet set : this.sources) {
            if (!set.isDisposed()) {
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    this.removeListenerFrom(iter.next());
                }
            }
            set.removeSetChangeListener(this.listener);
        }
        super.dispose();
    }
}

