/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.crypto.pem;

import de.dentrassi.crypto.pem.AbstractPemKeyStore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class PemUtils {
    private static final String SOURCE_PREFIX = "source.";

    public static Map<String, AbstractPemKeyStore.Entry> loadFrom(InputStream stream, boolean chained) throws CertificateException, IOException {
        HashMap<String, AbstractPemKeyStore.Entry> result = new HashMap<String, AbstractPemKeyStore.Entry>();
        PemUtils.loadFrom(result, "pem", chained, stream);
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, AbstractPemKeyStore.Entry> loadFromConfiguration(InputStream stream) throws CertificateException, IOException {
        HashMap<String, AbstractPemKeyStore.Entry> result = new HashMap<String, AbstractPemKeyStore.Entry>();
        Properties p = new Properties();
        p.load(stream);
        String alias = p.getProperty("alias", "pem");
        for (String key : p.stringPropertyNames()) {
            if (!key.startsWith(SOURCE_PREFIX)) continue;
            FileInputStream source = new FileInputStream(new File(p.getProperty(key)));
            Throwable throwable = null;
            try {
                PemUtils.loadFrom(result, alias, true, source);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (source == null) continue;
                if (throwable != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                source.close();
            }
        }
        return result;
    }

    private static void loadFrom(Map<String, AbstractPemKeyStore.Entry> result, String alias, boolean chained, InputStream stream) throws CertificateException, IOException {
        Object object;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
        PEMParser reader = new PEMParser((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        PrivateKey key = null;
        int counter = 0;
        while ((object = reader.readObject()) != null) {
            if (object instanceof X509CertificateHolder) {
                X509CertificateHolder certHolder = (X509CertificateHolder)object;
                Collection<? extends Certificate> certs = factory.generateCertificates(new ByteArrayInputStream(certHolder.getEncoded()));
                for (Certificate certificate : certs) {
                    if (chained) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        chain.add(certificate);
                        continue;
                    }
                    result.put(alias + "-" + counter++, new AbstractPemKeyStore.Entry(null, new Certificate[]{certificate}));
                }
                continue;
            }
            if (!(object instanceof PEMKeyPair)) continue;
            key = converter.getKeyPair((PEMKeyPair)object).getPrivate();
        }
        Certificate[] certificateChain = chain.isEmpty() ? null : (Certificate[])chain.toArray(new X509Certificate[chain.size()]);
        AbstractPemKeyStore.Entry e = new AbstractPemKeyStore.Entry(key, certificateChain);
        result.compute(alias, (k, v) -> {
            if (v != null) {
                return v.merge(e);
            }
            return e;
        });
    }
}

