/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.node;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.CategoryAware;
import de.danielbechler.diff.access.ExclusionAware;
import de.danielbechler.diff.access.PropertyAwareAccessor;
import de.danielbechler.diff.access.RootAccessor;
import de.danielbechler.diff.access.TypeAwareAccessor;
import de.danielbechler.diff.instantiation.TypeInfo;
import de.danielbechler.diff.node.StopVisitationException;
import de.danielbechler.diff.node.Visit;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.selector.BeanPropertyElementSelector;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.diff.selector.RootElementSelector;
import de.danielbechler.util.Assert;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffNode {
    public static final DiffNode ROOT = null;
    private final Accessor accessor;
    private final Map<ElementSelector, DiffNode> children = new LinkedHashMap<ElementSelector, DiffNode>(10);
    private State state = State.UNTOUCHED;
    private DiffNode parentNode;
    private NodePath circleStartPath;
    private DiffNode circleStartNode;
    private Class<?> valueType;
    private TypeInfo valueTypeInfo;

    public DiffNode(Accessor accessor, Class<?> valueType) {
        this(ROOT, accessor, valueType);
    }

    public DiffNode(DiffNode parentNode, Accessor accessor, Class<?> valueType) {
        Assert.notNull(accessor, "accessor");
        this.accessor = accessor;
        this.valueType = valueType;
        this.setParentNode(parentNode);
    }

    public DiffNode(Class<?> valueType) {
        this(ROOT, RootAccessor.getInstance(), valueType);
    }

    public DiffNode() {
        this(ROOT, RootAccessor.getInstance(), null);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        Assert.notNull((Object)state, "state");
        this.state = state;
    }

    public boolean matches(NodePath path) {
        return path.matches(this.getPath());
    }

    public boolean hasChanges() {
        if (this.isAdded() || this.isChanged() || this.isRemoved()) {
            return true;
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        this.visitChildren(new Visitor(){

            public void node(DiffNode node, Visit visit) {
                if (node.hasChanges()) {
                    result.set(true);
                    visit.stop();
                }
            }
        });
        return result.get();
    }

    public final boolean isAdded() {
        return this.state == State.ADDED;
    }

    public final boolean isChanged() {
        return this.state == State.CHANGED;
    }

    public final boolean isRemoved() {
        return this.state == State.REMOVED;
    }

    public final boolean isUntouched() {
        return this.state == State.UNTOUCHED;
    }

    public boolean isCircular() {
        return this.state == State.CIRCULAR;
    }

    public NodePath getPath() {
        if (this.parentNode != null) {
            return NodePath.startBuildingFrom(this.parentNode.getPath()).element(this.accessor.getElementSelector()).build();
        }
        if (this.accessor instanceof RootAccessor) {
            return NodePath.withRoot();
        }
        return NodePath.startBuilding().element(this.accessor.getElementSelector()).build();
    }

    public ElementSelector getElementSelector() {
        return this.accessor.getElementSelector();
    }

    public Class<?> getValueType() {
        if (this.valueType != null) {
            return this.valueType;
        }
        if (this.valueTypeInfo != null) {
            return this.valueTypeInfo.getType();
        }
        if (this.accessor instanceof TypeAwareAccessor) {
            return ((TypeAwareAccessor)this.accessor).getType();
        }
        return null;
    }

    public void setType(Class<?> aClass) {
        this.valueType = aClass;
    }

    public TypeInfo getValueTypeInfo() {
        return this.valueTypeInfo;
    }

    public void setValueTypeInfo(TypeInfo typeInfo) {
        this.valueTypeInfo = typeInfo;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int childCount() {
        return this.children.size();
    }

    public DiffNode getChild(String propertyName) {
        return this.getChild(new BeanPropertyElementSelector(propertyName));
    }

    public DiffNode getChild(ElementSelector pathElementSelector) {
        return this.children.get(pathElementSelector);
    }

    public DiffNode getChild(NodePath nodePath) {
        if (this.parentNode != null) {
            return this.parentNode.getChild(nodePath.getElementSelectors());
        }
        return this.getChild(nodePath.getElementSelectors());
    }

    public DiffNode getChild(List<ElementSelector> selectors) {
        DiffNode child;
        Assert.notEmpty(selectors, "selectors");
        ElementSelector selector = selectors.get(0);
        if (selectors.size() == 1) {
            if (selector == RootElementSelector.getInstance()) {
                return this.isRootNode() ? this : null;
            }
            return this.getChild(selector);
        }
        if (selectors.size() > 1 && (child = selector == RootElementSelector.getInstance() ? (this.isRootNode() ? this : null) : this.getChild(selector)) != null) {
            return child.getChild(selectors.subList(1, selectors.size()));
        }
        return null;
    }

    public boolean addChild(DiffNode node) {
        if (node.isRootNode()) {
            throw new IllegalArgumentException("Detected attempt to add root node as child. This is not allowed and must be a mistake.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Detected attempt to add a node to itself. This would cause inifite loops and must never happen.");
        }
        if (node.getParentNode() != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("Detected attempt to add child node that is already the child of another node. Adding nodes multiple times is not allowed, since it could cause infinite loops.");
        }
        ElementSelector pathElementSelector = node.getElementSelector();
        if (node.getParentNode() == null) {
            node.setParentNode(this);
            this.children.put(pathElementSelector, node);
        } else if (node.getParentNode() == this) {
            this.children.put(pathElementSelector, node);
        } else {
            throw new IllegalStateException("Detected attempt to replace the parent node of node at path '" + this.getPath() + "'");
        }
        if (this.state == State.UNTOUCHED && node.hasChanges()) {
            this.state = State.CHANGED;
        }
        return true;
    }

    public final void visit(Visitor visitor) {
        Visit visit = new Visit();
        try {
            this.visit(visitor, visit);
        }
        catch (StopVisitationException stopVisitationException) {}
    }

    protected final void visit(Visitor visitor, Visit visit) {
        try {
            visitor.node(this, visit);
        }
        catch (StopVisitationException stopVisitationException) {
            visit.stop();
        }
        if (visit.isAllowedToGoDeeper() && this.hasChildren()) {
            this.visitChildren(visitor);
        }
        if (visit.isStopped()) {
            throw new StopVisitationException();
        }
    }

    public final void visitChildren(Visitor visitor) {
        for (DiffNode child : this.children.values()) {
            try {
                child.visit(visitor);
            }
            catch (StopVisitationException stopVisitationException) {
                return;
            }
        }
    }

    public final void visitParents(Visitor visitor) {
        Visit visit = new Visit();
        if (this.parentNode != null) {
            visitor.node(this.parentNode, visit);
            if (!visit.isStopped()) {
                this.parentNode.visitParents(visitor);
            }
        }
    }

    public Set<Annotation> getPropertyAnnotations() {
        if (this.accessor instanceof PropertyAwareAccessor) {
            return Collections.unmodifiableSet(((PropertyAwareAccessor)this.accessor).getReadMethodAnnotations());
        }
        return Collections.unmodifiableSet(Collections.emptySet());
    }

    public <T extends Annotation> T getPropertyAnnotation(Class<T> annotationClass) {
        if (this.accessor instanceof PropertyAwareAccessor) {
            return ((PropertyAwareAccessor)this.accessor).getReadMethodAnnotation(annotationClass);
        }
        return null;
    }

    public String getPropertyName() {
        if (this.isPropertyAware()) {
            return ((PropertyAwareAccessor)this.accessor).getPropertyName();
        }
        if (this.parentNode != null) {
            return this.parentNode.getPropertyName();
        }
        return null;
    }

    public final boolean isPropertyAware() {
        return this.accessor instanceof PropertyAwareAccessor;
    }

    public final boolean isRootNode() {
        return this.accessor instanceof RootAccessor;
    }

    public final boolean isIgnored() {
        return this.state == State.IGNORED;
    }

    @Deprecated
    public boolean isExcluded() {
        if (this.accessor instanceof ExclusionAware) {
            return ((ExclusionAware)((Object)this.accessor)).isExcludedByAnnotation();
        }
        return false;
    }

    public final Set<String> getCategories() {
        Set<String> categoriesFromAccessor;
        TreeSet<String> categories = new TreeSet<String>();
        if (this.parentNode != null) {
            categories.addAll(this.parentNode.getCategories());
        }
        if (this.accessor instanceof CategoryAware && (categoriesFromAccessor = ((CategoryAware)((Object)this.accessor)).getCategoriesFromAnnotation()) != null) {
            categories.addAll(categoriesFromAccessor);
        }
        return categories;
    }

    public DiffNode getParentNode() {
        return this.parentNode;
    }

    protected final void setParentNode(DiffNode parentNode) {
        if (this.parentNode != null && this.parentNode != parentNode) {
            throw new IllegalStateException("The parent of a node cannot be changed, once it's set.");
        }
        this.parentNode = parentNode;
    }

    public Object get(Object target) {
        return this.accessor.get(target);
    }

    public void set(Object target, Object value) {
        this.accessor.set(target, value);
    }

    public void unset(Object target) {
        this.accessor.unset(target);
    }

    public Object canonicalGet(Object target) {
        if (this.parentNode != null) {
            target = this.parentNode.canonicalGet(target);
        }
        return this.get(target);
    }

    public void canonicalSet(Object target, Object value) {
        if (this.parentNode != null) {
            Object parent = this.parentNode.canonicalGet(target);
            if (parent == null) {
                parent = this.parentNode.newInstance();
                this.parentNode.canonicalSet(target, parent);
            }
            target = parent;
        }
        this.set(target, value);
    }

    private Object newInstance() {
        if (this.valueTypeInfo != null) {
            return this.valueTypeInfo.newInstance();
        }
        return null;
    }

    public void canonicalUnset(Object target) {
        if (this.parentNode != null) {
            target = this.parentNode.canonicalGet(target);
        }
        this.unset(target);
    }

    public int hashCode() {
        return this.accessor.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffNode that = (DiffNode)o;
        return this.accessor.equals(that.accessor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append("state=");
        sb.append(this.getState().toString());
        if (this.getValueType() != null) {
            sb.append(", type=").append(this.getValueType().getCanonicalName());
        }
        if (this.childCount() == 1) {
            sb.append(", ").append(this.childCount()).append(" child");
        } else if (this.childCount() > 1) {
            sb.append(", ").append(this.childCount()).append(" children");
        } else {
            sb.append(", no children");
        }
        if (!this.getCategories().isEmpty()) {
            sb.append(", categorized as ").append(this.getCategories());
        }
        sb.append(", accessed via ").append(this.accessor);
        sb.append(')');
        return sb.toString();
    }

    public NodePath getCircleStartPath() {
        return this.circleStartPath;
    }

    public void setCircleStartPath(NodePath circularStartPath) {
        this.circleStartPath = circularStartPath;
    }

    public DiffNode getCircleStartNode() {
        return this.circleStartNode;
    }

    public void setCircleStartNode(DiffNode circleStartNode) {
        this.circleStartNode = circleStartNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ADDED("The value has been added to the working object"),
        CHANGED("The value exists but differs between the base and working object"),
        REMOVED("The value has been removed from the working object"),
        UNTOUCHED("The value is identical in the working and base object"),
        CIRCULAR("Special state to mark circular references"),
        IGNORED("The value has not been looked at and has been ignored"),
        INACCESSIBLE("When a comparison was not possible because the underlying value was not accessible");

        private final String reason;

        private State(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static interface Visitor {
        public void node(DiffNode var1, Visit var2);
    }
}

