/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.access;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.TypeAwareAccessor;
import de.danielbechler.diff.selector.CollectionItemElementSelector;
import de.danielbechler.diff.selector.ElementSelector;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionItemAccessor
implements TypeAwareAccessor,
Accessor {
    private final Object referenceItem;

    public CollectionItemAccessor(Object referenceItem) {
        this.referenceItem = referenceItem;
    }

    private static Collection<Object> objectAsCollection(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        throw new IllegalArgumentException(object.getClass().toString());
    }

    @Override
    public ElementSelector getElementSelector() {
        return new CollectionItemElementSelector(this.referenceItem);
    }

    @Override
    public void set(Object target, Object value) {
        Collection<Object> targetCollection = CollectionItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return;
        }
        Object previous = this.get(target);
        if (previous != null) {
            targetCollection.remove(previous);
        }
        targetCollection.add(value);
    }

    @Override
    public Object get(Object target) {
        Collection<Object> targetCollection = CollectionItemAccessor.objectAsCollection(target);
        if (targetCollection == null) {
            return null;
        }
        for (Object item : targetCollection) {
            if (item == null || !item.equals(this.referenceItem)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        return this.referenceItem != null ? this.referenceItem.getClass() : null;
    }

    @Override
    public void unset(Object target) {
        Collection<Object> targetCollection = CollectionItemAccessor.objectAsCollection(target);
        if (targetCollection != null) {
            targetCollection.remove(this.referenceItem);
        }
    }

    public String toString() {
        return "collection item " + this.getElementSelector();
    }
}

