/*
 * Decompiled with CFR 0.152.
 */
package de.cotech.sweetspot;

import android.animation.TimeInterpolator;
import android.app.Activity;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import de.cotech.sweetspot.NfcSweetspotData;
import de.cotech.sweetspot.R;

public class ShowNfcSweetspotActivity
extends Activity {
    private View sweetspotIndicator;
    private View sweetspotIcon;
    private View sweetspotCircle1;
    private View sweetspotCircle2;
    private View sweetspotCircle3;

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.overridePendingTransition(R.anim.fade_in_quick, R.anim.fade_out_quick);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_nfc_sweetspot);
        this.sweetspotIndicator = this.findViewById(R.id.indicator_nfc_sweetspot);
        Pair<Double, Double> nfcPosition = NfcSweetspotData.getSweetspotForBuildModel();
        if (nfcPosition == null) {
            throw new IllegalArgumentException("No data available for this model. This activity should not be called!");
        }
        DisplayMetrics displayDimensions = this.getDisplaySize();
        final float translationX = (float)((double)displayDimensions.widthPixels * (Double)nfcPosition.first);
        final float translationY = (float)((double)displayDimensions.heightPixels * (Double)nfcPosition.second);
        this.sweetspotIndicator.post(new Runnable(){

            @Override
            public void run() {
                ShowNfcSweetspotActivity.this.sweetspotIndicator.setTranslationX(translationX - (float)(ShowNfcSweetspotActivity.this.sweetspotIndicator.getWidth() / 2));
                ShowNfcSweetspotActivity.this.sweetspotIndicator.setTranslationY(translationY - (float)(ShowNfcSweetspotActivity.this.sweetspotIndicator.getHeight() / 2));
            }
        });
        this.sweetspotIcon = this.findViewById(R.id.icon_nfc_sweetspot);
        this.sweetspotCircle1 = this.findViewById(R.id.circle_nfc_sweetspot_1);
        this.sweetspotCircle2 = this.findViewById(R.id.circle_nfc_sweetspot_2);
        this.sweetspotCircle3 = this.findViewById(R.id.circle_nfc_sweetspot_3);
        this.sweetspotIcon.setAlpha(0.0f);
        this.sweetspotCircle1.setAlpha(0.0f);
        this.sweetspotCircle2.setAlpha(0.0f);
        this.sweetspotCircle3.setAlpha(0.0f);
    }

    public void onEnterAnimationComplete() {
        super.onEnterAnimationComplete();
        DecelerateInterpolator interpolator = new DecelerateInterpolator();
        this.sweetspotIcon.animate().alpha(1.0f).setInterpolator((TimeInterpolator)interpolator).setDuration(300L).start();
        this.sweetspotCircle1.animate().alpha(1.0f).setInterpolator((TimeInterpolator)interpolator).setDuration(500L).setStartDelay(100L).start();
        this.sweetspotCircle2.animate().alpha(1.0f).setInterpolator((TimeInterpolator)interpolator).setDuration(700L).setStartDelay(200L).start();
        this.sweetspotCircle3.animate().alpha(1.0f).setInterpolator((TimeInterpolator)interpolator).setDuration(1000L).setStartDelay(300L).start();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.fade_in_quick, R.anim.fade_out_quick);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getActionMasked() == 1) {
            this.setResult(0);
            this.finish();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private DisplayMetrics getDisplaySize() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }
}

