/*
 * Decompiled with CFR 0.152.
 */
package de.cotech.sweetspot;

import android.os.Build;
import android.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NfcSweetspotData {
    public static final Map<String, Pair<Double, Double>> SWEETSPOT_DATA;

    public static boolean hasSweetspotData() {
        return SWEETSPOT_DATA.containsKey(Build.MODEL);
    }

    public static Pair<Double, Double> getSweetspotForBuildModel() {
        return NfcSweetspotData.getSweetspotForBuildModel(Build.MODEL);
    }

    public static Pair<Double, Double> getSweetspotForBuildModel(String buildModel) {
        return SWEETSPOT_DATA.get(buildModel);
    }

    static {
        HashMap<String, Pair> data = new HashMap<String, Pair>();
        data.put("4G", new Pair((Object)0.541666666667, (Object)0.050406504065));
        data.put("7DTB37", new Pair((Object)0.5, (Object)0.410094637224));
        data.put("10DTB42", new Pair((Object)0.635, (Object)0.304942166141));
        data.put("306SH", new Pair((Object)0.494444444444, (Object)0.553791887125));
        data.put("402ZT", new Pair((Object)0.375, (Object)0.496323529412));
        data.put("404SC", new Pair((Object)0.947222222222, (Object)0.930194805195));
        data.put("503KC", new Pair((Object)0.561111111111, (Object)0.547535211268));
        data.put("601SO", new Pair((Object)0.336111111111, (Object)0.621478873239));
        data.put("710C", new Pair((Object)0.438888888889, (Object)0.363315696649));
        data.put("4047X", new Pair((Object)0.559375, (Object)0.637362637363));
        data.put("5011A", new Pair((Object)0.533333333333, (Object)0.56514084507));
        data.put("5017B", new Pair((Object)0.59375, (Object)0.444852941176));
        data.put("5027B", new Pair((Object)0.459375, (Object)0.461538461538));
        data.put("5042T", new Pair((Object)0.508333333333, (Object)0.569105691057));
        data.put("5049W", new Pair((Object)0.558333333333, (Object)0.485915492958));
        data.put("5049Z", new Pair((Object)0.45, (Object)0.521126760563));
        data.put("5051J", new Pair((Object)0.544444444444, (Object)0.569805194805));
        data.put("5051X", new Pair((Object)0.497222222222, (Object)0.517857142857));
        data.put("5054S", new Pair((Object)0.466666666667, (Object)0.658536585366));
        data.put("5054W", new Pair((Object)0.469444444444, (Object)0.505691056911));
        data.put("5056A", new Pair((Object)0.45, (Object)0.563311688312));
        data.put("5056D", new Pair((Object)0.341666666667, (Object)0.512987012987));
        data.put("5056E", new Pair((Object)0.572222222222, (Object)0.75));
        data.put("5056I", new Pair((Object)0.444444444444, (Object)0.517857142857));
        data.put("5056N", new Pair((Object)0.513888888889, (Object)0.456168831169));
        data.put("5056W", new Pair((Object)0.563888888889, (Object)0.607142857143));
        data.put("5065D", new Pair((Object)0.468144044321, (Object)0.531604538088));
        data.put("5065N", new Pair((Object)0.559556786704, (Object)0.544570502431));
        data.put("5070D", new Pair((Object)0.438888888889, (Object)0.582113821138));
        data.put("5080A", new Pair((Object)0.522222222222, (Object)0.628246753247));
        data.put("5560S", new Pair((Object)0.385041551247, (Object)0.741767764298));
        data.put("6039A", new Pair((Object)0.547222222222, (Object)0.57848324515));
        data.put("6039J", new Pair((Object)0.227777777778, (Object)0.742504409171));
        data.put("6039Y", new Pair((Object)0.336111111111, (Object)0.735915492958));
        data.put("6044D", new Pair((Object)0.6, (Object)0.550264550265));
        data.put("6055A", new Pair((Object)0.463888888889, (Object)0.429577464789));
        data.put("6055B", new Pair((Object)0.191666666667, (Object)0.25176056338));
        data.put("6055K", new Pair((Object)0.497222222222, (Object)0.375));
        data.put("6055P", new Pair((Object)0.247222222222, (Object)0.508802816901));
        data.put("6062W", new Pair((Object)0.366666666667, (Object)0.449386503067));
        data.put("7040N", new Pair((Object)0.419444444444, (Object)0.461788617886));
        data.put("7040T", new Pair((Object)0.413888888889, (Object)0.440650406504));
        data.put("7045Y", new Pair((Object)0.808333333333, (Object)0.49756097561));
        data.put("8030Y", new Pair((Object)0.713888888889, (Object)0.645528455285));
        data.put("8050D", new Pair((Object)0.513888888889, (Object)0.481300813008));
        data.put("8050G", new Pair((Object)0.539408866995, (Object)0.694404591105));
        data.put("9001D", new Pair((Object)0.452777777778, (Object)0.512987012987));
        data.put("9001X", new Pair((Object)0.522222222222, (Object)0.516233766234));
        data.put("9020A", new Pair((Object)0.903494176373, (Object)0.688413948256));
        data.put("9024W", new Pair((Object)0.494176372712, (Object)0.0415730337079));
        data.put("A0001", new Pair((Object)0.458333333333, (Object)0.487804878049));
        data.put("A1", new Pair((Object)0.577777777778, (Object)0.39837398374));
        data.put("A1-713", new Pair((Object)0.813333333333, (Object)0.106203995794));
        data.put("A1-734", new Pair((Object)0.724584103512, (Object)0.594382022472));
        data.put("A1 lite", new Pair((Object)0.491666666667, (Object)0.519480519481));
        data.put("A1P", new Pair((Object)0.638888888889, (Object)0.241883116883));
        data.put("A2", new Pair((Object)0.384375, (Object)0.592519685039));
        data.put("A3-A20", new Pair((Object)0.45375, (Object)0.12676056338));
        data.put("A3-A30", new Pair((Object)0.17625, (Object)0.135874067937));
        data.put("a4", new Pair((Object)0.45, (Object)0.297244094488));
        data.put("A5", new Pair((Object)0.208333333333, (Object)0.24025974026));
        data.put("A5_Ready", new Pair((Object)0.4125, (Object)0.543137254902));
        data.put("A6", new Pair((Object)0.702777777778, (Object)0.460162601626));
        data.put("A7", new Pair((Object)0.544444444444, (Object)0.595070422535));
        data.put("A7Pro", new Pair((Object)0.597222222222, (Object)0.392857142857));
        data.put("A8", new Pair((Object)0.5, (Object)0.396330275229));
        data.put("A11w", new Pair((Object)0.49375, (Object)0.126838235294));
        data.put("A33f", new Pair((Object)0.716666666667, (Object)0.552845528455));
        data.put("A33w", new Pair((Object)0.488888888889, (Object)0.413008130081));
        data.put("A37f", new Pair((Object)0.611111111111, (Object)0.352090032154));
        data.put("A37fw", new Pair((Object)0.511111111111, (Object)0.516077170418));
        data.put("A51f", new Pair((Object)0.469444444444, (Object)0.49593495935));
        data.put("A51w", new Pair((Object)0.722222222222, (Object)0.486178861789));
        data.put("A101", new Pair((Object)0.947222222222, (Object)0.946428571429));
        data.put("A464BG", new Pair((Object)0.425, (Object)0.487912087912));
        data.put("A466BG", new Pair((Object)0.471875, (Object)0.48431372549));
        data.put("A521L", new Pair((Object)0.515625, (Object)0.523622047244));
        data.put("A571VL", new Pair((Object)0.490625, (Object)0.544117647059));
        data.put("A577VL", new Pair((Object)0.547222222222, (Object)0.630281690141));
        data.put("A621BL", new Pair((Object)0.45, (Object)0.547967479675));
        data.put("A846L", new Pair((Object)0.603125, (Object)0.454044117647));
        data.put("A1601", new Pair((Object)0.530555555556, (Object)0.485530546624));
        data.put("Action-X3", new Pair((Object)0.927777777778, (Object)0.447183098592));
        data.put("AGM X1", new Pair((Object)0.491666666667, (Object)0.513821138211));
        data.put("Alcatel_4060A", new Pair((Object)0.584375, (Object)0.533088235294));
        data.put("Alcatel_5044C", new Pair((Object)0.465625, (Object)0.558608058608));
        data.put("Alcatel_5054O", new Pair((Object)0.586111111111, (Object)0.232520325203));
        data.put("Alcatel_5056O", new Pair((Object)0.455555555556, (Object)0.383739837398));
        data.put("Alcatel_5098O", new Pair((Object)0.466666666667, (Object)0.608766233766));
        data.put("Alcatel_6055U", new Pair((Object)0.5, (Object)0.505281690141));
        data.put("Alcatel_6060C", new Pair((Object)0.466666666667, (Object)0.649647887324));
        data.put("Alcatel_7049D", new Pair((Object)0.463888888889, (Object)0.564227642276));
        data.put("ALCATEL ONE TOUCH 5036A", new Pair((Object)0.61875, (Object)0.730392156863));
        data.put("ALCATEL ONE TOUCH 7041D", new Pair((Object)0.414583333333, (Object)0.487745098039));
        data.put("ALCATEL ONE TOUCH 7047D", new Pair((Object)0.333333333333, (Object)0.416485900217));
        data.put("ALCATEL ONETOUCH P310A", new Pair((Object)0.555, (Object)0.574132492114));
        data.put("Alpha_X", new Pair((Object)0.538888888889, (Object)0.291666666667));
        data.put("AP54", new Pair((Object)0.571875, (Object)0.560661764706));
        data.put("Aqua", new Pair((Object)0.471875, (Object)0.0330882352941));
        data.put("Aquaris E4", new Pair((Object)0.45625, (Object)0.505905511811));
        data.put("Aquaris E5", new Pair((Object)0.313888888889, (Object)0.738211382114));
        data.put("Aquaris E6", new Pair((Object)0.297222222222, (Object)0.617886178862));
        data.put("Aquaris M5", new Pair((Object)0.472222222222, (Object)0.49512987013));
        data.put("Aquaris M5.5", new Pair((Object)0.452777777778, (Object)0.491883116883));
        data.put("Aquaris U", new Pair((Object)0.434375, (Object)0.525974025974));
        data.put("Aquaris U Plus", new Pair((Object)0.430555555556, (Object)0.522727272727));
        data.put("Aquaris V", new Pair((Object)0.577777777778, (Object)0.319805194805));
        data.put("Aquaris X", new Pair((Object)0.477777777778, (Object)0.461038961039));
        data.put("Aquaris X5 Plus", new Pair((Object)0.561111111111, (Object)0.258802816901));
        data.put("Aquaris X Pro", new Pair((Object)0.461111111111, (Object)0.475649350649));
        data.put("Archos 50c Platinum", new Pair((Object)0.660194174757, (Object)0.4243281471));
        data.put("Archos Access 45 4G", new Pair((Object)0.534375, (Object)0.377510040161));
        data.put("Archos Core 50 4G", new Pair((Object)0.771844660194, (Object)0.689393939394));
        data.put("Armor_2", new Pair((Object)0.541666666667, (Object)0.541087231353));
        data.put("Armor_X", new Pair((Object)0.311111111111, (Object)0.610632183908));
        data.put("ASUS_A001", new Pair((Object)0.924074074074, (Object)0.711538461538));
        data.put("ASUS_A002", new Pair((Object)0.206310679612, (Object)0.110169491525));
        data.put("ASUS_A006", new Pair((Object)0.759708737864, (Object)0.0508474576271));
        data.put("ASUS_A007", new Pair((Object)0.725, (Object)0.491883116883));
        data.put("ASUS_A009", new Pair((Object)0.445754716981, (Object)0.492455418381));
        data.put("ASUS_T00E", new Pair((Object)0.459375, (Object)0.646365422397));
        data.put("ASUS_T00F", new Pair((Object)0.541666666667, (Object)0.546341463415));
        data.put("ASUS_T00G", new Pair((Object)0.6, (Object)0.471544715447));
        data.put("ASUS_T00I", new Pair((Object)0.4875, (Object)0.509842519685));
        data.put("ASUS_T00J", new Pair((Object)0.508333333333, (Object)0.273170731707));
        data.put("ASUS_T00K", new Pair((Object)0.511111111111, (Object)0.469918699187));
        data.put("ASUS_T00N", new Pair((Object)0.486111111111, (Object)0.530864197531));
        data.put("ASUS_T00Q", new Pair((Object)0.584375, (Object)0.529411764706));
        data.put("ASUS_X00DD", new Pair((Object)0.491666666667, (Object)0.555194805195));
        data.put("ASUS_X00ID", new Pair((Object)0.508333333333, (Object)0.49512987013));
        data.put("ASUS_X00QD", new Pair((Object)0.438888888889, (Object)0.520710059172));
        data.put("ASUS_X007D", new Pair((Object)0.427777777778, (Object)0.517857142857));
        data.put("ASUS_X008", new Pair((Object)0.508333333333, (Object)0.0721830985915));
        data.put("ASUS_X550", new Pair((Object)0.486111111111, (Object)0.52733686067));
        data.put("ASUS_Z00VD", new Pair((Object)0.425, (Object)0.466666666667));
        data.put("ASUS_Z002", new Pair((Object)0.272222222222, (Object)0.718699186992));
        data.put("ASUS_Z007", new Pair((Object)0.721875, (Object)0.4375));
        data.put("AX1065", new Pair((Object)0.828125, (Object)0.955882352941));
        data.put("B5531", new Pair((Object)0.438888888889, (Object)0.572357723577));
        data.put("Bay", new Pair((Object)0.647222222222, (Object)0.894308943089));
        data.put("BERRY", new Pair((Object)0.36875, (Object)0.406593406593));
        data.put("BL5000", new Pair((Object)0.488888888889, (Object)0.43661971831));
        data.put("BL7000", new Pair((Object)0.438888888889, (Object)0.545454545455));
        data.put("BL12000", new Pair((Object)0.530555555556, (Object)0.58024691358));
        data.put("Blade A460", new Pair((Object)0.565625, (Object)0.556985294118));
        data.put("Blade A510", new Pair((Object)0.4, (Object)0.555194805195));
        data.put("BLADE A520", new Pair((Object)0.602777777778, (Object)0.397727272727));
        data.put("Blade L2 Plus", new Pair((Object)0.6875, (Object)0.443014705882));
        data.put("Blade L5", new Pair((Object)0.534375, (Object)0.564338235294));
        data.put("BLADE L7", new Pair((Object)0.515625, (Object)0.587912087912));
        data.put("Blade S6", new Pair((Object)0.441666666667, (Object)0.242276422764));
        data.put("Blade V6", new Pair((Object)0.463888888889, (Object)0.482926829268));
        data.put("Blade V6 Plus", new Pair((Object)0.388888888889, (Object)0.543831168831));
        data.put("BLADE V8 SE", new Pair((Object)0.758333333333, (Object)0.902597402597));
        data.put("BQru-4500", new Pair((Object)0.35, (Object)0.177655677656));
        data.put("BV6000", new Pair((Object)0.461111111111, (Object)0.566558441558));
        data.put("BV6000S", new Pair((Object)0.505555555556, (Object)0.482142857143));
        data.put("BV7000", new Pair((Object)0.75, (Object)0.496753246753));
        data.put("BV7000 Pro", new Pair((Object)0.455555555556, (Object)0.689935064935));
        data.put("BV8000Pro", new Pair((Object)0.494444444444, (Object)0.49025974026));
        data.put("BV9000Pro", new Pair((Object)0.438888888889, (Object)0.483024691358));
        data.put("BV9000Pro-F", new Pair((Object)0.455188679245, (Object)0.470360824742));
        data.put("C1", new Pair((Object)0.658333333333, (Object)0.522727272727));
        data.put("C1+", new Pair((Object)0.658333333333, (Object)0.522727272727));
        data.put("C4", new Pair((Object)0.0555555555556, (Object)0.456168831169));
        data.put("C5", new Pair((Object)0.41875, (Object)0.526104417671));
        data.put("C8", new Pair((Object)0.51875, (Object)0.492957746479));
        data.put("C103", new Pair((Object)0.543689320388, (Object)0.58615819209));
        data.put("C1904", new Pair((Object)0.460416666667, (Object)0.536290322581));
        data.put("C1905", new Pair((Object)0.4375, (Object)0.502688172043));
        data.put("C2004", new Pair((Object)0.483333333333, (Object)0.509408602151));
        data.put("C2005", new Pair((Object)0.497916666667, (Object)0.786290322581));
        data.put("C2105", new Pair((Object)0.3625, (Object)0.529569892473));
        data.put("C2305", new Pair((Object)0.296296296296, (Object)0.310588235294));
        data.put("C5302", new Pair((Object)0.458333333333, (Object)0.649911816578));
        data.put("C5303", new Pair((Object)0.490277777778, (Object)0.721340388007));
        data.put("C5502", new Pair((Object)0.486111111111, (Object)0.179894179894));
        data.put("C5503", new Pair((Object)0.405555555556, (Object)0.26102292769));
        data.put("C6502", new Pair((Object)0.55, (Object)0.493827160494));
        data.put("C6503", new Pair((Object)0.561111111111, (Object)0.358024691358));
        data.put("C6506", new Pair((Object)0.502777777778, (Object)0.499118165785));
        data.put("C6530N", new Pair((Object)0.5, (Object)0.469631236443));
        data.put("C6602", new Pair((Object)0.511111111111, (Object)0.291005291005));
        data.put("C6603", new Pair((Object)0.444444444444, (Object)0.320987654321));
        data.put("C6606", new Pair((Object)0.577777777778, (Object)0.487360376249));
        data.put("C6725", new Pair((Object)0.455555555556, (Object)0.469918699187));
        data.put("C6730", new Pair((Object)0.313888888889, (Object)0.635772357724));
        data.put("C6740", new Pair((Object)0.469444444444, (Object)0.610229276896));
        data.put("C6740N", new Pair((Object)0.569444444444, (Object)0.377425044092));
        data.put("C6743", new Pair((Object)0.463888888889, (Object)0.458553791887));
        data.put("C6802", new Pair((Object)0.592592592593, (Object)0.317925591883));
        data.put("C6806", new Pair((Object)0.503703703704, (Object)0.811724915445));
        data.put("C6833", new Pair((Object)0.574074074074, (Object)0.354002254791));
        data.put("C6902", new Pair((Object)0.480555555556, (Object)0.322751322751));
        data.put("C6903", new Pair((Object)0.45, (Object)0.275132275132));
        data.put("C6906", new Pair((Object)0.483333333333, (Object)0.458553791887));
        data.put("CHC-U23", new Pair((Object)0.488888888889, (Object)0.452032520325));
        data.put("Che1-CL10", new Pair((Object)0.438888888889, (Object)0.473170731707));
        data.put("Che1-L04", new Pair((Object)0.419444444444, (Object)0.536585365854));
        data.put("Che2-L11", new Pair((Object)0.452777777778, (Object)0.274796747967));
        data.put("CHM-U01", new Pair((Object)0.65, (Object)0.126829268293));
        data.put("Classic", new Pair((Object)0.5325, (Object)0.486858573217));
        data.put("COMIO S1", new Pair((Object)0.422222222222, (Object)0.480633802817));
        data.put("cp3636a", new Pair((Object)0.444444444444, (Object)0.530844155844));
        data.put("CPH1605", new Pair((Object)0.502777777778, (Object)0.104501607717));
        data.put("CPH1607", new Pair((Object)0.475, (Object)0.480707395498));
        data.put("CPH1609", new Pair((Object)0.591666666667, (Object)0.498392282958));
        data.put("CPH1611", new Pair((Object)0.558333333333, (Object)0.0980707395498));
        data.put("CPH1613", new Pair((Object)0.669444444444, (Object)0.567524115756));
        data.put("CPH1701", new Pair((Object)0.491666666667, (Object)0.466237942122));
        data.put("CPH1707", new Pair((Object)0.636111111111, (Object)0.16077170418));
        data.put("CPH1717", new Pair((Object)0.444444444444, (Object)0.139871382637));
        data.put("CPH1719", new Pair((Object)0.463888888889, (Object)0.585626911315));
        data.put("CPH1723", new Pair((Object)0.486111111111, (Object)0.488603988604));
        data.put("CPH1725", new Pair((Object)0.605555555556, (Object)0.495412844037));
        data.put("CPH1727", new Pair((Object)0.502777777778, (Object)0.396024464832));
        data.put("CPH1729", new Pair((Object)0.455555555556, (Object)0.39755351682));
        data.put("CPH1801", new Pair((Object)0.563888888889, (Object)0.581993569132));
        data.put("CPH1819", new Pair((Object)0.544444444444, (Object)0.327988338192));
        data.put("CPH1821", new Pair((Object)0.6, (Object)0.752186588921));
        data.put("CPH1859", new Pair((Object)0.577777777778, (Object)0.576452599388));
        data.put("CPH1871", new Pair((Object)0.602777777778, (Object)0.489389920424));
        data.put("CT50", new Pair((Object)0.444444444444, (Object)0.518699186992));
        data.put("CUBOT X18", new Pair((Object)0.533333333333, (Object)0.143518518519));
        data.put("Cynus T6", new Pair((Object)0.552777777778, (Object)0.0682926829268));
        data.put("D504", new Pair((Object)0.444444444444, (Object)0.538732394366));
        data.put("D2005", new Pair((Object)0.415625, (Object)0.545647558386));
        data.put("D2203", new Pair((Object)0.5375, (Object)0.421370967742));
        data.put("D2212", new Pair((Object)0.459375, (Object)0.379032258065));
        data.put("D2302", new Pair((Object)0.472222222222, (Object)0.57671957672));
        data.put("D2303", new Pair((Object)0.527777777778, (Object)0.486772486772));
        data.put("D2305", new Pair((Object)0.477777777778, (Object)0.352733686067));
        data.put("D2306", new Pair((Object)0.447222222222, (Object)0.227513227513));
        data.put("D2403", new Pair((Object)0.469444444444, (Object)0.442680776014));
        data.put("D2406", new Pair((Object)0.466666666667, (Object)0.26278659612));
        data.put("D2502", new Pair((Object)0.495833333333, (Object)0.342307692308));
        data.put("D2533", new Pair((Object)0.533333333333, (Object)0.421794871795));
        data.put("D5103", new Pair((Object)0.591666666667, (Object)0.218694885362));
        data.put("D5106", new Pair((Object)0.419444444444, (Object)0.259259259259));
        data.put("D5303", new Pair((Object)0.591666666667, (Object)0.508974358974));
        data.put("D5306", new Pair((Object)0.460416666667, (Object)0.197435897436));
        data.put("D5322", new Pair((Object)0.55625, (Object)0.462820512821));
        data.put("D5503", new Pair((Object)0.488888888889, (Object)0.365079365079));
        data.put("D5788", new Pair((Object)0.886111111111, (Object)0.582010582011));
        data.put("D5803", new Pair((Object)0.463888888889, (Object)0.383802816901));
        data.put("D5833", new Pair((Object)0.413888888889, (Object)0.306878306878));
        data.put("D6502", new Pair((Object)0.5, (Object)0.299823633157));
        data.put("D6503", new Pair((Object)0.477777777778, (Object)0.343309859155));
        data.put("D6543", new Pair((Object)0.666666666667, (Object)0.677248677249));
        data.put("D6603", new Pair((Object)0.452777777778, (Object)0.278169014085));
        data.put("D6616", new Pair((Object)0.544444444444, (Object)0.3139329806));
        data.put("D6633", new Pair((Object)0.491666666667, (Object)0.225352112676));
        data.put("D6646", new Pair((Object)0.461111111111, (Object)0.422535211268));
        data.put("D6653", new Pair((Object)0.583333333333, (Object)0.197530864198));
        data.put("D6683", new Pair((Object)0.225, (Object)0.268077601411));
        data.put("D6708", new Pair((Object)0.463888888889, (Object)0.299823633157));
        data.put("DARKSIDE", new Pair((Object)0.552777777778, (Object)0.442276422764));
        data.put("Discovery II Mini", new Pair((Object)0.446875, (Object)0.431985294118));
        data.put("DM-01G", new Pair((Object)0.722222222222, (Object)0.493891797557));
        data.put("DROID RAZR HD", new Pair((Object)0.308333333333, (Object)0.721340388007));
        data.put("DROID RAZR M", new Pair((Object)0.608333333333, (Object)0.42328042328));
        data.put("E500", new Pair((Object)0.641666666667, (Object)0.549868766404));
        data.put("E505", new Pair((Object)0.921875, (Object)0.685661764706));
        data.put("E506", new Pair((Object)0.4875, (Object)0.520220588235));
        data.put("E2006", new Pair((Object)0.541666666667, (Object)0.409171075838));
        data.put("E2053", new Pair((Object)0.152777777778, (Object)0.492063492063));
        data.put("E2104", new Pair((Object)0.525, (Object)0.460207612457));
        data.put("E2105", new Pair((Object)0.847222222222, (Object)0.721453287197));
        data.put("E2115", new Pair((Object)0.402777777778, (Object)0.349480968858));
        data.put("E2124", new Pair((Object)0.508333333333, (Object)0.43598615917));
        data.put("E2303", new Pair((Object)0.438888888889, (Object)0.345679012346));
        data.put("E2306", new Pair((Object)0.463888888889, (Object)0.279929577465));
        data.put("E2312", new Pair((Object)0.466666666667, (Object)0.197530864198));
        data.put("E2333", new Pair((Object)0.430555555556, (Object)0.380952380952));
        data.put("E2353", new Pair((Object)0.402777777778, (Object)0.645502645503));
        data.put("E2363", new Pair((Object)0.5, (Object)0.462081128748));
        data.put("E5303", new Pair((Object)0.758333333333, (Object)0.656084656085));
        data.put("E5306", new Pair((Object)0.455555555556, (Object)0.452464788732));
        data.put("E5333", new Pair((Object)0.516666666667, (Object)0.146384479718));
        data.put("E5353", new Pair((Object)0.491666666667, (Object)0.475352112676));
        data.put("E5363", new Pair((Object)0.45, (Object)0.424295774648));
        data.put("E5506", new Pair((Object)0.463888888889, (Object)0.342151675485));
        data.put("E5533", new Pair((Object)0.458333333333, (Object)0.36684303351));
        data.put("E5553", new Pair((Object)0.747222222222, (Object)0.579225352113));
        data.put("E5563", new Pair((Object)0.45, (Object)0.43485915493));
        data.put("E5603", new Pair((Object)0.508333333333, (Object)0.380281690141));
        data.put("E5606", new Pair((Object)0.480555555556, (Object)0.406690140845));
        data.put("E5633", new Pair((Object)0.45, (Object)0.397887323944));
        data.put("E5653", new Pair((Object)0.461111111111, (Object)0.352112676056));
        data.put("E5663", new Pair((Object)0.6, (Object)0.47442680776));
        data.put("E5803", new Pair((Object)0.419444444444, (Object)0.390845070423));
        data.put("E5823", new Pair((Object)0.458333333333, (Object)0.403169014085));
        data.put("E6533", new Pair((Object)0.45, (Object)0.290492957746));
        data.put("E6553", new Pair((Object)0.483333333333, (Object)0.24823943662));
        data.put("E6560C", new Pair((Object)0.263888888889, (Object)0.294308943089));
        data.put("E6560T", new Pair((Object)0.00833333333333, (Object)0.915447154472));
        data.put("E6603", new Pair((Object)0.491666666667, (Object)0.50176056338));
        data.put("E6633", new Pair((Object)0.461111111111, (Object)0.225352112676));
        data.put("E6653", new Pair((Object)0.461111111111, (Object)0.320422535211));
        data.put("E6683", new Pair((Object)0.472222222222, (Object)0.287477954145));
        data.put("E6782", new Pair((Object)0.122222222222, (Object)0.39674796748));
        data.put("E6790TM", new Pair((Object)0.54375, (Object)0.229487179487));
        data.put("E6810", new Pair((Object)0.519444444444, (Object)0.349025974026));
        data.put("E6833", new Pair((Object)0.533333333333, (Object)0.457746478873));
        data.put("E6853", new Pair((Object)0.452830188679, (Object)0.290492957746));
        data.put("E6883", new Pair((Object)0.469444444444, (Object)0.25));
        data.put("e6_plus", new Pair((Object)0.530555555556, (Object)0.671544715447));
        data.put("Easy", new Pair((Object)0.484375, (Object)0.103296703297));
        data.put("ECHO_HOLI", new Pair((Object)0.54375, (Object)0.128440366972));
        data.put("Edge", new Pair((Object)0.780555555556, (Object)0.618506493506));
        data.put("Elite8QS", new Pair((Object)0.53375, (Object)0.380281690141));
        data.put("ELUGA_A3_Pro", new Pair((Object)0.588888888889, (Object)0.290492957746));
        data.put("Eluga_Arc_2", new Pair((Object)0.547222222222, (Object)0.214788732394));
        data.put("ELUGA Turbo", new Pair((Object)0.480555555556, (Object)0.554471544715));
        data.put("Energy X 2", new Pair((Object)0.266666666667, (Object)0.115447154472));
        data.put("EVOLVEO StrongPhone G4", new Pair((Object)0.707547169811, (Object)0.627019089574));
        data.put("F-01F", new Pair((Object)0.761111111111, (Object)0.453262786596));
        data.put("F1f", new Pair((Object)0.530555555556, (Object)0.517073170732));
        data.put("F1w", new Pair((Object)0.613888888889, (Object)0.583739837398));
        data.put("F5", new Pair((Object)0.419444444444, (Object)0.515447154472));
        data.put("F5_15", new Pair((Object)0.108333333333, (Object)0.139837398374));
        data.put("F3111", new Pair((Object)0.452777777778, (Object)0.417253521127));
        data.put("F3112", new Pair((Object)0.461111111111, (Object)0.209507042254));
        data.put("F3113", new Pair((Object)0.483333333333, (Object)0.272887323944));
        data.put("F3115", new Pair((Object)0.534375, (Object)0.302816901408));
        data.put("F3116", new Pair((Object)0.577777777778, (Object)0.517605633803));
        data.put("F3211", new Pair((Object)0.430555555556, (Object)0.404929577465));
        data.put("F3212", new Pair((Object)0.469444444444, (Object)0.272887323944));
        data.put("F3213", new Pair((Object)0.555555555556, (Object)0.552816901408));
        data.put("F3216", new Pair((Object)0.494444444444, (Object)0.427816901408));
        data.put("F3311", new Pair((Object)0.466666666667, (Object)0.420774647887));
        data.put("F3313", new Pair((Object)0.463888888889, (Object)0.25176056338));
        data.put("F5121", new Pair((Object)0.438888888889, (Object)0.452464788732));
        data.put("F5122", new Pair((Object)0.497222222222, (Object)0.589788732394));
        data.put("F5321", new Pair((Object)0.436111111111, (Object)0.524647887324));
        data.put("F8131", new Pair((Object)0.5, (Object)0.281690140845));
        data.put("F8132", new Pair((Object)0.608333333333, (Object)0.0105633802817));
        data.put("F8331", new Pair((Object)0.446875, (Object)0.429577464789));
        data.put("F8332", new Pair((Object)0.444444444444, (Object)0.258802816901));
        data.put("FEVER", new Pair((Object)0.536111111111, (Object)0.552816901408));
        data.put("FIG-LX1", new Pair((Object)0.494444444444, (Object)0.371559633028));
        data.put("FIND7", new Pair((Object)0.466666666667, (Object)0.491056910569));
        data.put("Fire", new Pair((Object)0.341666666667, (Object)0.0926829268293));
        data.put("Flare S5", new Pair((Object)0.0916666666667, (Object)0.305194805195));
        data.put("FLOW", new Pair((Object)0.488888888889, (Object)0.556818181818));
        data.put("Fractal", new Pair((Object)0.6625, (Object)0.282051282051));
        data.put("FRD-L02", new Pair((Object)0.352777777778, (Object)0.567944250871));
        data.put("Freedom 5.0", new Pair((Object)0.63925729443, (Object)0.568111455108));
        data.put("FREEDOM X1", new Pair((Object)0.425, (Object)0.343089430894));
        data.put("FS451", new Pair((Object)0.546875, (Object)0.573529411765));
        data.put("Fusion5", new Pair((Object)0.452777777778, (Object)0.456168831169));
        data.put("G", new Pair((Object)0.547222222222, (Object)0.207746478873));
        data.put("G1", new Pair((Object)0.258333333333, (Object)0.39674796748));
        data.put("G7-L01", new Pair((Object)0.458333333333, (Object)0.440917107584));
        data.put("G50", new Pair((Object)0.510204081633, (Object)0.482195845697));
        data.put("G620S-L01", new Pair((Object)0.461111111111, (Object)0.445528455285));
        data.put("G620S-L03", new Pair((Object)0.316666666667, (Object)0.40162601626));
        data.put("G630-U10", new Pair((Object)0.522222222222, (Object)0.307317073171));
        data.put("G630-U20", new Pair((Object)0.477777777778, (Object)0.160975609756));
        data.put("G735-L03", new Pair((Object)0.413888888889, (Object)0.606504065041));
        data.put("G735-L12", new Pair((Object)0.605555555556, (Object)0.0829268292683));
        data.put("G3112", new Pair((Object)0.427777777778, (Object)0.37323943662));
        data.put("G3121", new Pair((Object)0.433333333333, (Object)0.334801762115));
        data.put("G3123", new Pair((Object)0.491666666667, (Object)0.383802816901));
        data.put("G3125", new Pair((Object)0.444444444444, (Object)0.318661971831));
        data.put("G3212", new Pair((Object)0.445754716981, (Object)0.255131964809));
        data.put("G3221", new Pair((Object)0.469444444444, (Object)0.279929577465));
        data.put("G3223", new Pair((Object)0.497641509434, (Object)0.492668621701));
        data.put("G3226", new Pair((Object)0.584905660377, (Object)0.538123167155));
        data.put("G3311", new Pair((Object)0.475, (Object)0.470070422535));
        data.put("G3312", new Pair((Object)0.547222222222, (Object)0.220070422535));
        data.put("G3313", new Pair((Object)0.433333333333, (Object)0.375));
        data.put("G3412", new Pair((Object)0.572222222222, (Object)0.0880281690141));
        data.put("G3416", new Pair((Object)0.452777777778, (Object)0.295774647887));
        data.put("G8141", new Pair((Object)0.461111111111, (Object)0.545774647887));
        data.put("G8142", new Pair((Object)0.464622641509, (Object)0.508802816901));
        data.put("G8231", new Pair((Object)0.227777777778, (Object)0.0721830985915));
        data.put("G8341", new Pair((Object)0.391666666667, (Object)0.302816901408));
        data.put("G8342", new Pair((Object)0.45, (Object)0.0105633802817));
        data.put("G8343", new Pair((Object)0.443396226415, (Object)0.401759530792));
        data.put("G8441", new Pair((Object)0.433333333333, (Object)0.378521126761));
        data.put("Galaxy Nexus", new Pair((Object)0.230555555556, (Object)0.485915492958));
        data.put("GETAWAY", new Pair((Object)0.558333333333, (Object)0.123577235772));
        data.put("Grand 5.5 HD II", new Pair((Object)0.488888888889, (Object)0.569805194805));
        data.put("Grand Energy", new Pair((Object)0.55, (Object)0.602112676056));
        data.put("Grand XL", new Pair((Object)0.641666666667, (Object)0.505281690141));
        data.put("H30-L02", new Pair((Object)0.288888888889, (Object)0.50406504065));
        data.put("H60-L04", new Pair((Object)0.502777777778, (Object)0.639655172414));
        data.put("H60-L12", new Pair((Object)0.794444444444, (Object)0.567901234568));
        data.put("H3123", new Pair((Object)0.633333333333, (Object)0.213028169014));
        data.put("H3213", new Pair((Object)0.413888888889, (Object)0.396126760563));
        data.put("H3223", new Pair((Object)0.80625, (Object)0.352112676056));
        data.put("H4113", new Pair((Object)0.513888888889, (Object)0.522887323944));
        data.put("H4233", new Pair((Object)0.508333333333, (Object)0.288732394366));
        data.put("H4331", new Pair((Object)0.652777777778, (Object)0.535211267606));
        data.put("H8216", new Pair((Object)0.65, (Object)0.643518518519));
        data.put("H8266", new Pair((Object)0.3625, (Object)0.506172839506));
        data.put("H8296", new Pair((Object)0.546875, (Object)0.62962962963));
        data.put("H8324", new Pair((Object)0.516666666667, (Object)0.458333333333));
        data.put("HAFURY MIX", new Pair((Object)0.513888888889, (Object)0.561688311688));
        data.put("HARRY", new Pair((Object)0.502777777778, (Object)0.535714285714));
        data.put("Hawk_from_EE", new Pair((Object)0.236111111111, (Object)0.477351916376));
        data.put("HIGHWAY PURE", new Pair((Object)0.433333333333, (Object)0.52733686067));
        data.put("HM-N501-FL", new Pair((Object)0.458333333333, (Object)0.565853658537));
        data.put("HM NOTE 1W", new Pair((Object)0.426388888889, (Object)0.231707317073));
        data.put("Hol-U19", new Pair((Object)0.319444444444, (Object)0.419512195122));
        data.put("HS-U971", new Pair((Object)0.305555555556, (Object)0.182926829268));
        data.put("HTC 10 evo", new Pair((Object)0.522222222222, (Object)0.396103896104));
        data.put("HTC Desire 610", new Pair((Object)0.484375, (Object)0.534274193548));
        data.put("HTC Desire 628 dual sim", new Pair((Object)0.691666666667, (Object)0.555555555556));
        data.put("HTC One", new Pair((Object)0.458333333333, (Object)0.239024390244));
        data.put("HTC One mini", new Pair((Object)0.802777777778, (Object)0.182113821138));
        data.put("HTC U11", new Pair((Object)0.669444444444, (Object)0.144480519481));
        data.put("HTC U11+", new Pair((Object)0.669444444444, (Object)0.144480519481));
        data.put("HTC U11 life", new Pair((Object)0.811111111111, (Object)0.508116883117));
        data.put("HTV31", new Pair((Object)0.391666666667, (Object)0.543209876543));
        data.put("Hudl 2", new Pair((Object)0.888333333333, (Object)0.942502818489));
        data.put("Hudl HT7S3", new Pair((Object)0.71, (Object)0.284210526316));
        data.put("i8", new Pair((Object)0.498701298701, (Object)0.450682852807));
        data.put("i10", new Pair((Object)0.0777777777778, (Object)0.636363636364));
        data.put("I216X", new Pair((Object)0.481481481481, (Object)0.54114994363));
        data.put("i50", new Pair((Object)0.458333333333, (Object)0.588028169014));
        data.put("Ilium L1120", new Pair((Object)0.447222222222, (Object)0.551056338028));
        data.put("Ilium LT510", new Pair((Object)0.4125, (Object)0.5));
        data.put("Ilium X500B", new Pair((Object)0.490625, (Object)0.534926470588));
        data.put("Ilium X510", new Pair((Object)0.765625, (Object)0.492673992674));
        data.put("Ilium X710", new Pair((Object)0.416666666667, (Object)0.455985915493));
        data.put("IM-100K", new Pair((Object)0.430555555556, (Object)0.595238095238));
        data.put("IM-100S", new Pair((Object)0.688888888889, (Object)0.836734693878));
        data.put("IM-A870K", new Pair((Object)0.577777777778, (Object)0.550264550265));
        data.put("IM-A870L", new Pair((Object)0.905555555556, (Object)0.497354497354));
        data.put("IM-A880S", new Pair((Object)0.547222222222, (Object)0.572357723577));
        data.put("IM-A910L", new Pair((Object)0.563888888889, (Object)0.565853658537));
        data.put("IM-A910S", new Pair((Object)0.366666666667, (Object)0.652032520325));
        data.put("Impress_Luck", new Pair((Object)0.43125, (Object)0.371794871795));
        data.put("Infinix X510", new Pair((Object)0.425, (Object)0.30985915493));
        data.put("Infinix X5010", new Pair((Object)0.483333333333, (Object)0.555555555556));
        data.put("Infinix-X521", new Pair((Object)0.575, (Object)0.0730519480519));
        data.put("Infinix-X551", new Pair((Object)0.613888888889, (Object)0.151219512195));
        data.put("INFINIX-X551", new Pair((Object)0.722222222222, (Object)0.305691056911));
        data.put("Infinix X572", new Pair((Object)0.461165048544, (Object)0.488700564972));
        data.put("IQ4514 Quad", new Pair((Object)0.394444444444, (Object)0.123577235772));
        data.put("IQ4516 Octa", new Pair((Object)0.0388888888889, (Object)0.426016260163));
        data.put("IQ4601", new Pair((Object)0.397916666667, (Object)0.908088235294));
        data.put("iQD700", new Pair((Object)0.836111111111, (Object)0.522727272727));
        data.put("iRULU_V3", new Pair((Object)0.475, (Object)0.497354497354));
        data.put("J7", new Pair((Object)0.422222222222, (Object)0.0146341463415));
        data.put("Jazz", new Pair((Object)0.909375, (Object)0.498168498168));
        data.put("JAZZ", new Pair((Object)0.455555555556, (Object)0.477586206897));
        data.put("JERRY", new Pair((Object)0.4625, (Object)0.525641025641));
        data.put("JERRY2", new Pair((Object)0.371875, (Object)0.540293040293));
        data.put("K00Z", new Pair((Object)0.4675, (Object)0.656804733728));
        data.put("K01A", new Pair((Object)0.483333333333, (Object)0.777076761304));
        data.put("K1", new Pair((Object)0.825, (Object)0.40162601626));
        data.put("K3", new Pair((Object)0.494444444444, (Object)0.748376623377));
        data.put("K6", new Pair((Object)0.45, (Object)0.543209876543));
        data.put("K010", new Pair((Object)0.48125, (Object)0.456503728252));
        data.put("K10", new Pair((Object)0.116666666667, (Object)0.507716049383));
        data.put("K012", new Pair((Object)0.505, (Object)0.288117770768));
        data.put("K018", new Pair((Object)0.485, (Object)0.965202982601));
        data.put("K88", new Pair((Object)0.630615640599, (Object)0.534831460674));
        data.put("K5000", new Pair((Object)0.458333333333, (Object)0.518518518519));
        data.put("K6000 Plus", new Pair((Object)0.625, (Object)0.532467532468));
        data.put("K10000 Pro", new Pair((Object)0.466666666667, (Object)0.178571428571));
        data.put("KC-S701", new Pair((Object)0.511111111111, (Object)0.510569105691));
        data.put("Kurio7S", new Pair((Object)0.758333333333, (Object)0.542586750789));
        data.put("KYV35", new Pair((Object)0.466666666667, (Object)0.603896103896));
        data.put("Le Max", new Pair((Object)0.633333333333, (Object)0.698051948052));
        data.put("L-EMENT_403", new Pair((Object)0.5, (Object)0.450549450549));
        data.put("L-EMENT 505", new Pair((Object)0.5125, (Object)0.624542124542));
        data.put("L-EMENT551", new Pair((Object)0.558333333333, (Object)0.0113821138211));
        data.put("LENNY", new Pair((Object)0.590625, (Object)0.693014705882));
        data.put("LENNY2", new Pair((Object)0.4375, (Object)0.522058823529));
        data.put("LENNY3", new Pair((Object)0.513888888889, (Object)0.574675324675));
        data.put("Lenovo K8 Note", new Pair((Object)0.666666666667, (Object)0.342532467532));
        data.put("Le X507", new Pair((Object)0.427480916031, (Object)0.0941558441558));
        data.put("Le X509", new Pair((Object)0.582697201018, (Object)0.0207407407407));
        data.put("L-ITE 506 HD", new Pair((Object)0.483333333333, (Object)0.592532467532));
        data.put("LOOK", new Pair((Object)0.3125, (Object)0.595070422535));
        data.put("LS-5002", new Pair((Object)0.469444444444, (Object)0.52557319224));
        data.put("LS-5018", new Pair((Object)0.686111111111, (Object)0.634146341463));
        data.put("LS-5201", new Pair((Object)0.538888888889, (Object)0.595070422535));
        data.put("LS-5503", new Pair((Object)0.666666666667, (Object)0.456910569106));
        data.put("LT25i", new Pair((Object)0.458333333333, (Object)0.292768959436));
        data.put("LT30p", new Pair((Object)0.531944444444, (Object)0.383597883598));
        data.put("M3s", new Pair((Object)0.425, (Object)0.40325203252));
        data.put("M4 SS4453", new Pair((Object)0.725, (Object)0.237676056338));
        data.put("M4 SS4456", new Pair((Object)0.483333333333, (Object)0.522045855379));
        data.put("M4 SS4458", new Pair((Object)0.869444444444, (Object)0.637323943662));
        data.put("M5", new Pair((Object)0.511111111111, (Object)0.468292682927));
        data.put("M5 mini", new Pair((Object)0.227777777778, (Object)0.431818181818));
        data.put("M5 Plus", new Pair((Object)0.475, (Object)0.489430894309));
        data.put("M5s", new Pair((Object)0.666666666667, (Object)0.855987055016));
        data.put("M6 Note", new Pair((Object)0.555555555556, (Object)0.621527777778));
        data.put("M7", new Pair((Object)0.690625, (Object)0.928125));
        data.put("M7 Power", new Pair((Object)0.533333333333, (Object)0.447530864198));
        data.put("M8", new Pair((Object)0.45, (Object)0.39674796748));
        data.put("M9", new Pair((Object)0.0527777777778, (Object)0.947967479675));
        data.put("M9 Pro", new Pair((Object)0.383333333333, (Object)0.516975308642));
        data.put("M370i", new Pair((Object)0.672222222222, (Object)0.579225352113));
        data.put("M470BSA", new Pair((Object)0.86, (Object)0.897717666948));
        data.put("M512", new Pair((Object)0.419444444444, (Object)0.513227513228));
        data.put("Masstel_Tab7LTE", new Pair((Object)0.565410199557, (Object)0.041547277937));
        data.put("Mate 10", new Pair((Object)0.697222222222, (Object)0.122102009274));
        data.put("Maya", new Pair((Object)0.461111111111, (Object)0.443181818182));
        data.put("M bot 60", new Pair((Object)0.5, (Object)0.568181818182));
        data.put("ME173X", new Pair((Object)0.95875, (Object)0.0270498732037));
        data.put("MI 3W", new Pair((Object)0.527777777778, (Object)0.611290322581));
        data.put("Mi 4i", new Pair((Object)0.452777777778, (Object)0.41935483871));
        data.put("MI 4LTE", new Pair((Object)0.205555555556, (Object)0.353225806452));
        data.put("MI 5s Plus", new Pair((Object)0.511450381679, (Object)0.455081001473));
        data.put("MI 5X", new Pair((Object)0.638888888889, (Object)0.685483870968));
        data.put("MI 6X", new Pair((Object)0.368956743003, (Object)0.582677165354));
        data.put("MI 8", new Pair((Object)0.916030534351, (Object)0.929305912596));
        data.put("MI 8 SE", new Pair((Object)0.488549618321, (Object)0.0567010309278));
        data.put("Mi A1", new Pair((Object)0.497222222222, (Object)0.525974025974));
        data.put("MI MAX", new Pair((Object)0.501272264631, (Object)0.435935198822));
        data.put("MI MAX 2", new Pair((Object)0.539440203562, (Object)0.159057437408));
        data.put("MI NOTE LTE", new Pair((Object)0.58524173028, (Object)0.546391752577));
        data.put("MI PAD", new Pair((Object)0.47265625, (Object)0.449449449449));
        data.put("MIX", new Pair((Object)0.5, (Object)0.352272727273));
        data.put("MIX 2", new Pair((Object)0.514150943396, (Object)0.0824742268041));
        data.put("MIX_2", new Pair((Object)0.280555555556, (Object)0.359567901235));
        data.put("MIX Lite", new Pair((Object)0.575, (Object)0.601609657948));
        data.put("MO-01J", new Pair((Object)0.605555555556, (Object)0.593309859155));
        data.put("Mobiistar_Zumbo_J2", new Pair((Object)0.422222222222, (Object)0.526408450704));
        data.put("MOON", new Pair((Object)0.458333333333, (Object)0.510563380282));
        data.put("Moto C", new Pair((Object)0.5625, (Object)0.459706959707));
        data.put("Moto C Plus", new Pair((Object)0.513888888889, (Object)0.548701298701));
        data.put("moto e(5) cruise", new Pair((Object)0.583333333333, (Object)0.533450704225));
        data.put("moto e(5) plus", new Pair((Object)0.475, (Object)0.501543209877));
        data.put("moto e5 plus", new Pair((Object)0.475, (Object)0.501543209877));
        data.put("Moto X Play", new Pair((Object)0.444444444444, (Object)0.478873239437));
        data.put("MS45S", new Pair((Object)0.596875, (Object)0.555147058824));
        data.put("MS60", new Pair((Object)0.677777777778, (Object)0.354471544715));
        data.put("MW6617", new Pair((Object)0.283251231527, (Object)0.895265423242));
        data.put("N1", new Pair((Object)0.465740740741, (Object)0.372357723577));
        data.put("N2", new Pair((Object)0.575, (Object)0.801470588235));
        data.put("N5L", new Pair((Object)0.472222222222, (Object)0.874796747967));
        data.put("N817", new Pair((Object)0.421875, (Object)0.557086614173));
        data.put("N5702L", new Pair((Object)0.513888888889, (Object)0.609567901235));
        data.put("N9100", new Pair((Object)0.488888888889, (Object)0.580487804878));
        data.put("N9130", new Pair((Object)0.4125, (Object)0.413602941176));
        data.put("N9132", new Pair((Object)0.596875, (Object)0.327205882353));
        data.put("N9510", new Pair((Object)0.469444444444, (Object)0.492682926829));
        data.put("N9515", new Pair((Object)0.725, (Object)0.0910569105691));
        data.put("N9518", new Pair((Object)0.622222222222, (Object)0.458536585366));
        data.put("N9520", new Pair((Object)0.0194444444444, (Object)0.463414634146));
        data.put("N9521", new Pair((Object)0.477777777778, (Object)0.474796747967));
        data.put("Nexus 4", new Pair((Object)0.4921875, (Object)0.522045855379));
        data.put("Nexus 5", new Pair((Object)0.444444444444, (Object)0.503521126761));
        data.put("Nexus 5X", new Pair((Object)0.223300970874, (Object)0.177272727273));
        data.put("Nexus 6", new Pair((Object)0.490291262136, (Object)0.584848484848));
        data.put("Nexus 6P", new Pair((Object)0.194174757282, (Object)0.0557667934094));
        data.put("Nexus 7 (2013)", new Pair((Object)0.35269121813, (Object)0.384688090737));
        data.put("Nexus 9", new Pair((Object)0.463541666667, (Object)0.11974789916));
        data.put("Nexus 10", new Pair((Object)0.95875, (Object)0.544324772162));
        data.put("Nokia 2", new Pair((Object)0.411111111111, (Object)0.336267605634));
        data.put("Nokia 6.1", new Pair((Object)0.490291262136, (Object)0.40303030303));
        data.put("Nokia 7 plus", new Pair((Object)0.555967007251, (Object)0.366654582298));
        data.put("Nokia X6", new Pair((Object)0.617021276596, (Object)0.402506963788));
        data.put("NS-P10A7100", new Pair((Object)0.73377703827, (Object)0.767415730337));
        data.put("NX404H", new Pair((Object)0.819444444444, (Object)0.383739837398));
        data.put("NX505J", new Pair((Object)0.525, (Object)0.234185733513));
        data.put("NX511J", new Pair((Object)0.755555555556, (Object)0.819512195122));
        data.put("NX512J", new Pair((Object)0.575, (Object)0.172357723577));
        data.put("NX513J", new Pair((Object)0.608333333333, (Object)0.639024390244));
        data.put("NX531J", new Pair((Object)0.719444444444, (Object)0.474796747967));
        data.put("NX541J", new Pair((Object)0.661111111111, (Object)0.634146341463));
        data.put("NX569J", new Pair((Object)0.513888888889, (Object)0.476422764228));
        data.put("NX573J", new Pair((Object)0.477777777778, (Object)0.473170731707));
        data.put("NX785QC8G", new Pair((Object)0.470052083333, (Object)0.48054679285));
        data.put("NXA8QC116", new Pair((Object)0.77375, (Object)0.488372093023));
        data.put("One", new Pair((Object)0.477777777778, (Object)0.0861788617886));
        data.put("One (M8)", new Pair((Object)0.444444444444, (Object)0.0864197530864));
        data.put("OWN_S4025", new Pair((Object)0.47962962963, (Object)0.522776572668));
        data.put("P001", new Pair((Object)0.43, (Object)0.458464773922));
        data.put("P01Y", new Pair((Object)0.503333333333, (Object)0.508937960042));
        data.put("P01Z", new Pair((Object)0.556666666667, (Object)0.249211356467));
        data.put("P2", new Pair((Object)0.544444444444, (Object)0.482142857143));
        data.put("P2M", new Pair((Object)0.696875, (Object)0.314960629921));
        data.put("P5_eMagic", new Pair((Object)0.684375, (Object)0.525735294118));
        data.put("P5 mini", new Pair((Object)0.478125, (Object)0.441176470588));
        data.put("P5W", new Pair((Object)0.547222222222, (Object)0.554471544715));
        data.put("P6_Energy", new Pair((Object)0.533333333333, (Object)0.523577235772));
        data.put("P6 PRO", new Pair((Object)0.527777777778, (Object)0.0652557319224));
        data.put("P7", new Pair((Object)0.155555555556, (Object)0.627642276423));
        data.put("P7 Max", new Pair((Object)0.536111111111, (Object)0.402597402597));
        data.put("P8_eMagic", new Pair((Object)0.472222222222, (Object)0.485915492958));
        data.put("P552", new Pair((Object)0.575, (Object)0.717073170732));
        data.put("P791", new Pair((Object)0.0559895833333, (Object)0.356466876972));
        data.put("P5046A", new Pair((Object)0.416666666667, (Object)0.429577464789));
        data.put("PadFone 2", new Pair((Object)0.716666666667, (Object)0.746341463415));
        data.put("PE-TL10", new Pair((Object)0.619444444444, (Object)0.68430335097));
        data.put("PGN517", new Pair((Object)0.394444444444, (Object)0.530081300813));
        data.put("PGN518", new Pair((Object)0.905555555556, (Object)0.470779220779));
        data.put("PGN605", new Pair((Object)0.497222222222, (Object)0.278048780488));
        data.put("PGN611", new Pair((Object)0.552777777778, (Object)0.454545454545));
        data.put("PH-1", new Pair((Object)0.564102564103, (Object)0.840637450199));
        data.put("Phantom6", new Pair((Object)0.486111111111, (Object)0.539792387543));
        data.put("Philips S337", new Pair((Object)0.528125, (Object)0.627016129032));
        data.put("Philips_X586", new Pair((Object)0.408333333333, (Object)0.550324675325));
        data.put("Picasso", new Pair((Object)0.605555555556, (Object)0.465608465608));
        data.put("Pixel", new Pair((Object)0.691747572816, (Object)0.280303030303));
        data.put("Pixel 2", new Pair((Object)0.43063583815, (Object)0.175757575758));
        data.put("Pixel 2 XL", new Pair((Object)0.276699029126, (Object)0.161981258367));
        data.put("Pixel XL", new Pair((Object)0.470103092784, (Object)0.216666666667));
        data.put("PMT3057_3G", new Pair((Object)0.808333333333, (Object)0.308096740273));
        data.put("PMT3157_3G", new Pair((Object)0.398611111111, (Object)0.460264900662));
        data.put("PMT5777_3G", new Pair((Object)0.5775, (Object)0.644125105664));
        data.put("POLYTRON_P552", new Pair((Object)0.738888888889, (Object)0.519480519481));
        data.put("Power", new Pair((Object)0.461111111111, (Object)0.532467532468));
        data.put("Power_2", new Pair((Object)0.469339622642, (Object)0.464788732394));
        data.put("Power_3", new Pair((Object)0.783333333333, (Object)0.0941358024691));
        data.put("PRIME X MAX 2018", new Pair((Object)0.786111111111, (Object)0.526234567901));
        data.put("PRO5043", new Pair((Object)0.553125, (Object)0.137867647059));
        data.put("PSP3507DUO", new Pair((Object)0.695290858726, (Object)0.837925445705));
        data.put("PSP3510DUO", new Pair((Object)0.509375, (Object)0.186813186813));
        data.put("PSP3527DUO", new Pair((Object)0.476454293629, (Object)0.46925566343));
        data.put("PSP3531DUO", new Pair((Object)0.452777777778, (Object)0.486013986014));
        data.put("PSP5455DUO", new Pair((Object)0.536111111111, (Object)0.10243902439));
        data.put("PSP5506DUO", new Pair((Object)0.566666666667, (Object)0.49756097561));
        data.put("PSP5508DUO", new Pair((Object)0.575, (Object)0.0130081300813));
        data.put("PSP5509DUO", new Pair((Object)0.488888888889, (Object)0.453658536585));
        data.put("PSP5517DUO", new Pair((Object)0.0805555555556, (Object)0.151219512195));
        data.put("PULP", new Pair((Object)0.525, (Object)0.342151675485));
        data.put("PULP 4G", new Pair((Object)0.791666666667, (Object)0.52380952381));
        data.put("PULP FAB 4G", new Pair((Object)0.433333333333, (Object)0.553791887125));
        data.put("PURE", new Pair((Object)0.596875, (Object)0.650183150183));
        data.put("PURE XL", new Pair((Object)0.477777777778, (Object)0.447154471545));
        data.put("Q.3778", new Pair((Object)0.5075, (Object)0.29246064623));
        data.put("Q6T7IN4G", new Pair((Object)0.16, (Object)0.347003154574));
        data.put("Q88", new Pair((Object)0.531666666667, (Object)0.49421661409));
        data.put("QTAIR7", new Pair((Object)0.96375, (Object)0.432477216239));
        data.put("QTAQZ3", new Pair((Object)0.828618968386, (Object)0.717660292463));
        data.put("R1 HD", new Pair((Object)0.447222222222, (Object)0.383802816901));
        data.put("R3", new Pair((Object)0.366666666667, (Object)0.583333333333));
        data.put("R6", new Pair((Object)0.394444444444, (Object)0.524350649351));
        data.put("R7", new Pair((Object)0.408333333333, (Object)0.376623376623));
        data.put("R7kf", new Pair((Object)0.605555555556, (Object)0.292682926829));
        data.put("R7sf", new Pair((Object)0.497222222222, (Object)0.0921739130435));
        data.put("R829", new Pair((Object)0.440277777778, (Object)0.0130081300813));
        data.put("R1001", new Pair((Object)0.31875, (Object)0.417322834646));
        data.put("R1011", new Pair((Object)0.484375, (Object)0.496062992126));
        data.put("R8006", new Pair((Object)0.429166666667, (Object)0.0626016260163));
        data.put("R8106", new Pair((Object)0.169444444444, (Object)0.312195121951));
        data.put("RAINBOW", new Pair((Object)0.502777777778, (Object)0.276422764228));
        data.put("RAINBOW JAM", new Pair((Object)0.877777777778, (Object)0.319223985891));
        data.put("RAINBOW LITE 4G", new Pair((Object)0.453125, (Object)0.472426470588));
        data.put("RAZR HD", new Pair((Object)0.455555555556, (Object)0.537918871252));
        data.put("RCT6K03W13", new Pair((Object)0.83, (Object)0.180463576159));
        data.put("RCT6303W87DK", new Pair((Object)0.34375, (Object)0.250207125104));
        data.put("RCT6303W87M7", new Pair((Object)0.49, (Object)0.418874172185));
        data.put("RCT6773W22", new Pair((Object)0.618333333333, (Object)0.559411146162));
        data.put("RCT6773W42B", new Pair((Object)0.378333333333, (Object)0.659305993691));
        data.put("RCT6973W43MD", new Pair((Object)0.716666666667, (Object)0.423319327731));
        data.put("RealPad MA7BX2", new Pair((Object)0.432291666667, (Object)0.46898002103));
        data.put("Redmi 3", new Pair((Object)0.497222222222, (Object)0.5));
        data.put("Redmi 3S", new Pair((Object)0.458333333333, (Object)0.496753246753));
        data.put("Redmi 4", new Pair((Object)0.480555555556, (Object)0.465909090909));
        data.put("Redmi 4A", new Pair((Object)0.461111111111, (Object)0.488636363636));
        data.put("Redmi 4X", new Pair((Object)0.475, (Object)0.501623376623));
        data.put("Redmi 5", new Pair((Object)0.758333333333, (Object)0.537356321839));
        data.put("Redmi 5A", new Pair((Object)0.525, (Object)0.521103896104));
        data.put("Redmi 5 Plus", new Pair((Object)0.549618320611, (Object)0.443356643357));
        data.put("Redmi Note 3", new Pair((Object)0.486111111111, (Object)0.48064516129));
        data.put("Redmi Note 4", new Pair((Object)0.486111111111, (Object)0.477419354839));
        data.put("Redmi Note 5", new Pair((Object)0.488549618321, (Object)0.33986013986));
        data.put("Redmi Note 5A", new Pair((Object)0.497222222222, (Object)0.496753246753));
        data.put("Redmi Note 5 Pro", new Pair((Object)0.539440203562, (Object)0.458741258741));
        data.put("Redmi Pro", new Pair((Object)0.65, (Object)0.606451612903));
        data.put("Redmi S2", new Pair((Object)0.47641509434, (Object)0.341935483871));
        data.put("RIDGE 4G", new Pair((Object)0.558333333333, (Object)0.511463844797));
        data.put("RIDGE FAB 4G", new Pair((Object)0.433333333333, (Object)0.537918871252));
        data.put("ROBBY", new Pair((Object)0.458333333333, (Object)0.487676056338));
        data.put("Robin", new Pair((Object)0.486111111111, (Object)0.573943661972));
        data.put("S2", new Pair((Object)0.525, (Object)0.332831325301));
        data.put("S2_PRO", new Pair((Object)0.677777777778, (Object)0.237951807229));
        data.put("S3", new Pair((Object)0.605555555556, (Object)0.566358024691));
        data.put("s4", new Pair((Object)0.452777777778, (Object)0.0780487804878));
        data.put("S4S5IN3G", new Pair((Object)0.625, (Object)0.446691176471));
        data.put("S5.5", new Pair((Object)0.511111111111, (Object)0.162601626016));
        data.put("S6", new Pair((Object)0.384375, (Object)0.265625));
        data.put("S6 Pro", new Pair((Object)0.233333333333, (Object)0.63961038961));
        data.put("S6s", new Pair((Object)0.658333333333, (Object)0.465909090909));
        data.put("S7", new Pair((Object)0.561111111111, (Object)0.604779411765));
        data.put("S7C", new Pair((Object)0.691796008869, (Object)0.123385939742));
        data.put("S8", new Pair((Object)0.497222222222, (Object)0.518518518519));
        data.put("S9 Plus", new Pair((Object)0.469444444444, (Object)0.623456790123));
        data.put("S15", new Pair((Object)0.525, (Object)0.656910569106));
        data.put("S16", new Pair((Object)0.564986737401, (Object)0.706447187929));
        data.put("S30", new Pair((Object)0.636111111111, (Object)0.48538961039));
        data.put("S31", new Pair((Object)0.465979381443, (Object)0.523297491039));
        data.put("S40", new Pair((Object)0.455555555556, (Object)0.211382113821));
        data.put("S41", new Pair((Object)0.526699029126, (Object)0.505649717514));
        data.put("S50", new Pair((Object)0.786111111111, (Object)0.783068783069));
        data.put("S60", new Pair((Object)0.438888888889, (Object)0.519480519481));
        data.put("S60 Lite", new Pair((Object)0.527777777778, (Object)0.575174825175));
        data.put("S70", new Pair((Object)0.6, (Object)0.590592334495));
        data.put("S420", new Pair((Object)0.396875, (Object)0.492125984252));
        data.put("S550", new Pair((Object)0.566666666667, (Object)0.291056910569));
        data.put("SC-01F", new Pair((Object)0.530555555556, (Object)0.482926829268));
        data.put("SC-01G", new Pair((Object)0.472584856397, (Object)0.496753246753));
        data.put("SC-02F", new Pair((Object)0.363888888889, (Object)0.541463414634));
        data.put("SC-02G", new Pair((Object)0.588888888889, (Object)0.679674796748));
        data.put("SC-02H", new Pair((Object)0.630555555556, (Object)0.519480519481));
        data.put("SC-04F", new Pair((Object)0.661111111111, (Object)0.0991869918699));
        data.put("SC-05G", new Pair((Object)0.880555555556, (Object)0.641233766234));
        data.put("SCL24", new Pair((Object)0.626631853786, (Object)0.474796747967));
        data.put("SCV31", new Pair((Object)0.594444444444, (Object)0.535714285714));
        data.put("SCV33", new Pair((Object)0.644444444444, (Object)0.444805194805));
        data.put("SCV35", new Pair((Object)0.526699029126, (Object)0.136950904393));
        data.put("SCV37", new Pair((Object)0.553125, (Object)0.0750853242321));
        data.put("SENSEIT_A109", new Pair((Object)0.740625, (Object)0.131868131868));
        data.put("SGP312", new Pair((Object)0.0725, (Object)0.483015741508));
        data.put("SGP321", new Pair((Object)0.09375, (Object)0.474730737365));
        data.put("SGP412", new Pair((Object)0.557407407407, (Object)0.457722660654));
        data.put("SGP511", new Pair((Object)0.92125, (Object)0.0182270091135));
        data.put("SGP512", new Pair((Object)0.78625, (Object)0.026512013256));
        data.put("SGP521", new Pair((Object)0.72375, (Object)0.0720795360398));
        data.put("SGP611", new Pair((Object)0.121666666667, (Object)0.244369369369));
        data.put("SGP612", new Pair((Object)0.175, (Object)0.27733934611));
        data.put("SGP621", new Pair((Object)0.165, (Object)0.410372040586));
        data.put("SGP712", new Pair((Object)0.76125, (Object)0.227649006623));
        data.put("SGP771", new Pair((Object)0.7625, (Object)0.310430463576));
        data.put("SH-01G", new Pair((Object)0.847222222222, (Object)0.141093474427));
        data.put("SH-01H", new Pair((Object)0.433333333333, (Object)0.301587301587));
        data.put("SH-04F", new Pair((Object)0.55, (Object)0.550264550265));
        data.put("Shaker-Slim", new Pair((Object)0.5, (Object)0.523897058824));
        data.put("SHIELD Tablet", new Pair((Object)0.43, (Object)0.449324324324));
        data.put("SHL25", new Pair((Object)0.266666666667, (Object)0.287477954145));
        data.put("Shoot_1", new Pair((Object)0.488888888889, (Object)0.521103896104));
        data.put("Signature Touch", new Pair((Object)0.563888888889, (Object)0.514991181658));
        data.put("SKY 5.0LM", new Pair((Object)0.465625, (Object)0.465073529412));
        data.put("SMART 4G 5.5 Enterprise", new Pair((Object)0.366666666667, (Object)0.476422764228));
        data.put("SO-01H", new Pair((Object)0.402777777778, (Object)0.417989417989));
        data.put("SO-01J", new Pair((Object)0.575, (Object)0.135563380282));
        data.put("SO-02F", new Pair((Object)0.677777777778, (Object)0.172839506173));
        data.put("SO-02G", new Pair((Object)0.238888888889, (Object)0.573192239859));
        data.put("SO-03F", new Pair((Object)0.716666666667, (Object)0.507936507937));
        data.put("SO-03H", new Pair((Object)0.455555555556, (Object)0.170774647887));
        data.put("SO-03J", new Pair((Object)0.183333333333, (Object)0.589788732394));
        data.put("SO-04F", new Pair((Object)0.452777777778, (Object)0.268077601411));
        data.put("SO-04G", new Pair((Object)0.452777777778, (Object)0.230633802817));
        data.put("SO-04J", new Pair((Object)0.455555555556, (Object)0.588028169014));
        data.put("SOL23", new Pair((Object)0.508333333333, (Object)0.533795493934));
        data.put("S_plus", new Pair((Object)0.588888888889, (Object)0.681300813008));
        data.put("STARADDICT 4", new Pair((Object)0.713888888889, (Object)0.112195121951));
        data.put("STARNAUTE4", new Pair((Object)0.471875, (Object)0.474358974359));
        data.put("STARTRAIL7", new Pair((Object)0.571875, (Object)0.527573529412));
        data.put("Stellar 4G", new Pair((Object)0.502777777778, (Object)0.707792207792));
        data.put("STUDIO M HD", new Pair((Object)0.755555555556, (Object)0.378861788618));
        data.put("Studio View XL", new Pair((Object)0.433333333333, (Object)0.554012345679));
        data.put("SUNNY", new Pair((Object)0.46875, (Object)0.539215686275));
        data.put("Sunny2 Plus", new Pair((Object)0.7125, (Object)0.470695970696));
        data.put("SUNSET", new Pair((Object)0.484375, (Object)0.462598425197));
        data.put("SUNSET2", new Pair((Object)0.621875, (Object)0.51968503937));
        data.put("Swift 2", new Pair((Object)0.572222222222, (Object)0.637323943662));
        data.put("Swift_Plus", new Pair((Object)0.665625, (Object)0.643382352941));
        data.put("SWITCH", new Pair((Object)0.459375, (Object)0.567765567766));
        data.put("T1", new Pair((Object)0.461111111111, (Object)0.540492957746));
        data.put("T3", new Pair((Object)0.486111111111, (Object)0.432520325203));
        data.put("T5", new Pair((Object)0.644444444444, (Object)0.293831168831));
        data.put("T9", new Pair((Object)0.407552083333, (Object)0.565720294427));
        data.put("T10", new Pair((Object)0.580555555556, (Object)0.926948051948));
        data.put("T10+", new Pair((Object)0.580555555556, (Object)0.794019933555));
        data.put("T11", new Pair((Object)0.647222222222, (Object)0.429268292683));
        data.put("T012", new Pair((Object)0.634375, (Object)0.534274193548));
        data.put("T12", new Pair((Object)0.563888888889, (Object)0.0357723577236));
        data.put("T85", new Pair((Object)0.163888888889, (Object)0.551948051948));
        data.put("T1000", new Pair((Object)0.806557377049, (Object)0.794019933555));
        data.put("TC55", new Pair((Object)0.34375, (Object)0.612204724409));
        data.put("TECNO AX8", new Pair((Object)0.469444444444, (Object)0.550324675325));
        data.put("TECNO-C7", new Pair((Object)0.536111111111, (Object)0.657467532468));
        data.put("TECNO-C8", new Pair((Object)0.325, (Object)0.386991869919));
        data.put("TECNO-C9", new Pair((Object)0.319444444444, (Object)0.349025974026));
        data.put("TECNO K7", new Pair((Object)0.755555555556, (Object)0.586038961039));
        data.put("TECNO K9", new Pair((Object)0.408333333333, (Object)0.666089965398));
        data.put("TECNO-W3LTE", new Pair((Object)0.615625, (Object)0.549450549451));
        data.put("Tele2_Mini", new Pair((Object)0.590625, (Object)0.647637795276));
        data.put("TG-L800S", new Pair((Object)0.491666666667, (Object)0.614436619718));
        data.put("TG-L900S", new Pair((Object)0.601941747573, (Object)0.437878787879));
        data.put("TOMMY", new Pair((Object)0.438888888889, (Object)0.522887323944));
        data.put("Tornado 348", new Pair((Object)0.441666666667, (Object)0.834146341463));
        data.put("TREKKER-M1 CORE", new Pair((Object)0.384375, (Object)0.761904761905));
        data.put("Twist XL", new Pair((Object)0.513888888889, (Object)0.441901408451));
        data.put("U7 Plus", new Pair((Object)0.491666666667, (Object)0.464285714286));
        data.put("U16 Max", new Pair((Object)0.511111111111, (Object)0.528440366972));
        data.put("U22", new Pair((Object)0.419444444444, (Object)0.375));
        data.put("U673C", new Pair((Object)0.44375, (Object)0.535294117647));
        data.put("U FEEL", new Pair((Object)0.447222222222, (Object)0.512323943662));
        data.put("U FEEL GO", new Pair((Object)0.697222222222, (Object)0.62323943662));
        data.put("U FEEL LITE", new Pair((Object)0.519444444444, (Object)0.417253521127));
        data.put("U FEEL PRIME", new Pair((Object)0.622222222222, (Object)0.637323943662));
        data.put("UL40", new Pair((Object)0.571875, (Object)0.47619047619));
        data.put("Ultra", new Pair((Object)0.502777777778, (Object)0.248677248677));
        data.put("Ultra Live II", new Pair((Object)0.511111111111, (Object)0.521103896104));
        data.put("Ultra Style", new Pair((Object)0.769444444444, (Object)0.58024691358));
        data.put("UP Prime", new Pair((Object)0.646226415094, (Object)0.341563786008));
        data.put("U PULSE", new Pair((Object)0.452777777778, (Object)0.536971830986));
        data.put("U PULSE LITE", new Pair((Object)0.744444444444, (Object)0.68661971831));
        data.put("V3", new Pair((Object)0.588888888889, (Object)0.117886178862));
        data.put("V3+", new Pair((Object)0.588888888889, (Object)0.117886178862));
        data.put("V5", new Pair((Object)0.45, (Object)0.261788617886));
        data.put("V6", new Pair((Object)0.479201331115, (Object)0.759871931697));
        data.put("V8", new Pair((Object)0.421711899791, (Object)0.537401574803));
        data.put("V9", new Pair((Object)0.515625, (Object)0.0625));
        data.put("V355", new Pair((Object)0.588888888889, (Object)0.730519480519));
        data.put("verykools5528Jr", new Pair((Object)0.666666666667, (Object)0.131493506494));
        data.put("VF695", new Pair((Object)0.3625, (Object)0.23031496063));
        data.put("VF-895N", new Pair((Object)0.491666666667, (Object)0.491056910569));
        data.put("VFD 200", new Pair((Object)0.45625, (Object)0.492307692308));
        data.put("View", new Pair((Object)0.472222222222, (Object)0.435185185185));
        data.put("vivo 1611", new Pair((Object)0.55, (Object)0.519480519481));
        data.put("vivo 1714", new Pair((Object)0.591666666667, (Object)0.498376623377));
        data.put("vivo 1716", new Pair((Object)0.561111111111, (Object)0.518348623853));
        data.put("vivo 1718", new Pair((Object)0.55, (Object)0.373563218391));
        data.put("vivo 1723", new Pair((Object)0.544444444444, (Object)0.435860058309));
        data.put("vivo 1725", new Pair((Object)0.00277777777778, (Object)0.505649717514));
        data.put("vivo 1727", new Pair((Object)0.558333333333, (Object)0.431486880466));
        data.put("vivo 1802", new Pair((Object)0.258333333333, (Object)0.488405797101));
        data.put("vivo 1805", new Pair((Object)0.797222222222, (Object)0.82905982906));
        data.put("Vivo 5 Mini", new Pair((Object)0.3125, (Object)0.88431372549));
        data.put("vivo NEX S", new Pair((Object)0.486111111111, (Object)0.236559139785));
        data.put("VIVO XL", new Pair((Object)0.638888888889, (Object)0.519480519481));
        data.put("Vivo XL3", new Pair((Object)0.625, (Object)0.555555555556));
        data.put("Vodafone 785", new Pair((Object)0.527083333333, (Object)0.451443569554));
        data.put("Vodafone 985N", new Pair((Object)0.397222222222, (Object)0.533333333333));
        data.put("Vodafone Smart ultra 6", new Pair((Object)0.452777777778, (Object)0.468292682927));
        data.put("VSP355s", new Pair((Object)0.352777777778, (Object)0.567901234568));
        data.put("W_C800", new Pair((Object)0.432038834951, (Object)0.525839793282));
        data.put("WIM Lite", new Pair((Object)0.469339622642, (Object)0.665492957746));
        data.put("W_K400", new Pair((Object)0.602777777778, (Object)0.623456790123));
        data.put("W_P200CM", new Pair((Object)0.644444444444, (Object)0.512345679012));
        data.put("X", new Pair((Object)0.725, (Object)0.645340751043));
        data.put("X1", new Pair((Object)0.533333333333, (Object)0.460162601626));
        data.put("X3", new Pair((Object)0.59375, (Object)0.511029411765));
        data.put("X4_Soul_Style", new Pair((Object)0.825, (Object)0.363636363636));
        data.put("X4UPlus", new Pair((Object)0.453125, (Object)0.558823529412));
        data.put("X5", new Pair((Object)0.447222222222, (Object)0.336585365854));
        data.put("X5max", new Pair((Object)0.644444444444, (Object)0.662337662338));
        data.put("X5max_PRO", new Pair((Object)0.397222222222, (Object)0.560064935065));
        data.put("X6", new Pair((Object)0.55, (Object)0.482926829268));
        data.put("X6pro", new Pair((Object)0.647222222222, (Object)0.843902439024));
        data.put("X7", new Pair((Object)0.447222222222, (Object)0.443181818182));
        data.put("X9 Mini", new Pair((Object)0.586111111111, (Object)0.491883116883));
        data.put("X9S", new Pair((Object)0.397222222222, (Object)0.0959349593496));
        data.put("X11", new Pair((Object)0.430555555556, (Object)0.526829268293));
        data.put("X12", new Pair((Object)0.605555555556, (Object)0.482926829268));
        data.put("X13", new Pair((Object)0.571875, (Object)0.356617647059));
        data.put("X17", new Pair((Object)0.506361323155, (Object)0.476261127596));
        data.put("X20", new Pair((Object)0.477777777778, (Object)0.547077922078));
        data.put("X30", new Pair((Object)0.566666666667, (Object)0.49025974026));
        data.put("X450", new Pair((Object)0.521875, (Object)0.306985294118));
        data.put("X455", new Pair((Object)0.509375, (Object)0.550980392157));
        data.put("X600", new Pair((Object)0.616666666667, (Object)0.53064516129));
        data.put("X9006", new Pair((Object)0.464814814815, (Object)0.283468834688));
        data.put("X9009", new Pair((Object)0.530555555556, (Object)0.424437299035));
        data.put("X9076", new Pair((Object)0.486111111111, (Object)0.572357723577));
        data.put("XP7700", new Pair((Object)0.428125, (Object)0.80905511811));
        data.put("Xperia SP", new Pair((Object)0.5, (Object)0.786971830986));
        data.put("Xperia T", new Pair((Object)0.680555555556, (Object)0.613756613757));
        data.put("Xperia Z", new Pair((Object)0.594444444444, (Object)0.375));
        data.put("Xperia Z1", new Pair((Object)0.583333333333, (Object)0.155202821869));
        data.put("Xperia Z1 Compact", new Pair((Object)0.486111111111, (Object)0.195767195767));
        data.put("Xperia Z2", new Pair((Object)0.425, (Object)0.20811287478));
        data.put("Xperia Z3", new Pair((Object)0.647222222222, (Object)0.336860670194));
        data.put("Xperia Z3+", new Pair((Object)0.647222222222, (Object)0.336860670194));
        data.put("Xperia ZL", new Pair((Object)0.469444444444, (Object)0.573943661972));
        data.put("XT1663", new Pair((Object)0.536111111111, (Object)0.507042253521));
        data.put("Y6", new Pair((Object)0.2, (Object)0.37987012987));
        data.put("Y6C", new Pair((Object)0.802777777778, (Object)0.599025974026));
        data.put("Y6 Max", new Pair((Object)0.469444444444, (Object)0.457792207792));
        data.put("Y7", new Pair((Object)0.683333333333, (Object)0.0813008130081));
        data.put("Y15", new Pair((Object)0.455555555556, (Object)0.456910569106));
        data.put("Y541-U02", new Pair((Object)0.39375, (Object)0.454044117647));
        data.put("Y635-L01", new Pair((Object)0.490625, (Object)0.505514705882));
        data.put("Y635-L03", new Pair((Object)0.378125, (Object)0.452205882353));
        data.put("Y635-L21", new Pair((Object)0.378125, (Object)0.558823529412));
        data.put("YU4711", new Pair((Object)0.741666666667, (Object)0.506172839506));
        data.put("Z1", new Pair((Object)0.561111111111, (Object)0.544715447154));
        data.put("Z3", new Pair((Object)0.702777777778, (Object)0.608465608466));
        data.put("Z9 Plus", new Pair((Object)0.380555555556, (Object)0.245528455285));
        data.put("Z10", new Pair((Object)0.544270833333, (Object)0.556218057922));
        data.put("Z90", new Pair((Object)0.411111111111, (Object)0.402597402597));
        data.put("Z150", new Pair((Object)0.735416666667, (Object)0.942401960784));
        data.put("Z557BL", new Pair((Object)0.478125, (Object)0.532967032967));
        data.put("Z667T", new Pair((Object)0.5, (Object)0.485714285714));
        data.put("Z716BL", new Pair((Object)0.50625, (Object)0.594488188976));
        data.put("Z717VL", new Pair((Object)0.671875, (Object)0.527559055118));
        data.put("Z755", new Pair((Object)0.603125, (Object)0.564960629921));
        data.put("Z792", new Pair((Object)0.353125, (Object)0.516544117647));
        data.put("Z793C", new Pair((Object)0.496875, (Object)0.448529411765));
        data.put("Z797C", new Pair((Object)0.694444444444, (Object)0.204989154013));
        data.put("Z812", new Pair((Object)0.471875, (Object)0.591911764706));
        data.put("Z813", new Pair((Object)0.596875, (Object)0.522058823529));
        data.put("Z818L", new Pair((Object)0.59375, (Object)0.487132352941));
        data.put("Z820", new Pair((Object)0.425, (Object)0.538602941176));
        data.put("Z828", new Pair((Object)0.365625, (Object)0.444852941176));
        data.put("Z832", new Pair((Object)0.45625, (Object)0.549450549451));
        data.put("Z833", new Pair((Object)0.484375, (Object)0.521978021978));
        data.put("Z835", new Pair((Object)0.515625, (Object)0.532967032967));
        data.put("Z836BL", new Pair((Object)0.55, (Object)0.401098901099));
        data.put("Z837VL", new Pair((Object)0.484375, (Object)0.794871794872));
        data.put("Z839", new Pair((Object)0.5, (Object)0.562271062271));
        data.put("Z850", new Pair((Object)0.494444444444, (Object)0.608130081301));
        data.put("Z899VL", new Pair((Object)0.53125, (Object)0.510989010989));
        data.put("Z917VL", new Pair((Object)0.413888888889, (Object)0.50974025974));
        data.put("Z936L", new Pair((Object)0.630555555556, (Object)0.489430894309));
        data.put("Z955L", new Pair((Object)0.486111111111, (Object)0.354471544715));
        data.put("Z956", new Pair((Object)0.447222222222, (Object)0.501623376623));
        data.put("Z958", new Pair((Object)0.486111111111, (Object)0.567479674797));
        data.put("Z959", new Pair((Object)0.363888888889, (Object)0.546341463415));
        data.put("Z962BL", new Pair((Object)0.472222222222, (Object)0.640650406504));
        data.put("Z963U", new Pair((Object)0.480555555556, (Object)0.413008130081));
        data.put("Z963VL", new Pair((Object)0.533333333333, (Object)0.478048780488));
        data.put("Z970", new Pair((Object)0.516666666667, (Object)0.526829268293));
        data.put("Z971", new Pair((Object)0.516666666667, (Object)0.48538961039));
        data.put("Z981", new Pair((Object)0.477777777778, (Object)0.488636363636));
        data.put("Z987", new Pair((Object)0.472222222222, (Object)0.453262786596));
        data.put("Z999", new Pair((Object)0.413888888889, (Object)0.31338028169));
        data.put("ZTE A2017G", new Pair((Object)0.461111111111, (Object)0.25487012987));
        data.put("ZTE B2015", new Pair((Object)0.575, (Object)0.569664902998));
        data.put("ZTE BLADE A5 PRO", new Pair((Object)0.7625, (Object)0.110236220472));
        data.put("ZTE BLADE A320", new Pair((Object)0.234375, (Object)0.40293040293));
        data.put("ZTE BLADE A506", new Pair((Object)0.463888888889, (Object)0.566558441558));
        data.put("ZTE BLADE A520", new Pair((Object)0.408333333333, (Object)0.456168831169));
        data.put("ZTE BLADE A610", new Pair((Object)0.402777777778, (Object)0.402597402597));
        data.put("ZTE BLADE L111", new Pair((Object)0.540625, (Object)0.561023622047));
        data.put("ZTE Blade L5", new Pair((Object)0.45, (Object)0.645220588235));
        data.put("ZTE BLADE V0720", new Pair((Object)0.458333333333, (Object)0.487012987013));
        data.put("ZTE BLADE V0800", new Pair((Object)0.45625, (Object)0.581651376147));
        data.put("ZTE BLADE V0820", new Pair((Object)0.416666666667, (Object)0.491883116883));
        data.put("ZTE BLADE V0850", new Pair((Object)0.419444444444, (Object)0.297077922078));
        data.put("Zumbo_S_2017", new Pair((Object)0.427777777778, (Object)0.43485915493));
        SWEETSPOT_DATA = Collections.unmodifiableMap(data);
    }
}

