/*
 * Decompiled with CFR 0.152.
 */
package de.comahe.gradle.plugin.maven.settings;

import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.jetbrains.annotations.NotNull;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/comahe/gradle/plugin/maven/settings/LocalMavenSettingsLoader;", "", "userSettingsFile", "Ljava/io/File;", "(Ljava/io/File;)V", "decryptCredentials", "", "settings", "Lorg/apache/maven/settings/Settings;", "loadSettings", "Companion", "gradle-maven-settings-plugin"})
public final class LocalMavenSettingsLoader {
    private final File userSettingsFile;
    @NotNull
    private static final File GLOBAL_SETTINGS_FILE;
    @NotNull
    private static final String SETTINGS_SECURITY_FILE_LOCATION;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Settings loadSettings() throws SettingsBuildingException {
        Settings settings;
        SettingsBuildingResult settingsBuildingResult;
        SettingsBuildingRequest settingsBuildingRequest = (SettingsBuildingRequest)new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setUserSettingsFile(this.userSettingsFile);
        settingsBuildingRequest.setGlobalSettingsFile(GLOBAL_SETTINGS_FILE);
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = factory.newInstance();
        SettingsBuildingResult settingsBuildingResult2 = settingsBuildingResult = settingsBuilder.build(settingsBuildingRequest);
        Intrinsics.checkNotNullExpressionValue((Object)settingsBuildingResult2, (String)"settingsBuildingResult");
        Settings settings2 = settings = settingsBuildingResult2.getEffectiveSettings();
        Intrinsics.checkNotNullExpressionValue((Object)settings2, (String)"settings");
        this.decryptCredentials(settings2);
        return settings;
    }

    private final void decryptCredentials(Settings settings) {
        try {
            String masterPassword = null;
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            File settingsSecurityFile = new File(SETTINGS_SECURITY_FILE_LOCATION);
            boolean hasSettingsSecurity = false;
            if (settingsSecurityFile.exists() && !settingsSecurityFile.isDirectory()) {
                SettingsSecurity settingsSecurity;
                SettingsSecurity settingsSecurity2 = settingsSecurity = SecUtil.read((String)SETTINGS_SECURITY_FILE_LOCATION, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)settingsSecurity2, (String)"settingsSecurity");
                masterPassword = cipher.decryptDecorated(settingsSecurity2.getMaster(), "settings.security");
                hasSettingsSecurity = true;
            }
            Iterator iterator = settings.getServers().iterator();
            while (iterator.hasNext()) {
                Server server;
                Server server2 = server = (Server)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)server2, (String)"server");
                if (cipher.isEncryptedString(server2.getPassword())) {
                    if (hasSettingsSecurity) {
                        server.setPassword(cipher.decryptDecorated(server.getPassword(), masterPassword));
                    } else {
                        throw (Throwable)new RuntimeException("Maven settings contains encrypted credentials yet no settings-security.xml exists.");
                    }
                }
                if (!cipher.isEncryptedString(server.getPassphrase())) continue;
                if (hasSettingsSecurity) {
                    server.setPassphrase(cipher.decryptDecorated(server.getPassphrase(), masterPassword));
                    continue;
                }
                throw (Throwable)new RuntimeException("Maven settings contains encrypted credentials yet no settings-security.xml exists.");
            }
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Unable to decrypt local Maven settings credentials.", e);
        }
    }

    public LocalMavenSettingsLoader(@NotNull File userSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)userSettingsFile, (String)"userSettingsFile");
        this.userSettingsFile = userSettingsFile;
    }

    static {
        Companion = new Companion(null);
        GLOBAL_SETTINGS_FILE = new File(System.getenv("M2_HOME"), "conf/settings.xml");
        SETTINGS_SECURITY_FILE_LOCATION = System.getProperty("user.home") + "/.m2/settings-security.xml";
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lde/comahe/gradle/plugin/maven/settings/LocalMavenSettingsLoader$Companion;", "", "()V", "GLOBAL_SETTINGS_FILE", "Ljava/io/File;", "getGLOBAL_SETTINGS_FILE", "()Ljava/io/File;", "SETTINGS_SECURITY_FILE_LOCATION", "", "getSETTINGS_SECURITY_FILE_LOCATION", "()Ljava/lang/String;", "gradle-maven-settings-plugin"})
    public static final class Companion {
        @NotNull
        public final File getGLOBAL_SETTINGS_FILE() {
            return GLOBAL_SETTINGS_FILE;
        }

        @NotNull
        public final String getSETTINGS_SECURITY_FILE_LOCATION() {
            return SETTINGS_SECURITY_FILE_LOCATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

