/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;

public class BasicAuthHttpHeaderProvider
implements HttpHeadersProvider {
    private static final String[] USERNAME_KEYS = new String[]{"user.name", "user-name", "username"};
    private static final String[] PASSWORD_KEYS = new String[]{"user.password", "user-password", "userpassword"};
    private final @Nullable String defaultUserName;
    private final @Nullable String defaultPassword;
    private final Map<String, InstanceCredentials> serviceMap;

    public BasicAuthHttpHeaderProvider(@Nullable String defaultUserName, @Nullable String defaultPassword, Map<String, InstanceCredentials> serviceMap) {
        this.defaultUserName = defaultUserName;
        this.defaultPassword = defaultPassword;
        this.serviceMap = serviceMap;
    }

    public BasicAuthHttpHeaderProvider() {
        this(null, null, Collections.emptyMap());
    }

    private static @Nullable String getMetadataValue(Instance instance, String[] keys) {
        Map<String, String> metadata = instance.getRegistration().getMetadata();
        for (String key : keys) {
            String value = metadata.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static String base64Encode(byte[] src) {
        if (src.length == 0) {
            return "";
        }
        byte[] dest = Base64.getEncoder().encode(src);
        return new String(dest, StandardCharsets.UTF_8);
    }

    @Override
    public HttpHeaders getHeaders(Instance instance) {
        String username = BasicAuthHttpHeaderProvider.getMetadataValue(instance, USERNAME_KEYS);
        String password = BasicAuthHttpHeaderProvider.getMetadataValue(instance, PASSWORD_KEYS);
        if (!StringUtils.hasText((String)username) || !StringUtils.hasText((String)password)) {
            String registeredName = instance.getRegistration().getName();
            InstanceCredentials credentials = this.serviceMap.get(registeredName);
            if (credentials != null) {
                username = credentials.getUserName();
                password = credentials.getUserPassword();
            } else {
                username = this.defaultUserName;
                password = this.defaultPassword;
            }
        }
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            headers.set("Authorization", this.encode(username, password));
        }
        return headers;
    }

    protected String encode(String username, String password) {
        String token = BasicAuthHttpHeaderProvider.base64Encode((username + ":" + password).getBytes(StandardCharsets.UTF_8));
        return "Basic " + token;
    }

    public static class InstanceCredentials {
        @NonNull
        private String userName;
        @NonNull
        private String userPassword;

        @NonNull
        @Generated
        public String getUserName() {
            return this.userName;
        }

        @NonNull
        @Generated
        public String getUserPassword() {
            return this.userPassword;
        }

        @Generated
        public void setUserName(@NonNull String userName) {
            if (userName == null) {
                throw new NullPointerException("userName is marked non-null but is null");
            }
            this.userName = userName;
        }

        @Generated
        public void setUserPassword(@NonNull String userPassword) {
            if (userPassword == null) {
                throw new NullPointerException("userPassword is marked non-null but is null");
            }
            this.userPassword = userPassword;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceCredentials)) {
                return false;
            }
            InstanceCredentials other = (InstanceCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$userPassword = this.getUserPassword();
            String other$userPassword = other.getUserPassword();
            return !(this$userPassword == null ? other$userPassword != null : !this$userPassword.equals(other$userPassword));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InstanceCredentials;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $userPassword = this.getUserPassword();
            result = result * 59 + ($userPassword == null ? 43 : $userPassword.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BasicAuthHttpHeaderProvider.InstanceCredentials(userName=" + this.getUserName() + ", userPassword=" + this.getUserPassword() + ")";
        }

        @Generated
        public InstanceCredentials() {
        }

        @Generated
        public InstanceCredentials(@NonNull String userName, @NonNull String userPassword) {
            if (userName == null) {
                throw new NullPointerException("userName is marked non-null but is null");
            }
            if (userPassword == null) {
                throw new NullPointerException("userPassword is marked non-null but is null");
            }
            this.userName = userName;
            this.userPassword = userPassword;
        }
    }
}

