/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.utils.jackson;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class SanitizingMapSerializer
extends StdSerializer<Map<String, String>> {
    private final Pattern[] keysToSanitize;

    public SanitizingMapSerializer(String[] patterns) {
        super(Map.class);
        this.keysToSanitize = SanitizingMapSerializer.createPatterns(patterns);
    }

    private static Pattern[] createPatterns(String ... keys) {
        return (Pattern[])Arrays.stream(keys).map(key -> Pattern.compile(key, 2)).toArray(Pattern[]::new);
    }

    public void serialize(Map<String, String> value, JsonGenerator gen, SerializationContext provider) {
        gen.writeStartObject();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            gen.writeStringProperty(entry.getKey(), this.sanitize(entry.getKey(), entry.getValue()));
        }
        gen.writeEndObject();
    }

    private @Nullable String sanitize(String key, @Nullable String value) {
        if (value == null) {
            return null;
        }
        boolean matchesAnyPattern = Arrays.stream(this.keysToSanitize).anyMatch(pattern -> pattern.matcher(key).matches());
        return matchesAnyPattern ? "******" : value;
    }
}

