/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify.filter;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.notify.filter.ExpiringNotificationFilter;
import java.time.Instant;
import org.jspecify.annotations.Nullable;

public class InstanceIdNotificationFilter
extends ExpiringNotificationFilter {
    private final InstanceId instanceId;

    public InstanceIdNotificationFilter(InstanceId instanceId, @Nullable Instant expiry) {
        super(expiry);
        this.instanceId = instanceId;
    }

    @Override
    protected boolean doFilter(InstanceEvent event, Instance instance) {
        return this.instanceId.equals(event.getInstance());
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public String toString() {
        return "NotificationFilter [instanceId=" + String.valueOf(this.instanceId) + ", expiry=" + String.valueOf(this.getExpiry()) + "]";
    }
}

