/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class WebexNotifier
extends AbstractContentNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebexNotifier.class);
    private static final URI DEFAULT_URL = URI.create("https://webexapis.com/v1/messages");
    private static final String DEFAULT_MESSAGE = "<strong>#{name}</strong>/#{id} is <strong>#{status}</strong>";
    private RestTemplate restTemplate;
    private URI url = DEFAULT_URL;
    private @Nullable String authToken;
    private @Nullable String roomId;

    public WebexNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        if (this.authToken == null) {
            return Mono.error((Throwable)new IllegalStateException("'authToken' must not be null."));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.authToken);
        LOGGER.debug("Event: {}", (Object)event.getInstance());
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.url, (Object)new HttpEntity(this.createMessage(event, instance), headers), Void.class));
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("roomId", this.roomId);
        parameters.put("markdown", this.createContent(event, instance));
        return parameters;
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public @Nullable String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String authToken) {
        this.authToken = authToken;
    }

    public @Nullable String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(@Nullable String roomId) {
        this.roomId = roomId;
    }
}

