/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class SlackNotifier
extends AbstractContentNotifier {
    private static final String DEFAULT_MESSAGE = "*#{name}* (#{id}) is *#{status}*";
    private RestTemplate restTemplate;
    @Nullable
    private URI webhookUrl;
    @Nullable
    private String channel;
    @Nullable
    private String icon;
    @Nullable
    private String username = "Spring Boot Admin";

    public SlackNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        if (this.webhookUrl == null) {
            return Mono.error((Throwable)new IllegalStateException("'webhookUrl' must not be null."));
        }
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.webhookUrl, this.createMessage(event, instance), Void.class));
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> messageJson = new HashMap<String, Object>();
        messageJson.put("username", this.username);
        if (this.icon != null) {
            messageJson.put("icon_emoji", ":" + this.icon + ":");
        }
        if (this.channel != null) {
            messageJson.put("channel", this.channel);
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>();
        attachments.put("text", this.createContent(event, instance));
        attachments.put("color", this.getColor(event));
        attachments.put("mrkdwn_in", Collections.singletonList("text"));
        messageJson.put("attachments", Collections.singletonList(attachments));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity(messageJson, (MultiValueMap)headers);
    }

    protected String getColor(InstanceEvent event) {
        if (event instanceof InstanceStatusChangedEvent) {
            InstanceStatusChangedEvent statusChangedEvent = (InstanceStatusChangedEvent)event;
            return "UP".equals(statusChangedEvent.getStatusInfo().getStatus()) ? "good" : "danger";
        }
        return "#439FE0";
    }

    @Nullable
    public URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(@Nullable URI webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    @Nullable
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(@Nullable String channel) {
        this.channel = channel;
    }

    @Nullable
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable String icon) {
        this.icon = icon;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }
}

