/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.filter.AbstractContentNotifier;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class HipchatNotifier
extends AbstractContentNotifier {
    private static final String DEFAULT_DESCRIPTION = "<strong>#{name}</strong>/#{id} is <strong>#{status}</strong>";
    private RestTemplate restTemplate;
    @Nullable
    private URI url;
    @Nullable
    private String authToken;
    @Nullable
    private String roomId;
    private boolean notify = false;

    public HipchatNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.buildUrl(), this.createHipChatNotification(event, instance), Void.class, new Object[0]));
    }

    protected String buildUrl() {
        if (this.url == null) {
            throw new IllegalStateException("'url' must not be null.");
        }
        return String.format("%s/room/%s/notification?auth_token=%s", this.url, this.roomId, this.authToken);
    }

    protected HttpEntity<Map<String, Object>> createHipChatNotification(InstanceEvent event, Instance instance) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("color", this.getColor(event));
        body.put("message", this.createContent(event, instance));
        body.put("notify", this.getNotify());
        body.put("message_format", "html");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    protected boolean getNotify() {
        return this.notify;
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_DESCRIPTION;
    }

    protected String getColor(InstanceEvent event) {
        if (event instanceof InstanceStatusChangedEvent) {
            InstanceStatusChangedEvent statusChangedEvent = (InstanceStatusChangedEvent)event;
            return "UP".equals(statusChangedEvent.getStatusInfo().getStatus()) ? "green" : "red";
        }
        return "gray";
    }

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable URI url) {
        this.url = url;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String authToken) {
        this.authToken = authToken;
    }

    @Nullable
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(@Nullable String roomId) {
        this.roomId = roomId;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

