/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.servlet;

import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.services.InstanceRegistry;
import de.codecentric.boot.admin.server.web.AdminController;
import de.codecentric.boot.admin.server.web.HttpHeaderFilter;
import de.codecentric.boot.admin.server.web.InstanceWebProxy;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Set;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@AdminController
public class InstancesProxyController {
    private static final String INSTANCE_MAPPED_PATH = "/instances/{instanceId}/actuator/**";
    private static final String APPLICATION_MAPPED_PATH = "/applications/{applicationName}/actuator/**";
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private final PathMatcher pathMatcher = new AntPathMatcher();
    private final InstanceWebProxy instanceWebProxy;
    private final HttpHeaderFilter httpHeadersFilter;
    private final InstanceRegistry registry;
    private final String adminContextPath;

    public InstancesProxyController(String adminContextPath, Set<String> ignoredHeaders, InstanceRegistry registry, InstanceWebClient instanceWebClient) {
        this.adminContextPath = adminContextPath;
        this.registry = registry;
        this.httpHeadersFilter = new HttpHeaderFilter(ignoredHeaders);
        this.instanceWebProxy = new InstanceWebProxy(instanceWebClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(path={"/instances/{instanceId}/actuator/**"}, method={RequestMethod.GET, RequestMethod.HEAD, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS})
    public void instanceProxy(@PathVariable(value="instanceId") String instanceId, HttpServletRequest servletRequest) {
        AsyncContext asyncContext = servletRequest.startAsync();
        asyncContext.setTimeout(-1L);
        try {
            ServletServerHttpRequest request = new ServletServerHttpRequest((HttpServletRequest)asyncContext.getRequest());
            Flux requestBody = DataBufferUtils.readInputStream(() -> ((ServletServerHttpRequest)request).getBody(), (DataBufferFactory)this.bufferFactory, (int)4096);
            InstanceWebProxy.ForwardRequest fwdRequest = this.createForwardRequest(request, (Flux<DataBuffer>)requestBody, this.adminContextPath + INSTANCE_MAPPED_PATH);
            this.instanceWebProxy.forward(this.registry.getInstance(InstanceId.of(instanceId)), fwdRequest, clientResponse -> {
                ServletServerHttpResponse response = new ServletServerHttpResponse((HttpServletResponse)asyncContext.getResponse());
                response.setStatusCode(clientResponse.statusCode());
                response.getHeaders().addAll((MultiValueMap)this.httpHeadersFilter.filterHeaders(clientResponse.headers().asHttpHeaders()));
                try {
                    OutputStream responseBody = response.getBody();
                    response.flush();
                    return ((Flux)clientResponse.body(BodyExtractors.toDataBuffers())).window(1).concatMap(body -> this.writeAndFlush((Flux<DataBuffer>)body, responseBody)).then();
                }
                catch (IOException ex) {
                    return Mono.error((Throwable)ex);
                }
            }).block();
        }
        finally {
            asyncContext.complete();
        }
    }

    @ResponseBody
    @RequestMapping(path={"/applications/{applicationName}/actuator/**"}, method={RequestMethod.GET, RequestMethod.HEAD, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS})
    public Flux<InstanceWebProxy.InstanceResponse> endpointProxy(@PathVariable(value="applicationName") String applicationName, HttpServletRequest servletRequest) {
        ServletServerHttpRequest request = new ServletServerHttpRequest(servletRequest);
        Flux cachedBody = DataBufferUtils.readInputStream(() -> ((ServletServerHttpRequest)request).getBody(), (DataBufferFactory)this.bufferFactory, (int)4096).cache();
        InstanceWebProxy.ForwardRequest fwdRequest = this.createForwardRequest(request, (Flux<DataBuffer>)cachedBody, this.adminContextPath + APPLICATION_MAPPED_PATH);
        return this.instanceWebProxy.forward(this.registry.getInstances(applicationName), fwdRequest);
    }

    private InstanceWebProxy.ForwardRequest createForwardRequest(ServletServerHttpRequest request, Flux<DataBuffer> body, String pathPattern) {
        String endpointLocalPath = this.getLocalPath(pathPattern, request);
        URI uri = UriComponentsBuilder.fromPath((String)endpointLocalPath).query(request.getURI().getRawQuery()).build(true).toUri();
        return InstanceWebProxy.ForwardRequest.builder().uri(uri).method(request.getMethod()).headers(this.httpHeadersFilter.filterHeaders(request.getHeaders())).body(BodyInserters.fromDataBuffers(body)).build();
    }

    private String getLocalPath(String pathPattern, ServletServerHttpRequest request) {
        String pathWithinApplication = request.getServletRequest().getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE).toString();
        return this.pathMatcher.extractPathWithinPattern(pathPattern, pathWithinApplication);
    }

    private Mono<Void> writeAndFlush(Flux<DataBuffer> body, OutputStream responseBody) {
        return DataBufferUtils.write(body, (OutputStream)responseBody).map(DataBufferUtils::release).then(Mono.create(sink -> {
            try {
                responseBody.flush();
                sink.success();
            }
            catch (IOException ex) {
                sink.error((Throwable)ex);
            }
        }));
    }
}

