/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class PagerdutyNotifier
extends AbstractStatusChangeNotifier {
    public static final URI DEFAULT_URI = URI.create("https://events.pagerduty.com/generic/2010-04-15/create_event.json");
    private static final String DEFAULT_DESCRIPTION = "#{instance.registration.name}/#{instance.id} is #{instance.statusInfo.status}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    private URI url = DEFAULT_URI;
    @Nullable
    private String serviceKey;
    @Nullable
    private String client;
    @Nullable
    private URI clientUrl;
    private Expression description;

    public PagerdutyNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.description = this.parser.parseExpression(DEFAULT_DESCRIPTION, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.url, this.createPagerdutyEvent(event, instance), Void.class));
    }

    protected Map<String, Object> createPagerdutyEvent(InstanceEvent event, Instance instance) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("service_key", this.serviceKey);
        result.put("incident_key", instance.getRegistration().getName() + "/" + event.getInstance());
        result.put("description", this.getDescription(event, instance));
        Map<String, Object> details = this.getDetails(event);
        result.put("details", details);
        if (event instanceof InstanceStatusChangedEvent) {
            if ("UP".equals(((InstanceStatusChangedEvent)event).getStatusInfo().getStatus())) {
                result.put("event_type", "resolve");
            } else {
                result.put("event_type", "trigger");
                if (this.client != null) {
                    result.put("client", this.client);
                }
                if (this.clientUrl != null) {
                    result.put("client_url", this.clientUrl);
                }
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("type", "link");
                context.put("href", instance.getRegistration().getHealthUrl());
                context.put("text", "Application health-endpoint");
                result.put("contexts", Collections.singletonList(context));
            }
        }
        return result;
    }

    @Nullable
    protected String getDescription(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess(), new MapAccessor()}).withRootObject(root).build();
        return (String)this.description.getValue((EvaluationContext)context, String.class);
    }

    protected Map<String, Object> getDetails(InstanceEvent event) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        if (event instanceof InstanceStatusChangedEvent) {
            details.put("from", this.getLastStatus(event.getInstance()));
            details.put("to", ((InstanceStatusChangedEvent)event).getStatusInfo());
        }
        return details;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    @Nullable
    public String getClient() {
        return this.client;
    }

    public void setClient(@Nullable String client) {
        this.client = client;
    }

    @Nullable
    public URI getClientUrl() {
        return this.clientUrl;
    }

    public void setClientUrl(@Nullable URI clientUrl) {
        this.clientUrl = clientUrl;
    }

    @Nullable
    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(@Nullable String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String getDescription() {
        return this.description.getExpressionString();
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

