/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.StatusInfo;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class StatusUpdater {
    private static final Logger log = LoggerFactory.getLogger(StatusUpdater.class);
    private static final ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final InstanceRepository repository;
    private final InstanceWebClient instanceWebClient;

    public StatusUpdater(InstanceRepository repository, InstanceWebClient instanceWebClient) {
        this.repository = repository;
        this.instanceWebClient = instanceWebClient;
    }

    public Mono<Void> updateStatus(InstanceId id) {
        return this.repository.computeIfPresent(id, (key, instance) -> this.doUpdateStatus((Instance)instance)).then();
    }

    protected Mono<Instance> doUpdateStatus(Instance instance) {
        if (!instance.isRegistered()) {
            return Mono.empty();
        }
        log.debug("Update status for {}", (Object)instance);
        return this.instanceWebClient.instance(instance).get().uri("health", new Object[0]).exchangeToMono(this::convertStatusInfo).log(log.getName(), Level.FINEST, new SignalType[0]).doOnError(ex -> this.logError(instance, (Throwable)ex)).onErrorResume(this::handleError).map(instance::withStatusInfo);
    }

    protected Mono<StatusInfo> convertStatusInfo(ClientResponse response) {
        Boolean hasCompatibleContentType = response.headers().contentType().map(mt -> mt.isCompatibleWith(MediaType.APPLICATION_JSON) || mt.isCompatibleWith(de.codecentric.boot.admin.server.utils.MediaType.ACTUATOR_V2_MEDIATYPE)).orElse(false);
        StatusInfo statusInfoFromStatus = this.getStatusInfoFromStatus(response.statusCode(), Collections.emptyMap());
        if (hasCompatibleContentType.booleanValue()) {
            return response.bodyToMono(RESPONSE_TYPE).map(body -> {
                if (body.get("status") instanceof String) {
                    return StatusInfo.from(body);
                }
                return this.getStatusInfoFromStatus(response.statusCode(), (Map<String, ?>)body);
            }).defaultIfEmpty((Object)statusInfoFromStatus);
        }
        return response.releaseBody().then(Mono.just((Object)statusInfoFromStatus));
    }

    protected StatusInfo getStatusInfoFromStatus(HttpStatus httpStatus, Map<String, ?> body) {
        if (httpStatus.is2xxSuccessful()) {
            return StatusInfo.ofUp();
        }
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("status", httpStatus.value());
        details.put("error", httpStatus.getReasonPhrase());
        if (body.get("details") instanceof Map) {
            details.putAll((Map)body.get("details"));
        } else {
            details.putAll(body);
        }
        return StatusInfo.ofDown(details);
    }

    protected Mono<StatusInfo> handleError(Throwable ex) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("message", ex.getMessage());
        details.put("exception", ex.getClass().getName());
        return Mono.just((Object)StatusInfo.ofOffline(details));
    }

    protected void logError(Instance instance, Throwable ex) {
        if (instance.getStatusInfo().isOffline()) {
            log.debug("Couldn't retrieve status for {}", (Object)instance, (Object)ex);
        } else {
            log.info("Couldn't retrieve status for {}", (Object)instance, (Object)ex);
        }
    }
}

