/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.services.InstanceIdGenerator;
import org.springframework.util.StringUtils;

public class CloudFoundryInstanceIdGenerator
implements InstanceIdGenerator {
    private final InstanceIdGenerator fallbackIdGenerator;

    public CloudFoundryInstanceIdGenerator(InstanceIdGenerator fallbackIdGenerator) {
        this.fallbackIdGenerator = fallbackIdGenerator;
    }

    @Override
    public InstanceId generateId(Registration registration) {
        String applicationId = registration.getMetadata().get("applicationId");
        String instanceId = registration.getMetadata().get("instanceId");
        if (StringUtils.hasText((String)applicationId) && StringUtils.hasText((String)instanceId)) {
            return InstanceId.of(String.format("%s:%s", applicationId, instanceId));
        }
        return this.fallbackIdGenerator.generateId(registration);
    }
}

