/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.values.Endpoint;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import de.codecentric.boot.admin.server.web.client.InstanceExchangeFilterFunction;
import de.codecentric.boot.admin.server.web.client.LegacyEndpointConverter;
import de.codecentric.boot.admin.server.web.client.exception.ResolveEndpointException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class InstanceExchangeFilterFunctions {
    private static final Logger log = LoggerFactory.getLogger(InstanceExchangeFilterFunctions.class);
    public static final String ATTRIBUTE_ENDPOINT = "endpointId";
    private static final List<MediaType> DEFAULT_ACCEPT_MEDIATYPES = Arrays.asList(MediaType.parseMediaType((String)"application/vnd.spring-boot.actuator.v2+json"), MediaType.parseMediaType((String)"application/vnd.spring-boot.actuator.v1+json"), MediaType.APPLICATION_JSON);
    private static final List<MediaType> DEFAULT_LOGFILE_ACCEPT_MEDIATYPES = Collections.singletonList(MediaType.TEXT_PLAIN);

    private InstanceExchangeFilterFunctions() {
    }

    public static InstanceExchangeFilterFunction addHeaders(HttpHeadersProvider httpHeadersProvider) {
        return (instance, request, next) -> {
            request = ClientRequest.from((ClientRequest)request).headers(headers -> headers.addAll((MultiValueMap)httpHeadersProvider.getHeaders(instance))).build();
            return next.exchange(request);
        };
    }

    public static InstanceExchangeFilterFunction rewriteEndpointUrl() {
        return (instance, request, next) -> {
            if (request.url().isAbsolute()) {
                log.trace("Absolute URL '{}' for instance {} not rewritten", (Object)request.url(), (Object)instance.getId());
                if (request.url().toString().equals(instance.getRegistration().getManagementUrl())) {
                    request = ClientRequest.from((ClientRequest)request).attribute(ATTRIBUTE_ENDPOINT, (Object)"actuator-index").build();
                }
                return next.exchange(request);
            }
            UriComponents requestUrl = UriComponentsBuilder.fromUri((URI)request.url()).build();
            if (requestUrl.getPathSegments().isEmpty()) {
                return Mono.error((Throwable)new ResolveEndpointException("No endpoint specified"));
            }
            String endpointId = (String)requestUrl.getPathSegments().get(0);
            Optional<Endpoint> endpoint = instance.getEndpoints().get(endpointId);
            if (!endpoint.isPresent()) {
                return Mono.error((Throwable)new ResolveEndpointException("Endpoint '" + endpointId + "' not found"));
            }
            URI rewrittenUrl = InstanceExchangeFilterFunctions.rewriteUrl(requestUrl, endpoint.get().getUrl());
            log.trace("URL '{}' for Endpoint {} of instance {} rewritten to {}", new Object[]{requestUrl, endpoint.get().getId(), instance.getId(), rewrittenUrl});
            request = ClientRequest.from((ClientRequest)request).attribute(ATTRIBUTE_ENDPOINT, (Object)endpoint.get().getId()).url(rewrittenUrl).build();
            return next.exchange(request);
        };
    }

    private static URI rewriteUrl(UriComponents oldUrl, String targetUrl) {
        String[] newPathSegments = oldUrl.getPathSegments().subList(1, oldUrl.getPathSegments().size()).toArray(new String[0]);
        return UriComponentsBuilder.fromUriString((String)targetUrl).pathSegment(newPathSegments).query(oldUrl.getQuery()).build(true).toUri();
    }

    public static InstanceExchangeFilterFunction convertLegacyEndpoints(List<LegacyEndpointConverter> converters) {
        return (instance, request, next) -> {
            Mono clientResponse = next.exchange(request);
            Optional endpoint = request.attribute(ATTRIBUTE_ENDPOINT);
            if (!endpoint.isPresent()) {
                return clientResponse;
            }
            for (LegacyEndpointConverter converter : converters) {
                if (!converter.canConvert(endpoint.get())) continue;
                return clientResponse.map(response -> {
                    if (InstanceExchangeFilterFunctions.isLegacyResponse(response).booleanValue()) {
                        return InstanceExchangeFilterFunctions.convertLegacyResponse(converter, response);
                    }
                    return response;
                });
            }
            return clientResponse;
        };
    }

    private static Boolean isLegacyResponse(ClientResponse response) {
        return response.headers().contentType().map(t -> de.codecentric.boot.admin.server.utils.MediaType.ACTUATOR_V1_MEDIATYPE.isCompatibleWith(t) || MediaType.APPLICATION_JSON.isCompatibleWith(t)).orElse(false);
    }

    private static ClientResponse convertLegacyResponse(LegacyEndpointConverter converter, ClientResponse response) {
        return ClientResponse.from((ClientResponse)response).headers(headers -> {
            headers.replace((Object)"Content-Type", Collections.singletonList("application/vnd.spring-boot.actuator.v2+json"));
            headers.remove((Object)"Content-Length");
        }).body(response.bodyToFlux(DataBuffer.class).transform(converter::convert)).build();
    }

    public static InstanceExchangeFilterFunction setDefaultAcceptHeader() {
        return (instance, request, next) -> {
            if (request.headers().getAccept().isEmpty()) {
                Boolean isRequestForLogfile = request.attribute(ATTRIBUTE_ENDPOINT).map("logfile"::equals).orElse(false);
                List<MediaType> acceptedHeaders = isRequestForLogfile != false ? DEFAULT_LOGFILE_ACCEPT_MEDIATYPES : DEFAULT_ACCEPT_MEDIATYPES;
                request = ClientRequest.from((ClientRequest)request).headers(headers -> headers.setAccept(acceptedHeaders)).build();
            }
            return next.exchange(request);
        };
    }

    public static InstanceExchangeFilterFunction retry(int defaultRetries, Map<String, Integer> retriesPerEndpoint) {
        return (instance, request, next) -> {
            int retries = 0;
            if (!(request.method().equals((Object)HttpMethod.DELETE) || request.method().equals((Object)HttpMethod.PATCH) || request.method().equals((Object)HttpMethod.POST) || request.method().equals((Object)HttpMethod.PUT))) {
                retries = request.attribute(ATTRIBUTE_ENDPOINT).map(retriesPerEndpoint::get).orElse(defaultRetries);
            }
            return next.exchange(request).retry((long)retries);
        };
    }

    public static InstanceExchangeFilterFunction timeout(Duration defaultTimeout, Map<String, Duration> timeoutPerEndpoint) {
        return (instance, request, next) -> {
            Duration timeout = request.attribute(ATTRIBUTE_ENDPOINT).map(timeoutPerEndpoint::get).orElse(defaultTimeout);
            return next.exchange(request).timeout(timeout);
        };
    }

    public static InstanceExchangeFilterFunction logfileAcceptWorkaround() {
        return (instance, request, next) -> {
            if (request.attribute(ATTRIBUTE_ENDPOINT).map("logfile"::equals).orElse(false).booleanValue()) {
                List newAcceptHeaders = Stream.concat(request.headers().getAccept().stream(), Stream.of(MediaType.ALL)).collect(Collectors.toList());
                request = ClientRequest.from((ClientRequest)request).headers(h -> h.setAccept(newAcceptHeaders)).build();
            }
            return next.exchange(request);
        };
    }
}

