/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.config;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import de.codecentric.boot.admin.server.config.AdminServerAutoConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerMarkerConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerNotifierAutoConfiguration;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.eventstore.HazelcastEventStore;
import de.codecentric.boot.admin.server.eventstore.InstanceEventStore;
import de.codecentric.boot.admin.server.notify.HazelcastNotificationTrigger;
import de.codecentric.boot.admin.server.notify.NotificationTrigger;
import de.codecentric.boot.admin.server.notify.Notifier;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={AdminServerMarkerConfiguration.Marker.class})
@ConditionalOnSingleCandidate(value=HazelcastInstance.class)
@ConditionalOnProperty(prefix="spring.boot.admin.hazelcast", name={"enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={AdminServerAutoConfiguration.class, AdminServerNotifierAutoConfiguration.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
public class AdminServerHazelcastAutoConfiguration {
    public static final String DEFAULT_NAME_EVENT_STORE_MAP = "spring-boot-admin-event-store";
    public static final String DEFAULT_NAME_SENT_NOTIFICATIONS_MAP = "spring-boot-admin-sent-notifications";
    @Value(value="${spring.boot.admin.hazelcast.event-store:spring-boot-admin-event-store}")
    private String nameEventStoreMap = "spring-boot-admin-event-store";

    @Bean
    @ConditionalOnMissingBean(value={InstanceEventStore.class})
    public HazelcastEventStore eventStore(HazelcastInstance hazelcastInstance) {
        IMap map = hazelcastInstance.getMap(this.nameEventStoreMap);
        return new HazelcastEventStore((IMap<InstanceId, List<InstanceEvent>>)map);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Notifier.class})
    public static class NotifierTriggerConfiguration {
        @Value(value="${spring.boot.admin.hazelcast.sent-notifications:spring-boot-admin-sent-notifications}")
        private String nameSentNotificationsMap = "spring-boot-admin-sent-notifications";

        @Bean(initMethod="start", destroyMethod="stop")
        @ConditionalOnMissingBean(value={NotificationTrigger.class})
        public NotificationTrigger notificationTrigger(HazelcastInstance hazelcastInstance, Notifier notifier, Publisher<InstanceEvent> events) {
            return new HazelcastNotificationTrigger(notifier, events, (ConcurrentMap<InstanceId, Long>)hazelcastInstance.getMap(this.nameSentNotificationsMap));
        }
    }
}

