/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.config;

import de.codecentric.boot.admin.server.config.AdminServerMarkerConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerProperties;
import de.codecentric.boot.admin.server.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.server.notify.filter.web.NotificationFilterController;
import de.codecentric.boot.admin.server.ui.config.AdminServerUiProperties;
import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import de.codecentric.boot.admin.server.ui.extensions.UiExtensionsScanner;
import de.codecentric.boot.admin.server.ui.web.UiController;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration
@ConditionalOnBean(value={AdminServerMarkerConfiguration.Marker.class})
@AutoConfigureAfter(value={AdminServerWebConfiguration.class})
@EnableConfigurationProperties(value={AdminServerUiProperties.class})
public class AdminServerUiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AdminServerUiAutoConfiguration.class);
    private final AdminServerUiProperties uiProperties;
    private final AdminServerProperties adminServerProperties;
    private final ApplicationContext applicationContext;

    public AdminServerUiAutoConfiguration(AdminServerUiProperties uiProperties, AdminServerProperties serverProperties, ApplicationContext applicationContext) {
        this.uiProperties = uiProperties;
        this.adminServerProperties = serverProperties;
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public UiController homeUiController() throws IOException {
        return new UiController(this.uiProperties.getPublicUrl() != null ? this.uiProperties.getPublicUrl() : this.adminServerProperties.getContextPath(), this.uiProperties.getTitle(), this.uiProperties.getBrand(), this.uiProperties.getFavicon(), this.uiProperties.getFaviconDanger(), this.uiExtensions(), !this.applicationContext.getBeansOfType(NotificationFilterController.class).isEmpty());
    }

    private List<UiExtension> uiExtensions() throws IOException {
        UiExtensionsScanner scanner = new UiExtensionsScanner((ResourcePatternResolver)this.applicationContext);
        List<UiExtension> uiExtensions = scanner.scan(this.uiProperties.getExtensionResourceLocations());
        uiExtensions.forEach(e -> log.info("Loaded Spring Boot Admin UI Extension: {}", e));
        return uiExtensions;
    }

    @Bean
    public SpringResourceTemplateResolver adminTemplateResolver() {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setApplicationContext(this.applicationContext);
        resolver.setPrefix(this.uiProperties.getTemplateLocation());
        resolver.setSuffix(".html");
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resolver.setCacheable(this.uiProperties.isCacheTemplates());
        resolver.setOrder(Integer.valueOf(10));
        resolver.setCheckExistence(true);
        return resolver;
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Configuration
    public static class ServletUiConfiguration
    implements WebMvcConfigurer {
        @Autowired
        private AdminServerUiProperties uiProperties;
        @Autowired
        private AdminServerProperties adminServerProperties;

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{this.adminServerProperties.getContextPath() + "/**"}).addResourceLocations(this.uiProperties.getResourceLocations()).addResourceLocations(this.uiProperties.getExtensionResourceLocations()).setCacheControl(this.uiProperties.getCache().toCacheControl());
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Configuration
    public static class ReactiveUiConfiguration
    implements WebFluxConfigurer {
        @Autowired
        private AdminServerUiProperties uiProperties;
        @Autowired
        private AdminServerProperties adminServerProperties;

        public void addResourceHandlers(org.springframework.web.reactive.config.ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{this.adminServerProperties.getContextPath() + "/**"}).addResourceLocations(this.uiProperties.getResourceLocations()).addResourceLocations(this.uiProperties.getExtensionResourceLocations()).setCacheControl(this.uiProperties.getCache().toCacheControl());
        }
    }
}

