/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.sample;

import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.notify.CompositeNotifier;
import de.codecentric.boot.admin.server.notify.Notifier;
import de.codecentric.boot.admin.server.notify.RemindingNotifier;
import de.codecentric.boot.admin.server.notify.filter.FilteringNotifier;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
public class NotifierConfig {
    private final InstanceRepository repository;
    private final ObjectProvider<List<Notifier>> otherNotifiers;

    public NotifierConfig(InstanceRepository repository, ObjectProvider<List<Notifier>> otherNotifiers) {
        this.repository = repository;
        this.otherNotifiers = otherNotifiers;
    }

    @Bean
    public FilteringNotifier filteringNotifier() {
        CompositeNotifier delegate = new CompositeNotifier((Iterable)this.otherNotifiers.getIfAvailable(Collections::emptyList));
        return new FilteringNotifier((Notifier)delegate, this.repository);
    }

    @Primary
    @Bean(initMethod="start", destroyMethod="stop")
    public RemindingNotifier remindingNotifier() {
        RemindingNotifier notifier = new RemindingNotifier((Notifier)this.filteringNotifier(), this.repository);
        notifier.setReminderPeriod(Duration.ofMinutes(10L));
        notifier.setCheckReminderInverval(Duration.ofSeconds(10L));
        return notifier;
    }
}

