/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.config.InstanceProperties;
import de.codecentric.boot.admin.client.registration.DefaultApplicationFactory;
import de.codecentric.boot.admin.client.registration.metadata.MetadataContributor;
import jakarta.servlet.ServletContext;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.webmvc.autoconfigure.DispatcherServletPath;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ServletApplicationFactory
extends DefaultApplicationFactory {
    private final ServletContext servletContext;
    private final ServerProperties server;
    private final ManagementServerProperties management;
    private final InstanceProperties instance;
    private final DispatcherServletPath dispatcherServletPath;

    public ServletApplicationFactory(InstanceProperties instance, ManagementServerProperties management, ServerProperties server, ServletContext servletContext, PathMappedEndpoints pathMappedEndpoints, WebEndpointProperties webEndpoint, MetadataContributor metadataContributor, DispatcherServletPath dispatcherServletPath) {
        super(instance, management, server, pathMappedEndpoints, webEndpoint, metadataContributor);
        this.servletContext = servletContext;
        this.server = server;
        this.management = management;
        this.instance = instance;
        this.dispatcherServletPath = dispatcherServletPath;
    }

    @Override
    protected String getServiceUrl() {
        if (this.instance.getServiceUrl() != null) {
            return this.instance.getServiceUrl();
        }
        return UriComponentsBuilder.fromUriString((String)this.getServiceBaseUrl()).path(this.getServicePath()).path(this.getServerContextPath()).toUriString();
    }

    @Override
    protected String getManagementBaseUrl() {
        String baseUrl = this.instance.getManagementBaseUrl();
        if (StringUtils.hasText((String)baseUrl)) {
            return baseUrl;
        }
        if (this.isManagementPortEqual()) {
            return UriComponentsBuilder.fromUriString((String)this.getServiceUrl()).path("/").path(this.getDispatcherServletPrefix()).path(this.getManagementContextPath()).toUriString();
        }
        Ssl ssl = this.management.getSsl() != null ? this.management.getSsl() : this.server.getSsl();
        return UriComponentsBuilder.newInstance().scheme(this.getScheme(ssl)).host(this.getManagementHost()).port(this.getLocalManagementPort().intValue()).path(this.getManagementContextPath()).toUriString();
    }

    protected String getManagementContextPath() {
        return this.management.getBasePath();
    }

    protected String getServerContextPath() {
        return this.servletContext.getContextPath();
    }

    protected String getDispatcherServletPrefix() {
        return this.dispatcherServletPath.getPrefix();
    }
}

