/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.logging;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.filter.GenericFilterBean;

public class TimeLoggingFilter
extends GenericFilterBean {
    private static final String MDC_KEY = "time-calltime";
    private static final Logger LOG = LoggerFactory.getLogger(TimeLoggingFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long startMillis = System.currentTimeMillis();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.populateTimingInformation(startMillis);
        }
    }

    private void populateTimingInformation(long startMillis) {
        long callTimeInMs = System.currentTimeMillis() - startMillis;
        MDC.put((String)MDC_KEY, (String)Long.toString(callTimeInMs));
        if (LOG.isInfoEnabled()) {
            LOG.info("Call time {}ms", (Object)callTimeInMs);
        }
    }
}

