/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.logging;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CxfLoggingSoapActionUtil {
    private static final String REGEX_FIND_SOAP_METHOD_NAME_IN_HTTP_HEADER_WITH_URN = "(?<=SOAPAction=\\[\"urn:)[a-zA-Z]+(?=\"])";
    private static final String REGEX_FIND_SOAP_METHOD_NAME_IN_HTTP_HEADER_WITH_URN_WITHOUT_QUOTES = "(?<=SOAPAction=\\[urn:)[a-zA-Z]+(?=\\])";
    private static final String REGEX_FIND_SOAP_METHOD_NAME_IN_HTTP_HEADER_WITH_URL = "(?<=SOAPAction=\\[\")[:./a-zA-Z]+(?=\"])";

    public static String extractSoapMethodNameFromHttpHeader(String header) {
        Matcher matcher = CxfLoggingSoapActionUtil.buildMatcher(header, REGEX_FIND_SOAP_METHOD_NAME_IN_HTTP_HEADER_WITH_URN);
        if (matcher.find()) {
            return matcher.group(0);
        }
        matcher = CxfLoggingSoapActionUtil.buildMatcher(header, REGEX_FIND_SOAP_METHOD_NAME_IN_HTTP_HEADER_WITH_URN_WITHOUT_QUOTES);
        if (matcher.find()) {
            return matcher.group(0);
        }
        matcher = CxfLoggingSoapActionUtil.buildMatcher(header, REGEX_FIND_SOAP_METHOD_NAME_IN_HTTP_HEADER_WITH_URL);
        if (matcher.find()) {
            return CxfLoggingSoapActionUtil.eliminateStartingUrl(matcher.group(0));
        }
        return "";
    }

    private static String eliminateStartingUrl(String methodWithUrl) {
        int lastSlash = methodWithUrl.lastIndexOf(47);
        return methodWithUrl.substring(lastSlash + 1);
    }

    private static Matcher buildMatcher(String string2SearchIn, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(string2SearchIn);
    }
}

