/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.configuration;

import de.codecentric.cxf.logging.soapmsg.SoapMessageLoggingInInterceptor;
import de.codecentric.cxf.logging.soapmsg.SoapMessageLoggingOutInterceptor;
import javax.annotation.PostConstruct;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@Conditional(value={SoapMessageLoggerPropertyCondition.class})
@ConditionalOnProperty(name={"endpoint.autoinit"}, matchIfMissing=true)
public class SoapMessageLoggerConfiguration {
    @Autowired
    private SpringBus springBus;

    @Bean
    @ConditionalOnProperty(value={"soap.messages.logging"})
    public String loggingActivatedLogger() {
        ((SoapMessageLoggingInInterceptor)this.logInInterceptorSoapMsgLogger()).logSoapMessage(true);
        ((SoapMessageLoggingOutInterceptor)this.logOutInterceptorSoapMsgLogger()).logSoapMessage(true);
        return "unused - this is just to activate Logging of SoapMessages via SpringBoot";
    }

    @Bean
    @ConditionalOnProperty(value={"soap.messages.extract"})
    @ConditionalOnResource(resources={"classpath:logback-spring.xml"})
    public String extractionActivatedLogger() {
        ((SoapMessageLoggingInInterceptor)this.logInInterceptorSoapMsgLogger()).extractSoapMessage(true);
        ((SoapMessageLoggingOutInterceptor)this.logOutInterceptorSoapMsgLogger()).extractSoapMessage(true);
        return "unused - this is just to activate Extraction of SoapMessages via SpringBoot";
    }

    @PostConstruct
    public void activateLoggingFeature() {
        this.springBus.getInInterceptors().add(this.logInInterceptorSoapMsgLogger());
        this.springBus.getInFaultInterceptors().add(this.logInInterceptorSoapMsgLogger());
        this.springBus.getOutInterceptors().add(this.logOutInterceptorSoapMsgLogger());
        this.springBus.getOutFaultInterceptors().add(this.logOutInterceptorSoapMsgLogger());
    }

    @Bean
    public AbstractLoggingInterceptor logInInterceptorSoapMsgLogger() {
        SoapMessageLoggingInInterceptor logInInterceptor = new SoapMessageLoggingInInterceptor();
        logInInterceptor.setPrettyLogging(true);
        return logInInterceptor;
    }

    @Bean
    public AbstractLoggingInterceptor logOutInterceptorSoapMsgLogger() {
        SoapMessageLoggingOutInterceptor logOutInterceptor = new SoapMessageLoggingOutInterceptor();
        logOutInterceptor.setPrettyLogging(true);
        return logOutInterceptor;
    }

    static class SoapMessageLoggerPropertyCondition
    extends AnyNestedCondition {
        SoapMessageLoggerPropertyCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"soap.messages.extract"})
        static class ElasticSearchExtractionEnabled {
            ElasticSearchExtractionEnabled() {
            }
        }

        @ConditionalOnProperty(value={"soap.messages.logging"})
        static class LoggingEnabled {
            LoggingEnabled() {
            }
        }
    }
}

