/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.aspect;

import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

abstract class ChaosMonkeyBaseAspect {
    ChaosMonkeyBaseAspect() {
    }

    @Pointcut(value="within(de.codecentric.spring.boot.chaos.monkey..*)")
    public void classInChaosMonkeyPackage() {
    }

    @Pointcut(value="!within(is(FinalType)) || within(com.sun.proxy.*)")
    public void nonFinalOrJdkProxiedClassPointcut() {
    }

    @Pointcut(value="nonFinalOrJdkProxiedClassPointcut() && execution(* *.*(..))")
    public void allPublicMethodPointcut() {
    }

    @Pointcut(value="execution(* postProcess*Initialization(..)) || (execution(* onApplicationEvent(..)) && !execution(* onApplicationEvent(org.springframework.web.context.support.RequestHandledEvent))) || execution(* org.springframework.beans.factory.FactoryBean+.*(..))")
    public void springHooksPointcut() {
    }

    String calculatePointcut(String target) {
        return target.replaceAll("\\(\\)", "").replaceAll("\\)", "").replaceAll("\\(", ".");
    }

    String createSignature(MethodSignature signature) {
        return signature.getDeclaringTypeName() + "." + signature.getMethod().getName();
    }
}

