/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.endpoints.dto.AssaultPropertiesUpdate;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="chaos.monkey.assaults")
public class AssaultProperties {
    private int level = 1;
    private int latencyRangeStart = 1000;
    private int latencyRangeEnd = 3000;
    private boolean latencyActive = false;
    private boolean exceptionsActive = false;
    private AssaultException exception;
    private boolean killApplicationActive = false;
    private String killApplicationCronExpression = null;
    private volatile boolean memoryActive = false;
    private int memoryMillisecondsHoldFilledMemory = 90000;
    private int memoryMillisecondsWaitNextIncrease = 1000;
    private double memoryFillIncrementFraction = 0.15;
    private double memoryFillTargetFraction = 0.25;
    private String memoryCronExpression = null;
    private volatile boolean cpuActive = false;
    private int cpuMillisecondsHoldLoad = 90000;
    private double cpuLoadTargetFraction = 0.9;
    private String cpuCronExpression = null;
    @Deprecated
    private String runtimeAssaultCronExpression = "OFF";
    private List<String> watchedCustomServices;

    public AssaultException getException() {
        return this.exception == null ? new AssaultException() : this.exception;
    }

    public void setException(AssaultException exception) {
        this.exception = exception;
    }

    @JsonIgnore
    public int getTroubleRandom() {
        return ThreadLocalRandom.current().nextInt(1, this.getLevel() + 1);
    }

    @JsonIgnore
    public int chooseAssault(int amount) {
        return ThreadLocalRandom.current().nextInt(0, amount);
    }

    @JsonIgnore
    public boolean isWatchedCustomServicesActive() {
        return !CollectionUtils.isEmpty(this.watchedCustomServices);
    }

    public AssaultPropertiesUpdate toDto() {
        ObjectMapper mapper = new ObjectMapper();
        return (AssaultPropertiesUpdate)mapper.convertValue((Object)this, AssaultPropertiesUpdate.class);
    }

    public int getLevel() {
        return this.level;
    }

    public int getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    public int getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    public boolean isLatencyActive() {
        return this.latencyActive;
    }

    public boolean isExceptionsActive() {
        return this.exceptionsActive;
    }

    public boolean isKillApplicationActive() {
        return this.killApplicationActive;
    }

    public String getKillApplicationCronExpression() {
        return this.killApplicationCronExpression;
    }

    public boolean isMemoryActive() {
        return this.memoryActive;
    }

    public int getMemoryMillisecondsHoldFilledMemory() {
        return this.memoryMillisecondsHoldFilledMemory;
    }

    public int getMemoryMillisecondsWaitNextIncrease() {
        return this.memoryMillisecondsWaitNextIncrease;
    }

    public double getMemoryFillIncrementFraction() {
        return this.memoryFillIncrementFraction;
    }

    public double getMemoryFillTargetFraction() {
        return this.memoryFillTargetFraction;
    }

    public String getMemoryCronExpression() {
        return this.memoryCronExpression;
    }

    public boolean isCpuActive() {
        return this.cpuActive;
    }

    public int getCpuMillisecondsHoldLoad() {
        return this.cpuMillisecondsHoldLoad;
    }

    public double getCpuLoadTargetFraction() {
        return this.cpuLoadTargetFraction;
    }

    public String getCpuCronExpression() {
        return this.cpuCronExpression;
    }

    @Deprecated
    public String getRuntimeAssaultCronExpression() {
        return this.runtimeAssaultCronExpression;
    }

    public List<String> getWatchedCustomServices() {
        return this.watchedCustomServices;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLatencyRangeStart(int latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    public void setLatencyRangeEnd(int latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    public void setLatencyActive(boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    public void setExceptionsActive(boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    public void setKillApplicationActive(boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    public void setKillApplicationCronExpression(String killApplicationCronExpression) {
        this.killApplicationCronExpression = killApplicationCronExpression;
    }

    public void setMemoryActive(boolean memoryActive) {
        this.memoryActive = memoryActive;
    }

    public void setMemoryMillisecondsHoldFilledMemory(int memoryMillisecondsHoldFilledMemory) {
        this.memoryMillisecondsHoldFilledMemory = memoryMillisecondsHoldFilledMemory;
    }

    public void setMemoryMillisecondsWaitNextIncrease(int memoryMillisecondsWaitNextIncrease) {
        this.memoryMillisecondsWaitNextIncrease = memoryMillisecondsWaitNextIncrease;
    }

    public void setMemoryFillIncrementFraction(double memoryFillIncrementFraction) {
        this.memoryFillIncrementFraction = memoryFillIncrementFraction;
    }

    public void setMemoryFillTargetFraction(double memoryFillTargetFraction) {
        this.memoryFillTargetFraction = memoryFillTargetFraction;
    }

    public void setMemoryCronExpression(String memoryCronExpression) {
        this.memoryCronExpression = memoryCronExpression;
    }

    public void setCpuActive(boolean cpuActive) {
        this.cpuActive = cpuActive;
    }

    public void setCpuMillisecondsHoldLoad(int cpuMillisecondsHoldLoad) {
        this.cpuMillisecondsHoldLoad = cpuMillisecondsHoldLoad;
    }

    public void setCpuLoadTargetFraction(double cpuLoadTargetFraction) {
        this.cpuLoadTargetFraction = cpuLoadTargetFraction;
    }

    public void setCpuCronExpression(String cpuCronExpression) {
        this.cpuCronExpression = cpuCronExpression;
    }

    @Deprecated
    public void setRuntimeAssaultCronExpression(String runtimeAssaultCronExpression) {
        this.runtimeAssaultCronExpression = runtimeAssaultCronExpression;
    }

    public void setWatchedCustomServices(List<String> watchedCustomServices) {
        this.watchedCustomServices = watchedCustomServices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultProperties)) {
            return false;
        }
        AssaultProperties other = (AssaultProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getLatencyRangeStart() != other.getLatencyRangeStart()) {
            return false;
        }
        if (this.getLatencyRangeEnd() != other.getLatencyRangeEnd()) {
            return false;
        }
        if (this.isLatencyActive() != other.isLatencyActive()) {
            return false;
        }
        if (this.isExceptionsActive() != other.isExceptionsActive()) {
            return false;
        }
        if (this.isKillApplicationActive() != other.isKillApplicationActive()) {
            return false;
        }
        if (this.isMemoryActive() != other.isMemoryActive()) {
            return false;
        }
        if (this.getMemoryMillisecondsHoldFilledMemory() != other.getMemoryMillisecondsHoldFilledMemory()) {
            return false;
        }
        if (this.getMemoryMillisecondsWaitNextIncrease() != other.getMemoryMillisecondsWaitNextIncrease()) {
            return false;
        }
        if (Double.compare(this.getMemoryFillIncrementFraction(), other.getMemoryFillIncrementFraction()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryFillTargetFraction(), other.getMemoryFillTargetFraction()) != 0) {
            return false;
        }
        if (this.isCpuActive() != other.isCpuActive()) {
            return false;
        }
        if (this.getCpuMillisecondsHoldLoad() != other.getCpuMillisecondsHoldLoad()) {
            return false;
        }
        if (Double.compare(this.getCpuLoadTargetFraction(), other.getCpuLoadTargetFraction()) != 0) {
            return false;
        }
        AssaultException this$exception = this.getException();
        AssaultException other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception)) {
            return false;
        }
        String this$killApplicationCronExpression = this.getKillApplicationCronExpression();
        String other$killApplicationCronExpression = other.getKillApplicationCronExpression();
        if (this$killApplicationCronExpression == null ? other$killApplicationCronExpression != null : !this$killApplicationCronExpression.equals(other$killApplicationCronExpression)) {
            return false;
        }
        String this$memoryCronExpression = this.getMemoryCronExpression();
        String other$memoryCronExpression = other.getMemoryCronExpression();
        if (this$memoryCronExpression == null ? other$memoryCronExpression != null : !this$memoryCronExpression.equals(other$memoryCronExpression)) {
            return false;
        }
        String this$cpuCronExpression = this.getCpuCronExpression();
        String other$cpuCronExpression = other.getCpuCronExpression();
        if (this$cpuCronExpression == null ? other$cpuCronExpression != null : !this$cpuCronExpression.equals(other$cpuCronExpression)) {
            return false;
        }
        String this$runtimeAssaultCronExpression = this.getRuntimeAssaultCronExpression();
        String other$runtimeAssaultCronExpression = other.getRuntimeAssaultCronExpression();
        if (this$runtimeAssaultCronExpression == null ? other$runtimeAssaultCronExpression != null : !this$runtimeAssaultCronExpression.equals(other$runtimeAssaultCronExpression)) {
            return false;
        }
        List<String> this$watchedCustomServices = this.getWatchedCustomServices();
        List<String> other$watchedCustomServices = other.getWatchedCustomServices();
        return !(this$watchedCustomServices == null ? other$watchedCustomServices != null : !((Object)this$watchedCustomServices).equals(other$watchedCustomServices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getLatencyRangeStart();
        result = result * 59 + this.getLatencyRangeEnd();
        result = result * 59 + (this.isLatencyActive() ? 79 : 97);
        result = result * 59 + (this.isExceptionsActive() ? 79 : 97);
        result = result * 59 + (this.isKillApplicationActive() ? 79 : 97);
        result = result * 59 + (this.isMemoryActive() ? 79 : 97);
        result = result * 59 + this.getMemoryMillisecondsHoldFilledMemory();
        result = result * 59 + this.getMemoryMillisecondsWaitNextIncrease();
        long $memoryFillIncrementFraction = Double.doubleToLongBits(this.getMemoryFillIncrementFraction());
        result = result * 59 + (int)($memoryFillIncrementFraction >>> 32 ^ $memoryFillIncrementFraction);
        long $memoryFillTargetFraction = Double.doubleToLongBits(this.getMemoryFillTargetFraction());
        result = result * 59 + (int)($memoryFillTargetFraction >>> 32 ^ $memoryFillTargetFraction);
        result = result * 59 + (this.isCpuActive() ? 79 : 97);
        result = result * 59 + this.getCpuMillisecondsHoldLoad();
        long $cpuLoadTargetFraction = Double.doubleToLongBits(this.getCpuLoadTargetFraction());
        result = result * 59 + (int)($cpuLoadTargetFraction >>> 32 ^ $cpuLoadTargetFraction);
        AssaultException $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
        String $killApplicationCronExpression = this.getKillApplicationCronExpression();
        result = result * 59 + ($killApplicationCronExpression == null ? 43 : $killApplicationCronExpression.hashCode());
        String $memoryCronExpression = this.getMemoryCronExpression();
        result = result * 59 + ($memoryCronExpression == null ? 43 : $memoryCronExpression.hashCode());
        String $cpuCronExpression = this.getCpuCronExpression();
        result = result * 59 + ($cpuCronExpression == null ? 43 : $cpuCronExpression.hashCode());
        String $runtimeAssaultCronExpression = this.getRuntimeAssaultCronExpression();
        result = result * 59 + ($runtimeAssaultCronExpression == null ? 43 : $runtimeAssaultCronExpression.hashCode());
        List<String> $watchedCustomServices = this.getWatchedCustomServices();
        result = result * 59 + ($watchedCustomServices == null ? 43 : ((Object)$watchedCustomServices).hashCode());
        return result;
    }

    public String toString() {
        return "AssaultProperties(level=" + this.getLevel() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.isLatencyActive() + ", exceptionsActive=" + this.isExceptionsActive() + ", exception=" + this.getException() + ", killApplicationActive=" + this.isKillApplicationActive() + ", killApplicationCronExpression=" + this.getKillApplicationCronExpression() + ", memoryActive=" + this.isMemoryActive() + ", memoryMillisecondsHoldFilledMemory=" + this.getMemoryMillisecondsHoldFilledMemory() + ", memoryMillisecondsWaitNextIncrease=" + this.getMemoryMillisecondsWaitNextIncrease() + ", memoryFillIncrementFraction=" + this.getMemoryFillIncrementFraction() + ", memoryFillTargetFraction=" + this.getMemoryFillTargetFraction() + ", memoryCronExpression=" + this.getMemoryCronExpression() + ", cpuActive=" + this.isCpuActive() + ", cpuMillisecondsHoldLoad=" + this.getCpuMillisecondsHoldLoad() + ", cpuLoadTargetFraction=" + this.getCpuLoadTargetFraction() + ", cpuCronExpression=" + this.getCpuCronExpression() + ", runtimeAssaultCronExpression=" + this.getRuntimeAssaultCronExpression() + ", watchedCustomServices=" + this.getWatchedCustomServices() + ")";
    }
}

