/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRuntimeScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyScheduler;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.endpoints.AssaultPropertiesUpdate;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeySettingsDto;
import de.codecentric.spring.boot.chaos.monkey.endpoints.WatcherPropertiesUpdate;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestControllerEndpoint(enableByDefault=false, id="chaosmonkey")
public class ChaosMonkeyRestEndpoint {
    private final ChaosMonkeySettings chaosMonkeySettings;
    private final ChaosMonkeyRuntimeScope runtimeScope;
    private final ChaosMonkeyScheduler scheduler;

    public ChaosMonkeyRestEndpoint(ChaosMonkeySettings chaosMonkeySettings, ChaosMonkeyRuntimeScope runtimeScope, ChaosMonkeyScheduler scheduler) {
        this.chaosMonkeySettings = chaosMonkeySettings;
        this.runtimeScope = runtimeScope;
        this.scheduler = scheduler;
    }

    @PostMapping(value={"/assaults"})
    public ResponseEntity<String> updateAssaultProperties(@RequestBody @Validated AssaultPropertiesUpdate assaultProperties) {
        assaultProperties.applyTo(this.chaosMonkeySettings.getAssaultProperties());
        this.scheduler.reloadConfig();
        return ResponseEntity.ok().body((Object)"Assault config has changed");
    }

    @PostMapping(value={"/assaults/runtime/attack"})
    public ResponseEntity<String> attack() {
        this.runtimeScope.callChaosMonkey();
        return ResponseEntity.ok((Object)"Started runtime assaults");
    }

    @GetMapping(value={"/assaults"})
    public AssaultPropertiesUpdate getAssaultSettings() {
        return this.chaosMonkeySettings.getAssaultProperties().toDto();
    }

    @PostMapping(value={"/enable"})
    public ResponseEntity<String> enableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(true);
        return ResponseEntity.ok().body((Object)"Chaos Monkey is enabled");
    }

    @PostMapping(value={"/disable"})
    public ResponseEntity<String> disableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(false);
        return ResponseEntity.ok().body((Object)"Chaos Monkey is disabled");
    }

    @GetMapping
    public ChaosMonkeySettingsDto status() {
        return this.chaosMonkeySettings.toDto();
    }

    @GetMapping(value={"/status"})
    public ResponseEntity<String> getStatus() {
        if (this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"Ready to be evil!");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body((Object)"You switched me off!");
    }

    @PostMapping(value={"/watchers"})
    public ResponseEntity<String> updateWatcherProperties(@RequestBody @Validated WatcherPropertiesUpdate watcherProperties) {
        watcherProperties.applyTo(this.chaosMonkeySettings.getWatcherProperties());
        this.scheduler.reloadConfig();
        return ResponseEntity.ok().body((Object)"Watcher config has changed");
    }

    @GetMapping(value={"/watchers"})
    public WatcherProperties getWatcherSettings() {
        return this.chaosMonkeySettings.getWatcherProperties();
    }
}

