/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="chaos.monkey.assaults")
public class AssaultProperties {
    @Value(value="${level : 5}")
    @Min(value=1L)
    @Max(value=10L)
    private @Min(value=1L) @Max(value=10L) int level;
    @Value(value="${latencyRangeStart : 1000}")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int latencyRangeStart;
    @Value(value="${latencyRangeEnd : 3000}")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int latencyRangeEnd;
    @Value(value="${latencyActive : true}")
    private boolean latencyActive;
    @Value(value="${exceptionsActive : false}")
    private boolean exceptionsActive;
    @Value(value="${killApplicationActive : false}")
    private boolean killApplicationActive;

    @JsonIgnore
    public int getTroubleRandom() {
        return RandomUtils.nextInt((int)1, (int)11);
    }

    @JsonIgnore
    public int chooseAssault(int amount) {
        return RandomUtils.nextInt((int)1, (int)(amount + 1));
    }

    public int getLevel() {
        return this.level;
    }

    public int getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    public int getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    public boolean isLatencyActive() {
        return this.latencyActive;
    }

    public boolean isExceptionsActive() {
        return this.exceptionsActive;
    }

    public boolean isKillApplicationActive() {
        return this.killApplicationActive;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLatencyRangeStart(int latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    public void setLatencyRangeEnd(int latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    public void setLatencyActive(boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    public void setExceptionsActive(boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    public void setKillApplicationActive(boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    public String toString() {
        return "AssaultProperties(level=" + this.getLevel() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.isLatencyActive() + ", exceptionsActive=" + this.isExceptionsActive() + ", killApplicationActive=" + this.isKillApplicationActive() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultProperties)) {
            return false;
        }
        AssaultProperties other = (AssaultProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getLatencyRangeStart() != other.getLatencyRangeStart()) {
            return false;
        }
        if (this.getLatencyRangeEnd() != other.getLatencyRangeEnd()) {
            return false;
        }
        if (this.isLatencyActive() != other.isLatencyActive()) {
            return false;
        }
        if (this.isExceptionsActive() != other.isExceptionsActive()) {
            return false;
        }
        return this.isKillApplicationActive() == other.isKillApplicationActive();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getLatencyRangeStart();
        result = result * 59 + this.getLatencyRangeEnd();
        result = result * 59 + (this.isLatencyActive() ? 79 : 97);
        result = result * 59 + (this.isExceptionsActive() ? 79 : 97);
        result = result * 59 + (this.isKillApplicationActive() ? 79 : 97);
        return result;
    }
}

