/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="chaos.monkey.assaults")
public class AssaultProperties {
    @Value(value="${level : 5}")
    private int level;
    @Value(value="${latencyRangeStart : 3000}")
    private int latencyRangeStart;
    @Value(value="${latencyRangeEnd : 15000}")
    private int latencyRangeEnd;
    @Value(value="${latencyActive : true}")
    private boolean latencyActive;
    @Value(value="${exceptionsActive : false}")
    private boolean exceptionsActive;
    @Value(value="${killApplicationActive : false}")
    private boolean killApplicationActive;
    @Value(value="${restartApplicationActive : false}")
    private boolean restartApplicationActive;

    @JsonIgnore
    public int getTroubleRandom() {
        return RandomUtils.nextInt((int)0, (int)10);
    }

    @JsonIgnore
    public int getExceptionRandom() {
        return RandomUtils.nextInt((int)0, (int)10);
    }

    public int getLevel() {
        return this.level;
    }

    public int getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    public int getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    public boolean isLatencyActive() {
        return this.latencyActive;
    }

    public boolean isExceptionsActive() {
        return this.exceptionsActive;
    }

    public boolean isKillApplicationActive() {
        return this.killApplicationActive;
    }

    public boolean isRestartApplicationActive() {
        return this.restartApplicationActive;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLatencyRangeStart(int latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    public void setLatencyRangeEnd(int latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    public void setLatencyActive(boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    public void setExceptionsActive(boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    public void setKillApplicationActive(boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    public void setRestartApplicationActive(boolean restartApplicationActive) {
        this.restartApplicationActive = restartApplicationActive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultProperties)) {
            return false;
        }
        AssaultProperties other = (AssaultProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getLatencyRangeStart() != other.getLatencyRangeStart()) {
            return false;
        }
        if (this.getLatencyRangeEnd() != other.getLatencyRangeEnd()) {
            return false;
        }
        if (this.isLatencyActive() != other.isLatencyActive()) {
            return false;
        }
        if (this.isExceptionsActive() != other.isExceptionsActive()) {
            return false;
        }
        if (this.isKillApplicationActive() != other.isKillApplicationActive()) {
            return false;
        }
        return this.isRestartApplicationActive() == other.isRestartApplicationActive();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getLatencyRangeStart();
        result = result * 59 + this.getLatencyRangeEnd();
        result = result * 59 + (this.isLatencyActive() ? 79 : 97);
        result = result * 59 + (this.isExceptionsActive() ? 79 : 97);
        result = result * 59 + (this.isKillApplicationActive() ? 79 : 97);
        result = result * 59 + (this.isRestartApplicationActive() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AssaultProperties(level=" + this.getLevel() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.isLatencyActive() + ", exceptionsActive=" + this.isExceptionsActive() + ", killApplicationActive=" + this.isKillApplicationActive() + ", restartApplicationActive=" + this.isRestartApplicationActive() + ")";
    }
}

