/*
 * Decompiled with CFR 0.152.
 */
package de.cketti.safecontentresolver;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.os.Bundle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class DisallowedProviders {
    private static final String META_DATA_KEY_ALLOW_INTERNAL_ACCESS = "de.cketti.safecontentresolver.ALLOW_INTERNAL_ACCESS";
    private final Context context;
    private Set<String> disallowedAuthorities;

    DisallowedProviders(Context context) {
        this.context = context;
    }

    synchronized boolean isDisallowed(String authority) {
        if (this.disallowedAuthorities == null) {
            this.disallowedAuthorities = this.findDisallowedContentProviderAuthorities();
        }
        return this.disallowedAuthorities.contains(authority);
    }

    private Set<String> findDisallowedContentProviderAuthorities() {
        ProviderInfo[] providers = this.getProviderInfo(this.context);
        HashSet<String> disallowedAuthorities = new HashSet<String>(providers.length);
        for (ProviderInfo providerInfo : providers) {
            if (this.isContentProviderAllowed(providerInfo)) continue;
            String[] authorities = providerInfo.authority.split(";");
            Collections.addAll(disallowedAuthorities, authorities);
        }
        return disallowedAuthorities;
    }

    private ProviderInfo[] getProviderInfo(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 136);
            ProviderInfo[] providers = packageInfo.providers;
            return providers != null ? providers : new ProviderInfo[]{};
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isContentProviderAllowed(ProviderInfo providerInfo) {
        Bundle metaData = providerInfo.metaData;
        return metaData != null && metaData.getBoolean(META_DATA_KEY_ALLOW_INTERNAL_ACCESS, false);
    }
}

