/*
 * Decompiled with CFR 0.152.
 */
package de.cketti.mailto;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Patterns;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class EmailIntentBuilder {
    private final Context context;
    private final Set<String> to = new LinkedHashSet<String>();
    private final Set<String> cc = new LinkedHashSet<String>();
    private final Set<String> bcc = new LinkedHashSet<String>();
    private String subject;
    private String body;

    private EmailIntentBuilder(@NotNull Context context) {
        this.context = EmailIntentBuilder.checkNotNull(context);
    }

    @NotNull
    public static EmailIntentBuilder from(@NotNull Context context) {
        return new EmailIntentBuilder(context);
    }

    @NotNull
    public EmailIntentBuilder to(@NotNull String to) {
        this.checkEmail(to);
        this.to.add(to);
        return this;
    }

    @NotNull
    public EmailIntentBuilder to(@NotNull Collection<String> to) {
        EmailIntentBuilder.checkNotNull(to);
        for (String email : to) {
            this.checkEmail(email);
        }
        this.to.addAll(to);
        return this;
    }

    @NotNull
    public EmailIntentBuilder cc(@NotNull String cc) {
        this.checkEmail(cc);
        this.cc.add(cc);
        return this;
    }

    @NotNull
    public EmailIntentBuilder cc(@NotNull Collection<String> cc) {
        EmailIntentBuilder.checkNotNull(cc);
        for (String email : cc) {
            this.checkEmail(email);
        }
        this.cc.addAll(cc);
        return this;
    }

    @NotNull
    public EmailIntentBuilder bcc(@NotNull String bcc) {
        this.checkEmail(bcc);
        this.bcc.add(bcc);
        return this;
    }

    @NotNull
    public EmailIntentBuilder bcc(@NotNull Collection<String> bcc) {
        EmailIntentBuilder.checkNotNull(bcc);
        for (String email : bcc) {
            this.checkEmail(email);
        }
        this.bcc.addAll(bcc);
        return this;
    }

    @NotNull
    public EmailIntentBuilder subject(@NotNull String subject) {
        EmailIntentBuilder.checkNotNull(subject);
        this.checkNoLineBreaks(subject);
        this.subject = subject;
        return this;
    }

    @NotNull
    public EmailIntentBuilder body(@NotNull String body) {
        EmailIntentBuilder.checkNotNull(body);
        this.body = EmailIntentBuilder.fixLineBreaks(body);
        return this;
    }

    public boolean start() {
        Intent emailIntent = this.build();
        try {
            this.startActivity(emailIntent);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private void startActivity(Intent intent) {
        if (!(this.context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        this.context.startActivity(intent);
    }

    @NotNull
    public Intent build() {
        Uri mailtoUri = this.constructMailtoUri();
        return new Intent("android.intent.action.SENDTO", mailtoUri);
    }

    @NotNull
    private Uri constructMailtoUri() {
        StringBuilder mailto = new StringBuilder(1024);
        mailto.append("mailto:");
        this.addRecipients(mailto, this.to);
        boolean hasQueryParameters = this.addRecipientQueryParameters(mailto, "cc", this.cc, false);
        hasQueryParameters = this.addRecipientQueryParameters(mailto, "bcc", this.bcc, hasQueryParameters);
        hasQueryParameters = this.addQueryParameter(mailto, "subject", this.subject, hasQueryParameters);
        this.addQueryParameter(mailto, "body", this.body, hasQueryParameters);
        return Uri.parse((String)mailto.toString());
    }

    private boolean addQueryParameter(StringBuilder mailto, String field, String value, boolean hasQueryParameters) {
        if (value == null) {
            return hasQueryParameters;
        }
        mailto.append(hasQueryParameters ? (char)'&' : '?').append(field).append('=').append(Uri.encode((String)value));
        return true;
    }

    private boolean addRecipientQueryParameters(StringBuilder mailto, String field, Set<String> recipients, boolean hasQueryParameters) {
        if (recipients.isEmpty()) {
            return hasQueryParameters;
        }
        mailto.append(hasQueryParameters ? (char)'&' : '?').append(field).append('=');
        this.addRecipients(mailto, recipients);
        return true;
    }

    private void addRecipients(StringBuilder mailto, Set<String> recipients) {
        if (recipients.isEmpty()) {
            return;
        }
        for (String recipient : recipients) {
            mailto.append(EmailIntentBuilder.encodeRecipient(recipient));
            mailto.append(',');
        }
        mailto.setLength(mailto.length() - 1);
    }

    private void checkEmail(String email) {
        EmailIntentBuilder.checkNotNull(email);
        if (!Patterns.EMAIL_ADDRESS.matcher(email).matches()) {
            throw new IllegalArgumentException("Argument is not a valid email address (according to Patterns.EMAIL_ADDRESS)");
        }
    }

    private void checkNoLineBreaks(String text) {
        boolean containsLineFeed;
        boolean containsCarriageReturn = text.indexOf(13) != -1;
        boolean bl = containsLineFeed = text.indexOf(10) != -1;
        if (containsCarriageReturn || containsLineFeed) {
            throw new IllegalArgumentException("Argument must not contain line breaks");
        }
    }

    @NotNull
    private static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        return object;
    }

    @NotNull
    static String encodeRecipient(String recipient) {
        int index = recipient.lastIndexOf(64);
        String localPart = recipient.substring(0, index);
        String host = recipient.substring(index + 1);
        return Uri.encode((String)localPart) + "@" + Uri.encode((String)host);
    }

    @NotNull
    static String fixLineBreaks(String text) {
        return text.replaceAll("\r\n", "\n").replace('\r', '\n').replaceAll("\n", "\r\n");
    }
}

