/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cidaas.jwt.JWT;
import de.cidaas.jwt.Options;
import de.cidaas.oauth.cache.LRUCache;
import de.cidaas.oauth.interceptor.Constants;
import de.cidaas.oauth.interceptor.OAuthScopes;
import de.cidaas.oauth.model.ResolvedUserInfoFromToken;
import de.cidaas.oauth.model.TokenCheckEntity;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TokenHelper.class);
    LRUCache tokenCache = LRUCache.getInstance();

    public TokenCheckEntity validateAccessToken(TokenCheckEntity tokenInfo, Method method, String access_token) {
        if (StringUtils.isEmpty((CharSequence)access_token)) {
            tokenInfo.setSuccess(false);
            return tokenInfo;
        }
        if (access_token.contains(".")) {
            LOG.info("JWT Token Try to resolve from local");
            String[] pieses = access_token.split("\\.");
            if (pieses.length == 5 && StringUtils.isEmpty((CharSequence)Constants.get_private_key_path())) {
                return this.validateAccessTokenFromServer(tokenInfo, method, access_token);
            }
            return this.validateAccessTokenLocal(tokenInfo, method, access_token);
        }
        return this.validateAccessTokenFromServer(tokenInfo, method, access_token);
    }

    private TokenCheckEntity validateAccessTokenFromServer(TokenCheckEntity tokenInfo, Method method, String accessToken) {
        ResolvedUserInfoFromToken userInfo = null;
        try {
            userInfo = this.getUserInfoByToken(tokenInfo);
            if (userInfo == null) {
                LOG.info("No userid found for accesstoken, {} ", (Object)accessToken);
                tokenInfo.setSuccess(false);
                return tokenInfo;
            }
            tokenInfo.setUserId(userInfo.getUserId());
            tokenInfo.setClientId(userInfo.getClientId());
            this.tokenCache.put(accessToken.hashCode(), new Date().getTime());
        }
        catch (IOException | HttpException ex) {
            LOG.error("OAuth-Exception ", ex);
            tokenInfo.setSuccess(false);
            return tokenInfo;
        }
        catch (Exception ex) {
            LOG.error("Exception ", (Throwable)ex);
            tokenInfo.setSuccess(false);
            return tokenInfo;
        }
        tokenInfo.setSuccess(true);
        tokenInfo.setNeedServerSubmit(false);
        return tokenInfo;
    }

    private TokenCheckEntity validateAccessTokenLocal(TokenCheckEntity tokenInfo, Method method, String access_token) {
        String[] rolesRequired;
        String[] scopesRequired;
        Map<String, Object> claims = this.parseAccessToken(access_token);
        if (claims == null) {
            LOG.info("claims cannot be null ");
            tokenInfo.setSuccess(false);
            tokenInfo.setRequestedScopes(this.getAnotationRequestedScopeJoined(method));
            tokenInfo.setRequestedRoles(this.getAnotationRequestedRolesJoined(method));
            return tokenInfo;
        }
        String exp = null;
        if (claims.containsKey("exp")) {
            exp = claims.get("exp").toString();
        }
        if (exp == null) {
            tokenInfo.setSuccess(false);
            LOG.info("exp cannot be null ");
            return tokenInfo;
        }
        if (!this.validateToken(exp)) {
            tokenInfo.setSuccess(false);
            return tokenInfo;
        }
        String userId = null;
        if (claims.containsKey("sub")) {
            userId = claims.get("sub").toString();
        }
        if (StringUtils.isEmpty(userId)) {
            LOG.info("sub cannot be null ");
            tokenInfo.setSuccess(false);
            return tokenInfo;
        }
        tokenInfo.setUserId(userId);
        if (!this.tokenCache.isPresent(access_token)) {
            return this.validateAccessTokenFromServer(tokenInfo, method, access_token);
        }
        String clientId = null;
        if (claims.containsKey("clientid")) {
            clientId = claims.get("clientid").toString();
        }
        if (StringUtils.isEmpty(clientId)) {
            LOG.info("clientid cannot be null ");
            tokenInfo.setSuccess(false);
            return tokenInfo;
        }
        tokenInfo.setClientId(clientId);
        String scopes = "";
        if (claims.containsKey("scope")) {
            scopes = claims.get("scope").toString();
        }
        if ((scopesRequired = this.getAnotationRequestedScope(method)) != null && scopesRequired.length > 0) {
            tokenInfo.setRequestedScopes(this.getAnotationRequestedScopeJoined(method));
            tokenInfo.setAllowedScopes(scopes);
            List<String> scopesAllowedInToken = Arrays.asList(scopes.split(" "));
            if (!this.validateScope(scopesRequired, scopesAllowedInToken)) {
                LOG.info("Scope validation failed, Requested scopes {}, Allowed Scopes {} ", (Object)tokenInfo.getRequestedScopes(), (Object)tokenInfo.getAllowedScopes());
                tokenInfo.setSuccess(false);
                return tokenInfo;
            }
        }
        String roles = "";
        if (claims.containsKey("role")) {
            roles = claims.get("role").toString();
        }
        if ((rolesRequired = this.getAnotationRequestedRoles(method)) != null && rolesRequired.length > 0) {
            tokenInfo.setRequestedRoles(this.getAnotationRequestedRolesJoined(method));
            tokenInfo.setAllowedRoles(roles);
            List<String> rolesAllowedInToken = Arrays.asList(roles.split(","));
            if (!this.validateRole(rolesRequired, rolesAllowedInToken)) {
                LOG.info("Role validation failed, Requested Roles {}, Allowed Roles {} ", (Object)tokenInfo.getRequestedRoles(), (Object)tokenInfo.getAllowedRoles());
                tokenInfo.setSuccess(false);
                return tokenInfo;
            }
        }
        tokenInfo.setSuccess(true);
        return tokenInfo;
    }

    protected String getAnotationRequestedScopeJoined(Method method) {
        String[] scopes = this.getAnotationRequestedScope(method);
        if (scopes != null && scopes.length > 0) {
            return StringUtils.join((Object[])this.getAnotationRequestedScope(method), (String)" ");
        }
        return null;
    }

    protected String[] getAnotationRequestedScope(Method method) {
        OAuthScopes oAuthScopes;
        if (method.isAnnotationPresent(OAuthScopes.class) && (oAuthScopes = method.getAnnotation(OAuthScopes.class)) != null && oAuthScopes.scopes().length > 0) {
            return oAuthScopes.scopes();
        }
        return null;
    }

    protected String getAnotationRequestedRolesJoined(Method method) {
        Object[] roles = this.getAnotationRequestedRoles(method);
        if (roles != null && roles.length > 0) {
            return StringUtils.join((Object[])roles, (String)",");
        }
        return null;
    }

    protected String[] getAnotationRequestedRoles(Method method) {
        RolesAllowed rolesAnnotation;
        if (method.isAnnotationPresent(RolesAllowed.class) && (rolesAnnotation = method.getAnnotation(RolesAllowed.class)) != null && rolesAnnotation.value().length > 0) {
            return rolesAnnotation.value();
        }
        return null;
    }

    public boolean validateToken(Object exp) {
        long expireTime = 0L;
        if (exp instanceof Date) {
            expireTime = ((Date)exp).getTime();
        } else {
            String _exp = (String)exp;
            try {
                expireTime = Long.parseLong(_exp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (expireTime == 0L) {
            return false;
        }
        long currentMillisec = System.currentTimeMillis();
        return currentMillisec < expireTime;
    }

    private Map<String, Object> parseAccessToken(String access_token) {
        block7: {
            String[] pieses = access_token.split("\\.");
            if (pieses.length == 3) {
                try {
                    return JWT.parsePlainJWT((String)access_token);
                }
                catch (Exception e) {
                    LOG.info("Error while parsing the Plain JWT token, Error : {}", (Throwable)e);
                    break block7;
                }
            }
            if (pieses.length == 5) {
                try {
                    String key_file_path = Constants.get_private_key_path();
                    if (StringUtils.isNotEmpty((CharSequence)key_file_path)) {
                        Options options = new Options();
                        options.setJWEToken(true);
                        options.setPrivateKeyPath(key_file_path);
                        return JWT.decodeJWT((String)access_token, (Options)options);
                    }
                }
                catch (Exception e) {
                    LOG.info("Error while parsing the Plain JWT token, Error : {}", (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean validateScope(String[] scopesNeededForMethod, List<String> scopesAllowedInToken) {
        if (scopesNeededForMethod == null || scopesNeededForMethod.length == 0) {
            return true;
        }
        if (scopesAllowedInToken == null || scopesAllowedInToken.size() == 0) {
            return false;
        }
        if (scopesAllowedInToken.contains("openid")) {
            return true;
        }
        boolean allowFurtherSteps = false;
        for (String scopeNeeded : scopesNeededForMethod) {
            if (!scopesAllowedInToken.stream().filter(c -> c.equalsIgnoreCase(scopeNeeded)).findFirst().isPresent()) continue;
            allowFurtherSteps = true;
            break;
        }
        return allowFurtherSteps;
    }

    private boolean validateRole(String[] rolesNeededForMethod, List<String> rolesAllowedInToken) {
        if (rolesNeededForMethod == null || rolesNeededForMethod.length == 0) {
            return true;
        }
        if (rolesAllowedInToken == null || rolesAllowedInToken.size() == 0) {
            return false;
        }
        boolean allowFurtherSteps = false;
        for (String roleNeeded : rolesNeededForMethod) {
            if (!rolesAllowedInToken.stream().filter(c -> c.equalsIgnoreCase(roleNeeded)).findFirst().isPresent()) continue;
            allowFurtherSteps = true;
            break;
        }
        return allowFurtherSteps;
    }

    private ResolvedUserInfoFromToken getUserInfoByToken(TokenCheckEntity tokenInfo) throws HttpException, ClientProtocolException, IOException, URISyntaxException {
        try {
            ObjectMapper om = new ObjectMapper();
            String uri = Constants.get_user_info_by_token();
            HttpPost resetPost = new HttpPost(new URI(uri));
            resetPost.addHeader(Constants.get_tokenKey(), tokenInfo.getAccessToken());
            if (tokenInfo != null) {
                StringEntity se = new StringEntity(om.writeValueAsString((Object)tokenInfo), ContentType.APPLICATION_JSON);
                resetPost.setEntity((HttpEntity)se);
                resetPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            }
            CloseableHttpResponse response = HttpClientBuilder.create().build().execute((HttpUriRequest)resetPost);
            int responseStatusCode = response.getStatusLine().getStatusCode();
            LOG.info("User Info By Token Status Code:" + responseStatusCode);
            if (responseStatusCode == 200) {
                om = om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                om = om.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
                return (ResolvedUserInfoFromToken)om.readValue(response.getEntity().getContent(), ResolvedUserInfoFromToken.class);
            }
            LOG.error("User id by token fails. URL : " + uri);
        }
        catch (Exception ex) {
            LOG.error("Exception at getUserInfoByToken {}", (Throwable)ex);
            throw ex;
        }
        return null;
    }
}

