/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import de.cidaas.oauth.interceptor.CBOAuthAccessResourceRequest;
import de.cidaas.oauth.interceptor.OAuthUser;
import de.cidaas.oauth.interceptor.TokenHelper;
import de.cidaas.oauth.model.TokenCheckEntity;
import de.cidaas.oauth.windowupdate.TokenWindowUpdate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class OAuthInterceptor
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthInterceptor.class);
    private static final List<MediaType> typeJson = new ArrayList<MediaType>();
    private static final List<MediaType> typeXML = new ArrayList<MediaType>();
    private static final String XML_RESPONSE_ERROR = "<error>%s</error>";
    private static final String JSON_RESPONSE_ERROR = "{\"error\":\"%s\"}";
    private static final String ACCESS_DENIED = "Access denied for this resource";
    private static final String ACCESS_FORBIDDEN = "Nobody can access this resource";

    public void filter(ContainerRequestContext requestContext) {
        LOG.info("Filtering request to: {}", (Object)requestContext.getUriInfo().getAbsolutePath().toString());
        TokenWindowUpdate tokenWindowUpdate = TokenWindowUpdate.getInstance();
        ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)requestContext.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
        Method method = methodInvoker.getMethod();
        if (method.getDeclaringClass().getName().equals("io.swagger.jaxrs.listing.ApiListingResource") && method.getName().equals("getListing")) {
            LOG.info("Swagger Request URL:" + method.getName());
            return;
        }
        if (method.isAnnotationPresent(PermitAll.class)) {
            LOG.info("Method has PermitAll:" + method.getName());
            return;
        }
        if (method.isAnnotationPresent(DenyAll.class)) {
            LOG.info("Method has DenyAll:" + method.getName());
            requestContext.abortWith((Response)this.getServerResponse(methodInvoker, ACCESS_FORBIDDEN, 403));
        }
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        TokenCheckEntity requestInfo = this.prepareHeaders(request, method);
        String accessToken = null;
        try {
            CBOAuthAccessResourceRequest oauthRequest = new CBOAuthAccessResourceRequest(request);
            accessToken = oauthRequest.getAccessToken();
            LOG.info("Access Token : {}", (Object)accessToken);
            requestInfo.setAccessToken(accessToken);
        }
        catch (Exception ex) {
            LOG.error("Exception {}", (Throwable)ex);
            requestInfo.setSuccess(false);
            tokenWindowUpdate.tokenList.add(requestInfo);
            requestContext.abortWith((Response)this.getServerResponse(methodInvoker, ACCESS_DENIED, 401));
            return;
        }
        requestInfo = new TokenHelper().validateAccessToken(requestInfo, method, accessToken);
        if (requestInfo != null && requestInfo.isSuccess()) {
            OAuthUser u = new OAuthUser(accessToken, requestInfo.getUserId());
            LOG.info("Interceptor got user {} from token {}.", (Object)u.getUserId(), (Object)accessToken);
            ResteasyProviderFactory.pushContext(OAuthUser.class, (Object)u);
            if (requestInfo.isNeedServerSubmit()) {
                tokenWindowUpdate.tokenList.add(requestInfo);
            }
        } else {
            LOG.error("Access denied for URL {}", (Object)requestInfo.getRequestURL());
            LOG.info("Request Info {}", (Object)requestInfo);
            if (requestInfo.isNeedServerSubmit()) {
                tokenWindowUpdate.tokenList.add(requestInfo);
            }
            requestContext.abortWith((Response)this.getServerResponse(methodInvoker, ACCESS_DENIED, 401));
            return;
        }
    }

    private TokenCheckEntity prepareHeaders(HttpServletRequest request, Method method) {
        String requestURL;
        String browserInfo;
        String langString;
        String host;
        String ipAddress;
        TokenCheckEntity tE = new TokenCheckEntity();
        String referrer = request.getHeader("referrer");
        if (StringUtils.isNotEmpty((CharSequence)referrer)) {
            tE.setReferrer(referrer);
        }
        if ((ipAddress = request.getHeader("X-FORWARDED-FOR")) == null) {
            ipAddress = request.getRemoteAddr();
        }
        if (ipAddress != null && ipAddress.contains(",")) {
            ipAddress = ipAddress.split(",")[0];
        }
        if (StringUtils.isNotEmpty((CharSequence)ipAddress)) {
            tE.setIpAddress(ipAddress);
        }
        if ((host = request.getHeader("X-Forwarded-Host")) == null) {
            host = request.getRemoteHost();
        }
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            tE.setHost(host);
        }
        if (StringUtils.isNotEmpty((CharSequence)(langString = request.getHeader("Accept-Language")))) {
            tE.setAcceptLanguage(langString);
        }
        if (StringUtils.isNotEmpty((CharSequence)(browserInfo = request.getHeader("user-agent")))) {
            tE.setUserAgent(browserInfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(requestURL = request.getRequestURL().toString()))) {
            tE.setRequestURL(requestURL);
        }
        TokenHelper th = new TokenHelper();
        tE.setRequestedScopes(th.getAnotationRequestedScopeJoined(method));
        tE.setRequestedRoles(th.getAnotationRequestedRolesJoined(method));
        tE.setRequestInfo(new HashMap<String, String>());
        ArrayList<String> allHeaders = Collections.list(request.getHeaderNames());
        for (String headerKey : allHeaders) {
            tE.getRequestInfo().put(headerKey, request.getHeader(headerKey));
        }
        return tE;
    }

    private ServerResponse getServerResponse(ResourceMethodInvoker methodInvoker, Object entity, int status) {
        if (methodInvoker.doesProduce(typeJson)) {
            return new ServerResponse((Object)String.format(JSON_RESPONSE_ERROR, entity), status, new Headers());
        }
        if (methodInvoker.doesProduce(typeXML)) {
            return new ServerResponse((Object)String.format(XML_RESPONSE_ERROR, entity), status, new Headers());
        }
        return new ServerResponse(entity, status, new Headers());
    }

    static {
        typeJson.add(MediaType.APPLICATION_JSON_TYPE);
        typeXML.add(MediaType.APPLICATION_XML_TYPE);
        typeXML.add(MediaType.APPLICATION_ATOM_XML_TYPE);
        typeXML.add(MediaType.TEXT_XML_TYPE);
    }
}

