package de.cidaas.oauth.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class TokenCheckEntity implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String accessToken;
	private String userId;
	private String clientId;
	private String referrer;
	private String ipAddress;
	private String host;
	private String acceptLanguage;
	private String userAgent;
	private String requestURL;
	private boolean success;
	private String requestedScopes;
	private String allowedScopes;
	private String requestedRoles;
	private String allowedRoles;
	private Date createdTime;
	private String factEventType;
	private boolean needServerSubmit;
	private Map<String,String> requestInfo;

	public TokenCheckEntity() {
		this.createdTime = new Date();
		this.factEventType = "TOKEN_CHECKED";
		this.needServerSubmit = true;
	}

	/**
	 * @return the accessToken
	 */
	public String getAccessToken() {
		return accessToken;
	}

	/**
	 * @param accessToken
	 *            the accessToken to set
	 */
	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	/**
	 * @return the userId
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * @param userId
	 *            the userId to set
	 */
	public void setUserId(String userId) {
		this.userId = userId;
	}

	/**
	 * @return the clientId
	 */
	public String getClientId() {
		return clientId;
	}

	/**
	 * @param clientId
	 *            the clientId to set
	 */
	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	/**
	 * @return the referrer
	 */
	public String getReferrer() {
		return referrer;
	}

	/**
	 * @param referrer
	 *            the referrer to set
	 */
	public void setReferrer(String referrer) {
		this.referrer = referrer;
	}

	/**
	 * @return the ipAddress
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * @param ipAddress
	 *            the ipAddress to set
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * @return the host
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host
	 *            the host to set
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return the acceptLanguage
	 */
	public String getAcceptLanguage() {
		return acceptLanguage;
	}

	/**
	 * @param acceptLanguage
	 *            the acceptLanguage to set
	 */
	public void setAcceptLanguage(String acceptLanguage) {
		this.acceptLanguage = acceptLanguage;
	}

	/**
	 * @return the userAgent
	 */
	public String getUserAgent() {
		return userAgent;
	}

	/**
	 * @param userAgent
	 *            the userAgent to set
	 */
	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	/**
	 * @return the requestURL
	 */
	public String getRequestURL() {
		return requestURL;
	}

	/**
	 * @param requestURL
	 *            the requestURL to set
	 */
	public void setRequestURL(String requestURL) {
		this.requestURL = requestURL;
	}

	/**
	 * @return the success
	 */
	public boolean isSuccess() {
		return success;
	}

	/**
	 * @param success
	 *            the success to set
	 */
	public void setSuccess(boolean success) {
		this.success = success;
	}

	/**
	 * @return the requestedScopes
	 */
	public String getRequestedScopes() {
		return requestedScopes;
	}

	/**
	 * @param requestedScopes
	 *            the requestedScopes to set
	 */
	public void setRequestedScopes(String requestedScopes) {
		this.requestedScopes = requestedScopes;
	}

	/**
	 * @return the requestedRoles
	 */
	public String getRequestedRoles() {
		return requestedRoles;
	}

	/**
	 * @param requestedRoles
	 *            the requestedRoles to set
	 */
	public void setRequestedRoles(String requestedRoles) {
		this.requestedRoles = requestedRoles;
	}

	/**
	 * @return the createdTime
	 */
	public Date getCreatedTime() {
		return createdTime;
	}

	/**
	 * @param createdTime
	 *            the createdTime to set
	 */
	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	/**
	 * @return the serialversionuid
	 */
	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	
	
	/**
	 * @return the allowedScopes
	 */
	public String getAllowedScopes() {
		return allowedScopes;
	}

	/**
	 * @param allowedScopes the allowedScopes to set
	 */
	public void setAllowedScopes(String allowedScopes) {
		this.allowedScopes = allowedScopes;
	}

	/**
	 * @return the allowedRoles
	 */
	public String getAllowedRoles() {
		return allowedRoles;
	}

	/**
	 * @param allowedRoles the allowedRoles to set
	 */
	public void setAllowedRoles(String allowedRoles) {
		this.allowedRoles = allowedRoles;
	}

	/**
	 * @return the factEventType
	 */
	public String getFactEventType() {
		return factEventType;
	}

	/**
	 * @param factEventType the factEventType to set
	 */
	public void setFactEventType(String factEventType) {
		this.factEventType = factEventType;
	}
	

	public boolean isNeedServerSubmit() {
		return needServerSubmit;
	}

	public void setNeedServerSubmit(boolean needServerSubmit) {
		this.needServerSubmit = needServerSubmit;
	}

	
	
	public Map<String, String> getRequestInfo() {
		return requestInfo;
	}

	public void setRequestInfo(Map<String, String> requestInfo) {
		this.requestInfo = requestInfo;
	}

	@Override
	public String toString() {
		return "TokenCheckEntity [accessToken=" + accessToken + ", userId=" + userId + ", clientId=" + clientId
				+ ", referrer=" + referrer + ", ipAddress=" + ipAddress + ", host=" + host + ", acceptLanguage="
				+ acceptLanguage + ", userAgent=" + userAgent + ", requestURL=" + requestURL + ", success=" + success
				+ ", requestedScopes=" + requestedScopes + ", allowedScopes=" + allowedScopes + ", requestedRoles="
				+ requestedRoles + ", allowedRoles=" + allowedRoles + ", createdTime=" + createdTime
				+ ", factEventType=" + factEventType + ", needServerSubmit=" + needServerSubmit + ", requestInfo="
				+ requestInfo + "]";
	}

}
