/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.jwt;

import de.cidaas.jwt.Options;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class JWTHelper {
    public static Map<String, Object> encodedPayload(Map<String, Object> _claims, Options options) throws Exception {
        HashMap<String, Object> claims = new HashMap<String, Object>(_claims);
        JWTHelper.enforceStringOrURI(claims, "iss");
        JWTHelper.enforceStringOrURI(claims, "sub");
        JWTHelper.enforceStringOrURICollection(claims, "aud");
        JWTHelper.enforceIntDate(claims, "exp");
        JWTHelper.enforceIntDate(claims, "nbf");
        JWTHelper.enforceIntDate(claims, "iat");
        JWTHelper.enforceString(claims, "jti");
        JWTHelper.processPayloadOptions(claims, options);
        return claims;
    }

    public static void processPayloadOptions(Map<String, Object> claims, Options options) {
        long now = System.currentTimeMillis() / 1000L;
        if (options.getNotValidBeforeLeeway() != null) {
            claims.put("nbf", now - (long)options.getNotValidBeforeLeeway().intValue());
        }
        claims.put("iat", now);
        claims.put("jti", UUID.randomUUID().toString());
    }

    public static void enforceIntDate(Map<String, Object> claims, String claimName) {
        Object value = JWTHelper.handleNullValue(claims, claimName);
        if (value == null) {
            return;
        }
        if (!(value instanceof Number)) {
            throw new RuntimeException(String.format("Claim '%s' is invalid: must be an instance of Number", claimName));
        }
        long longValue = ((Number)value).longValue();
        if (longValue < 0L) {
            throw new RuntimeException(String.format("Claim '%s' is invalid: must be non-negative", claimName));
        }
        claims.put(claimName, longValue);
    }

    public static void enforceStringOrURICollection(Map<String, Object> claims, String claimName) {
        Object values = JWTHelper.handleNullValue(claims, claimName);
        if (values == null) {
            return;
        }
        if (values instanceof Collection) {
            for (Object value : (Collection)values) {
                String error = JWTHelper.checkStringOrURI(value);
                if (error == null) continue;
                throw new RuntimeException(String.format("Claim 'aud' element is invalid: %s", error));
            }
        } else {
            JWTHelper.enforceStringOrURI(claims, "aud");
        }
    }

    public static void enforceStringOrURI(Map<String, Object> claims, String claimName) {
        Object value = JWTHelper.handleNullValue(claims, claimName);
        if (value == null) {
            return;
        }
        String error = JWTHelper.checkStringOrURI(value);
        if (error != null) {
            throw new RuntimeException(String.format("Claim '%s' is invalid: %s", claimName, error));
        }
    }

    public static void enforceString(Map<String, Object> claims, String claimName) {
        Object value = JWTHelper.handleNullValue(claims, claimName);
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new RuntimeException(String.format("Claim '%s' is invalid: not a string", claimName));
        }
    }

    public static Object handleNullValue(Map<String, Object> claims, String claimName) {
        if (!claims.containsKey(claimName)) {
            return null;
        }
        Object value = claims.get(claimName);
        if (value == null) {
            claims.remove(claimName);
            return null;
        }
        return value;
    }

    public static String checkStringOrURI(Object value) {
        if (!(value instanceof String)) {
            return "not a string";
        }
        String stringOrUri = (String)value;
        if (!stringOrUri.contains(":")) {
            return null;
        }
        try {
            new URI(stringOrUri);
        }
        catch (URISyntaxException e) {
            return "not a valid URI";
        }
        return null;
    }
}

