/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.jwt;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.cidaas.jwt.Algorithm;
import de.cidaas.jwt.JWTHelper;
import de.cidaas.jwt.JWTVerifyException;
import de.cidaas.jwt.Options;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.codec.binary.Base64;

public class JWTGenerator {
    public String sign(Map<String, Object> claims, Options options) {
        Algorithm algorithm = Algorithm.HS256;
        ArrayList<String> segments = new ArrayList<String>();
        try {
            segments.add(this.encodedHeader(algorithm));
            segments.add(this.encodedPayload(claims, options));
            segments.add(this.encodedSignature(this.join(segments, "."), algorithm, options.getSecret()));
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        return this.join(segments, ".");
    }

    private String encodedHeader(Algorithm algorithm) throws UnsupportedEncodingException {
        if (algorithm == null) {
            algorithm = Algorithm.HS256;
        }
        ObjectNode header = JsonNodeFactory.instance.objectNode();
        header.put("typ", "JWT");
        header.put("alg", algorithm.name());
        return this.base64UrlEncode(header.toString().getBytes("UTF-8"));
    }

    private String encodedPayload(Map<String, Object> _claims, Options options) throws Exception {
        String payload = new ObjectMapper().writeValueAsString(JWTHelper.encodedPayload(_claims, options));
        return this.base64UrlEncode(payload.getBytes("UTF-8"));
    }

    private String encodedSignature(String signingInput, Algorithm algorithm, String secret) throws Exception {
        byte[] signature = JWTGenerator.sign(algorithm, signingInput, secret.getBytes());
        return this.base64UrlEncode(signature);
    }

    private String base64UrlEncode(byte[] str) {
        return new String(Base64.encodeBase64URLSafe((byte[])str));
    }

    private static byte[] sign(Algorithm algorithm, String msg, byte[] secret) throws Exception {
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                return JWTGenerator.signHmac(algorithm, msg, secret);
            }
        }
        throw new OperationNotSupportedException("Unsupported signing method");
    }

    private static byte[] signHmac(Algorithm algorithm, String msg, byte[] secret) throws Exception {
        Mac mac = Mac.getInstance(algorithm.getValue());
        mac.init(new SecretKeySpec(secret, algorithm.getValue()));
        return mac.doFinal(msg.getBytes());
    }

    private String join(List<String> input, String on) {
        int size = input.size();
        int count = 1;
        StringBuilder joined = new StringBuilder();
        for (String string : input) {
            joined.append(string);
            if (count < size) {
                joined.append(on);
            }
            ++count;
        }
        return joined.toString();
    }

    public Map<String, Object> verify(String jwtToken, Options options) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IOException, SignatureException, JWTVerifyException {
        if (jwtToken == null || "".equals(jwtToken)) {
            throw new IllegalStateException("token not set");
        }
        String[] pieces = jwtToken.split("\\.");
        if (pieces.length != 3) {
            throw new IllegalStateException("Wrong number of segments: " + pieces.length);
        }
        JsonNode jwtHeader = JWTGenerator.decodeAndParse(pieces[0]);
        String algorithm = JWTGenerator.getAlgorithm(jwtHeader);
        JsonNode jwtPayload = JWTGenerator.decodeAndParse(pieces[1]);
        if (JWTGenerator.verifySignature(pieces, algorithm, options.getSecret())) {
            return (Map)new ObjectMapper().treeToValue((TreeNode)jwtPayload, Map.class);
        }
        return null;
    }

    public Map<String, Object> parse(String jwtToken) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IOException, SignatureException, JWTVerifyException {
        if (jwtToken == null || "".equals(jwtToken)) {
            throw new IllegalStateException("token not set");
        }
        String[] pieces = jwtToken.split("\\.");
        if (pieces.length != 3) {
            throw new IllegalStateException("Wrong number of segments: " + pieces.length);
        }
        JsonNode jwtPayload = JWTGenerator.decodeAndParse(pieces[1]);
        return (Map)new ObjectMapper().treeToValue((TreeNode)jwtPayload, Map.class);
    }

    static boolean verifySignature(String[] pieces, String algorithm, String secret) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Mac hmac = Mac.getInstance(algorithm);
        hmac.init(new SecretKeySpec(secret.getBytes(), algorithm));
        byte[] sig = hmac.doFinal((pieces[0] + "." + pieces[1]).getBytes());
        return MessageDigest.isEqual(sig, Base64.decodeBase64((String)pieces[2]));
    }

    static String getAlgorithm(JsonNode jwtHeader) {
        String algorithmName;
        HashMap<String, String> algorithms = new HashMap<String, String>();
        algorithms.put("HS256", "HmacSHA256");
        algorithms.put("HS384", "HmacSHA384");
        algorithms.put("HS512", "HmacSHA512");
        String string = algorithmName = jwtHeader.has("alg") ? jwtHeader.get("alg").asText() : null;
        if (jwtHeader.get("alg") == null) {
            throw new IllegalStateException("algorithm not set");
        }
        if (algorithms.get(algorithmName) == null) {
            throw new IllegalStateException("unsupported algorithm");
        }
        return (String)algorithms.get(algorithmName);
    }

    static JsonNode decodeAndParse(String b64String) throws IOException {
        String jsonString = new String(Base64.decodeBase64((String)b64String), "UTF-8");
        JsonNode jwtHeader = (JsonNode)new ObjectMapper().readValue(jsonString, JsonNode.class);
        return jwtHeader;
    }
}

