/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.jwt;

import de.cidaas.jwt.JWEGenerator;
import de.cidaas.jwt.JWTGenerator;
import de.cidaas.jwt.Options;
import java.util.Map;

public class JWT {
    public static String getJWT(Map<String, Object> claims, Options options) throws Exception {
        if (options.isJWEToken()) {
            if (options.getPublicKey() != null && options.getPublicKey().trim().length() > 0 || options.getPrivateKeyPath() != null && options.getPrivateKeyPath().trim().length() > 0) {
                return new JWEGenerator().sign(claims, options);
            }
            return null;
        }
        if (options.getSecret() != null && options.getSecret().trim().length() > 0) {
            return new JWTGenerator().sign(claims, options);
        }
        return null;
    }

    public static Map<String, Object> parsePlainJWT(String jwtToken) throws Exception {
        return new JWTGenerator().parse(jwtToken);
    }

    public static Map<String, Object> decodeJWT(String jwtToken, Options options) throws Exception {
        if (options.isJWEToken()) {
            if (options.getPrivateKey() != null && options.getPrivateKey().trim().length() > 0 || options.getPrivateKeyPath() != null && options.getPrivateKeyPath().trim().length() > 0) {
                return new JWEGenerator().verify(jwtToken, options);
            }
            return null;
        }
        if (options.getSecret() != null && options.getSecret().trim().length() > 0) {
            return new JWTGenerator().verify(jwtToken, options);
        }
        return null;
    }
}

