/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.jwt;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.crypto.bc.BouncyCastleProviderSingleton;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import de.cidaas.jwt.JWTHelper;
import de.cidaas.jwt.Options;
import de.cidaas.jwt.RSAKeyHelper;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;

public class JWEGenerator {
    public String sign(Map<String, Object> claims, Options options) throws Exception {
        RSAPublicKey publicKey = null;
        if (options.getPublicKey() != null && options.getPublicKey().trim().length() > 0) {
            publicKey = RSAKeyHelper.parsePublicKey(options.getPublicKey());
        } else if (options.getPublicKeyPath() != null && options.getPublicKeyPath().trim().length() > 0) {
            publicKey = RSAKeyHelper.getPublicKey(options.getPublicKeyPath());
        }
        if (publicKey == null) {
            return null;
        }
        claims = JWTHelper.encodedPayload(claims, options);
        JWTClaimsSet.Builder claimBuilder = new JWTClaimsSet.Builder();
        for (Map.Entry<String, Object> entry : claims.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            claimBuilder.claim(key, value);
        }
        JWTClaimsSet jwtClaims = claimBuilder.build();
        JWEHeader header = new JWEHeader(JWEAlgorithm.RSA_OAEP, EncryptionMethod.A128GCM);
        EncryptedJWT jwt = new EncryptedJWT(header, jwtClaims);
        RSAEncrypter encrypter = new RSAEncrypter(publicKey);
        encrypter.getJCAContext().setProvider((Provider)BouncyCastleProviderSingleton.getInstance());
        jwt.encrypt((JWEEncrypter)encrypter);
        String jwtString = jwt.serialize();
        System.out.println(jwtString);
        return jwtString;
    }

    public Map<String, Object> verify(String jwtString, Options options) throws Exception {
        RSAPrivateKey privateKey = null;
        if (options.getPrivateKey() != null && options.getPrivateKey().trim().length() > 0) {
            privateKey = RSAKeyHelper.parsePrivateKey(options.getPrivateKey());
        } else if (options.getPrivateKeyPath() != null && options.getPrivateKeyPath().trim().length() > 0) {
            privateKey = RSAKeyHelper.getPrivateKey(options.getPrivateKeyPath());
        }
        if (privateKey == null) {
            return null;
        }
        EncryptedJWT jwt = EncryptedJWT.parse((String)jwtString);
        RSADecrypter decrypter = new RSADecrypter((PrivateKey)privateKey);
        decrypter.getJCAContext().setProvider((Provider)BouncyCastleProviderSingleton.getInstance());
        jwt.decrypt((JWEDecrypter)decrypter);
        if (jwt.getPayload() == null) {
            return null;
        }
        JSONObject json = jwt.getPayload().toJSONObject();
        if (json == null) {
            throw new ParseException("Payload of JWE object is not a valid JSON object", 0);
        }
        HashMap<String, Object> claims = new HashMap<String, Object>();
        for (String name : json.keySet()) {
            claims.put(name, json.get((Object)name));
        }
        return claims;
    }
}

